/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.EnumSkyBlock;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatList;

public class BlockSnow
extends Block {
    protected BlockSnow(int id, int texture) {
        super(id, texture, Material.snow);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setTickOnLoad(true);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int var2, int var3, int var4) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.375f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess blockAccess, int xCoord, int yCoord, int zCoord) {
        int metadata = blockAccess.getBlockMetadata(xCoord, yCoord, zCoord) & 7;
        float addedHeight = (float)(2 * (1 + metadata)) / 16.0f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, addedHeight, 1.0f);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int xCoord, int yCoord, int zCoord) {
        int blockBelow = world.getBlockId(xCoord, yCoord - 1, zCoord);
        return blockBelow != 0 && Block.blocksList[blockBelow].isOpaqueCube() || world.getBlockMaterial(xCoord, yCoord - 1, zCoord).getIsSolid() || blockBelow == Block.leaves.blockID || blockBelow == Block.leavesFir.blockID;
    }

    @Override
    public void onNeighborBlockChange(World var1, int var2, int var3, int var4, int var5) {
        this.func_314_h(var1, var2, var3, var4);
    }

    private boolean func_314_h(World world, int var2, int var3, int var4) {
        if (!this.canPlaceBlockAt(world, var2, var3, var4)) {
            this.dropBlockAsItem(world, var2, var3, var4, world.getBlockMetadata(var2, var3, var4));
            world.setBlockWithNotify(var2, var3, var4, 0);
            return false;
        }
        return true;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer player, int xCoord, int yCoord, int zCoord, int metadata) {
        if (!world.multiplayerWorld && player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().itemID == Item.shovelGold.itemID) {
            player.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(world, xCoord, yCoord, zCoord, new ItemStack(Block.snowPile.blockID, 1, 0));
        } else {
            int itemDropped = Item.snowball.itemID;
            float itemPosHelper = 0.7f;
            double xRand = (double)(world.rand.nextFloat() * itemPosHelper) + (double)(1.0f - itemPosHelper) * 0.5;
            double yRand = (double)(world.rand.nextFloat() * itemPosHelper) + (double)(1.0f - itemPosHelper) * 0.5;
            double zRand = (double)(world.rand.nextFloat() * itemPosHelper) + (double)(1.0f - itemPosHelper) * 0.5;
            EntityItem itemEntity = new EntityItem(world, (double)xCoord + xRand, (double)yCoord + yRand, (double)zCoord + zRand, new ItemStack(itemDropped, 1, 0));
            itemEntity.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(itemEntity);
            world.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
            player.addStat(StatList.mineBlockStatArray[this.blockID], 1);
        }
    }

    @Override
    public int idDropped(int damageMetadata, Random rand) {
        return Item.snowball.itemID;
    }

    @Override
    public int quantityDropped(Random rand) {
        return 0;
    }

    @Override
    public void updateTick(World var1, int var2, int var3, int var4, Random var5) {
        if (var1.getSavedLightValue(EnumSkyBlock.Block, var2, var3, var4) > 11) {
            this.dropBlockAsItem(var1, var2, var3, var4, var1.getBlockMetadata(var2, var3, var4));
            var1.setBlockWithNotify(var2, var3, var4, 0);
        }
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        return var5 == 1 ? true : super.shouldSideBeRendered(var1, var2, var3, var4, var5);
    }

    @Override
    public boolean blockActivated(World var1, int var2, int var3, int var4, EntityPlayer var5) {
        int metadata = var1.getBlockMetadata(var2, var3, var4) & 7;
        if (!var1.multiplayerWorld && metadata < 7) {
            if (var5.getCurrentEquippedItem() != null && var5.getCurrentEquippedItem().itemID == this.blockID) {
                if (!var5.capabilities.depleteItems) {
                    --var5.getCurrentEquippedItem().stackSize;
                }
                var1.playSoundEffect((float)var2 + 0.5f, (float)var3 + 0.5f, (float)var4 + 0.5f, this.stepSound.func_1145_d(), (this.stepSound.getVolume() + 1.0f) / 2.0f, this.stepSound.getPitch() * 0.8f);
                this.addLayer(var1, var2, var3, var4, var5, metadata);
                return true;
            }
            return false;
        }
        if (var5.isSneaking()) {
            return false;
        }
        return false;
    }

    private void addLayer(World var1, int var2, int var3, int var4, EntityPlayer var5, int addedMetadata) {
        var1.setBlockAndMetadataWithNotify(var2, var3, var4, this.blockID, 0);
    }
}

