/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockShelfMushroom
extends Block {
    protected BlockShelfMushroom(int var1, int var2) {
        super(var1, var2, Material.circuits);
        this.setTickOnLoad(true);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World var1, int var2, int var3, int var4) {
        this.setBlockBoundsBasedOnState(var1, var2, var3, var4);
        return super.getCollisionBoundingBoxFromPool(var1, var2, var3, var4);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World var1, int var2, int var3, int var4) {
        this.setBlockBoundsBasedOnState(var1, var2, var3, var4);
        return super.getSelectedBoundingBoxFromPool(var1, var2, var3, var4);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess var1, int var2, int var3, int var4) {
        int var7 = var1.getBlockMetadata(var2, var3, var4) & 7;
        float var8 = 0.15f;
        if (var7 == 4) {
            this.setBlockBounds(0.0f, 0.25f, 0.0f, 0.6875f, 0.75f, 1.0f);
        } else if (var7 == 2) {
            this.setBlockBounds(0.3125f, 0.25f, 0.0f, 1.0f, 0.75f, 1.0f);
        } else if (var7 == 3) {
            this.setBlockBounds(0.0f, 0.25f, 0.0f, 1.0f, 0.75f, 0.6875f);
        } else if (var7 == 1) {
            this.setBlockBounds(0.0f, 0.25f, 0.3125f, 1.0f, 0.75f, 1.0f);
        } else {
            var8 = 0.1f;
            this.setBlockBounds(0.5f - var8, 0.0f, 0.5f - var8, 0.5f + var8, 0.6f, 0.5f + var8);
        }
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 24;
    }

    @Override
    public boolean canPlaceBlockAt(World var1, int var2, int var3, int var4) {
        if (var1.isBlockNormalCube(var2 - 1, var3, var4)) {
            return true;
        }
        if (var1.isBlockNormalCube(var2 + 1, var3, var4)) {
            return true;
        }
        if (var1.isBlockNormalCube(var2, var3, var4 - 1)) {
            return true;
        }
        return var1.isBlockNormalCube(var2, var3, var4 + 1);
    }

    @Override
    public void onBlockPlaced(World var1, int var2, int var3, int var4, int var5) {
        int var6 = var1.getBlockMetadata(var2, var3, var4);
        if (var5 == 2 && var1.isBlockNormalCube(var2, var3, var4 + 1)) {
            var6 = 1;
        }
        if (var5 == 3 && var1.isBlockNormalCube(var2, var3, var4 - 1)) {
            var6 = 3;
        }
        if (var5 == 4 && var1.isBlockNormalCube(var2 + 1, var3, var4)) {
            var6 = 2;
        }
        if (var5 == 5 && var1.isBlockNormalCube(var2 - 1, var3, var4)) {
            var6 = 4;
        }
        var1.setBlockMetadataWithNotify(var2, var3, var4, var6);
    }

    @Override
    public void updateTick(World var1, int var2, int var3, int var4, Random var5) {
        super.updateTick(var1, var2, var3, var4, var5);
        if (var1.getBlockMetadata(var2, var3, var4) == 0) {
            this.onBlockAdded(var1, var2, var3, var4);
        }
    }

    @Override
    public void onBlockAdded(World var1, int var2, int var3, int var4) {
        if (var1.isBlockNormalCube(var2 - 1, var3, var4)) {
            var1.setBlockMetadataWithNotify(var2, var3, var4, 4);
        } else if (var1.isBlockNormalCube(var2 + 1, var3, var4)) {
            var1.setBlockMetadataWithNotify(var2, var3, var4, 2);
        } else if (var1.isBlockNormalCube(var2, var3, var4 - 1)) {
            var1.setBlockMetadataWithNotify(var2, var3, var4, 3);
        } else if (var1.isBlockNormalCube(var2, var3, var4 + 1)) {
            var1.setBlockMetadataWithNotify(var2, var3, var4, 1);
        }
        this.dropTorchIfCantStay(var1, var2, var3, var4);
    }

    @Override
    public void onNeighborBlockChange(World var1, int var2, int var3, int var4, int var5) {
        if (this.dropTorchIfCantStay(var1, var2, var3, var4)) {
            int var6 = var1.getBlockMetadata(var2, var3, var4);
            boolean var7 = false;
            if (!var1.isBlockNormalCube(var2 - 1, var3, var4) && var6 == 4) {
                var7 = true;
            }
            if (!var1.isBlockNormalCube(var2 + 1, var3, var4) && var6 == 2) {
                var7 = true;
            }
            if (!var1.isBlockNormalCube(var2, var3, var4 - 1) && var6 == 3) {
                var7 = true;
            }
            if (!var1.isBlockNormalCube(var2, var3, var4 + 1) && var6 == 1) {
                var7 = true;
            }
            if (var7) {
                this.dropBlockAsItem(var1, var2, var3, var4, var1.getBlockMetadata(var2, var3, var4));
                var1.setBlockWithNotify(var2, var3, var4, 0);
            }
        }
    }

    private boolean dropTorchIfCantStay(World var1, int var2, int var3, int var4) {
        if (!this.canPlaceBlockAt(var1, var2, var3, var4)) {
            this.dropBlockAsItem(var1, var2, var3, var4, var1.getBlockMetadata(var2, var3, var4));
            var1.setBlockWithNotify(var2, var3, var4, 0);
            return false;
        }
        return true;
    }

    @Override
    public void randomDisplayTick(World world, int xCoord, int yCoord, int zCoord, Random rand) {
        int f100 = 0;
        while (f100 < 2) {
            double n3;
            double n2;
            double n;
            int var7 = world.getBlockMetadata(xCoord, yCoord, zCoord) & 7;
            if (var7 == 4) {
                n = (double)xCoord + (double)rand.nextFloat() * 0.6875;
                n2 = (double)yCoord + (double)rand.nextFloat() * 0.625 + 0.25;
                n3 = (double)zCoord + (double)rand.nextFloat() * 1.0;
                world.spawnParticle("shroom", n, n2, n3, 0.0, 0.0, 0.0);
            } else if (var7 == 2) {
                n = (double)xCoord + (double)rand.nextFloat() * 0.6875 + 0.3125;
                n2 = (double)yCoord + (double)rand.nextFloat() * 0.625 + 0.25;
                n3 = (double)zCoord + (double)rand.nextFloat() * 1.0;
                world.spawnParticle("shroom", n, n2, n3, 0.0, 0.0, 0.0);
            } else if (var7 == 3) {
                n = (double)xCoord + (double)rand.nextFloat() * 1.0;
                n2 = (double)yCoord + (double)rand.nextFloat() * 0.625 + 0.25;
                n3 = (double)zCoord + (double)rand.nextFloat() * 0.6875;
                world.spawnParticle("shroom", n, n2, n3, 0.0, 0.0, 0.0);
            } else if (var7 == 1) {
                n = (double)xCoord + (double)rand.nextFloat() * 1.0;
                n2 = (double)yCoord + (double)rand.nextFloat() * 0.625 + 0.25;
                n3 = (double)zCoord + (double)rand.nextFloat() * 0.6875 + 0.3125;
                world.spawnParticle("shroom", n, n2, n3, 0.0, 0.0, 0.0);
            } else {
                n = (double)xCoord + (double)rand.nextFloat() * 1.0;
                n2 = (double)yCoord + (double)rand.nextFloat() * 1.0;
                n3 = (double)zCoord + (double)rand.nextFloat() * 1.0;
                world.spawnParticle("townaura", n, n2, n3, 0.0, 0.0, 0.0);
            }
            ++f100;
        }
    }
}

