/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockMotor;
import net.minecraft.src.game.block.RedstoneUpdateInfo;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockRedstoneTorch
extends BlockMotor {
    private boolean torchActive = false;
    private static List torchUpdates = new ArrayList();

    @Override
    public int getBlockTextureFromSideAndMetadata(int var1, int var2) {
        return var1 == 1 ? Block.gear.getBlockTextureFromSideAndMetadata(var1, var2) : super.getBlockTextureFromSideAndMetadata(var1, var2);
    }

    private boolean checkForBurnout(World var1, int var2, int var3, int var4, boolean var5) {
        if (var5) {
            torchUpdates.add(new RedstoneUpdateInfo(var2, var3, var4, var1.getWorldTime()));
        }
        int var6 = 0;
        int var7 = 0;
        while (var7 < torchUpdates.size()) {
            RedstoneUpdateInfo var8 = (RedstoneUpdateInfo)torchUpdates.get(var7);
            if (var8.x == var2 && var8.y == var3 && var8.z == var4 && ++var6 >= 8) {
                return true;
            }
            ++var7;
        }
        return false;
    }

    protected BlockRedstoneTorch(int var1, int var2, boolean var3) {
        super(var1, var2, var3);
        this.torchActive = var3;
        this.setTickOnLoad(true);
    }

    @Override
    public int tickRate() {
        return 2;
    }

    @Override
    public void onBlockAdded(World var1, int var2, int var3, int var4) {
        if (var1.getBlockMetadata(var2, var3, var4) == 0) {
            super.onBlockAdded(var1, var2, var3, var4);
        }
        if (this.torchActive) {
            var1.notifyBlocksOfNeighborChange(var2, var3 - 1, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2, var3 + 1, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2 - 1, var3, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2 + 1, var3, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2, var3, var4 - 1, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2, var3, var4 + 1, this.blockID);
        }
    }

    @Override
    public void onBlockRemoval(World var1, int var2, int var3, int var4) {
        if (this.torchActive) {
            var1.notifyBlocksOfNeighborChange(var2, var3 - 1, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2, var3 + 1, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2 - 1, var3, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2 + 1, var3, var4, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2, var3, var4 - 1, this.blockID);
            var1.notifyBlocksOfNeighborChange(var2, var3, var4 + 1, this.blockID);
        }
    }

    @Override
    public boolean isPoweringTo(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        return this.torchActive;
    }

    private boolean func_30002_h(World var1, int var2, int var3, int var4) {
        int var5 = var1.getBlockMetadata(var2, var3, var4);
        if (var1.isBlockIndirectlyProvidingPowerTo(var2, var3 - 1, var4, 0)) {
            return true;
        }
        if (var1.isBlockIndirectlyProvidingPowerTo(var2, var3, var4 - 1, 2)) {
            return true;
        }
        if (var1.isBlockIndirectlyProvidingPowerTo(var2, var3, var4 + 1, 3)) {
            return true;
        }
        if (var1.isBlockIndirectlyProvidingPowerTo(var2 - 1, var3, var4, 4)) {
            return true;
        }
        return var1.isBlockIndirectlyProvidingPowerTo(var2 + 1, var3, var4, 5);
    }

    @Override
    public void updateTick(World var1, int var2, int var3, int var4, Random var5) {
        boolean var6 = this.func_30002_h(var1, var2, var3, var4);
        while (torchUpdates.size() > 0 && var1.getWorldTime() - ((RedstoneUpdateInfo)BlockRedstoneTorch.torchUpdates.get((int)0)).updateTime > 100L) {
            torchUpdates.remove(0);
        }
        if (!this.torchActive && !var6) {
            this.checkForBurnout(var1, var2, var3, var4, false);
        }
    }

    @Override
    public void onNeighborBlockChange(World var1, int var2, int var3, int var4, int var5) {
        super.onNeighborBlockChange(var1, var2, var3, var4, var5);
        var1.scheduleBlockUpdate(var2, var3, var4, this.blockID, this.tickRate());
    }

    @Override
    public boolean isIndirectlyPoweringTo(World var1, int var2, int var3, int var4, int var5) {
        return this.isPoweringTo(var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }
}

