/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatList;

public class BlockOreCoal
extends Block {
    public BlockOreCoal(int id, int texture) {
        super(id, texture, Material.rock);
    }

    @Override
    public int idDropped(int damageMetadata, Random rand) {
        if (this.blockID == Block.oreCoal.blockID) {
            return Item.coal.itemID;
        }
        if (this.blockID == Block.oreCoalNether.blockID) {
            return Item.coal.itemID;
        }
        return this.blockID;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer thePlayer, int xCoord, int yCoord, int zCoord, int damageMetadata) {
        if (!world.multiplayerWorld && thePlayer.getCurrentEquippedItem() != null && thePlayer.getCurrentEquippedItem().itemID == Item.pickaxeGold.itemID) {
            thePlayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(world, xCoord, yCoord, zCoord, new ItemStack(this.blockID, 1, 0));
        } else if (!world.multiplayerWorld && thePlayer.getCurrentEquippedItem() != null && thePlayer.getCurrentEquippedItem().itemID == Item.pickaxeStone.itemID) {
            thePlayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(world, xCoord, yCoord, zCoord, new ItemStack(Item.coal.itemID, world.rand.nextInt(2) + 1, 0));
        } else {
            super.harvestBlock(world, thePlayer, xCoord, yCoord, zCoord, damageMetadata);
        }
    }
}

