/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockContainer;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.block.tileentity.TileEntityNote;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.level.World;

public class BlockNote
extends BlockContainer {
    public BlockNote(int id) {
        super(id, 74, Material.wood);
    }

    @Override
    public int getBlockTextureFromSide(int blockFace) {
        return this.blockIndexInTexture;
    }

    @Override
    public void onNeighborBlockChange(World world, int xCoord, int yCoord, int zCoord, int blockid) {
        if (blockid > 0 && Block.blocksList[blockid].canProvidePower()) {
            boolean powered = world.isBlockGettingPowered(xCoord, yCoord, zCoord);
            TileEntityNote blockEntity = (TileEntityNote)world.getBlockTileEntity(xCoord, yCoord, zCoord);
            if (blockEntity.previousRedstoneState != powered) {
                if (powered) {
                    blockEntity.triggerNote(world, xCoord, yCoord, zCoord);
                }
                blockEntity.previousRedstoneState = powered;
            }
        }
    }

    @Override
    public boolean blockActivated(World world, int xCoord, int yCoord, int zCoord, EntityPlayer thePlayer) {
        if (world.multiplayerWorld) {
            return true;
        }
        TileEntityNote blockEntity = (TileEntityNote)world.getBlockTileEntity(xCoord, yCoord, zCoord);
        blockEntity.changePitch();
        blockEntity.triggerNote(world, xCoord, yCoord, zCoord);
        return true;
    }

    @Override
    public void onBlockClicked(World world, int xCoord, int yCoord, int zCoord, EntityPlayer thePlayer) {
        if (!world.multiplayerWorld) {
            TileEntityNote blockEntity = (TileEntityNote)world.getBlockTileEntity(xCoord, yCoord, zCoord);
            blockEntity.triggerNote(world, xCoord, yCoord, zCoord);
        }
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityNote();
    }

    @Override
    public void playBlock(World world, int xCoord, int yCoord, int zCoord, int var5, int var6) {
        float musicpitch = (float)Math.pow(2.0, (double)(var6 - 12) / 12.0);
        String musictype = "harp";
        if (var5 == 1) {
            musictype = "bd";
        }
        if (var5 == 2) {
            musictype = "snare";
        }
        if (var5 == 3) {
            musictype = "hat";
        }
        if (var5 == 4) {
            musictype = "bassattack";
        }
        world.playSoundEffect((double)xCoord + 0.5, (double)yCoord + 0.5, (double)zCoord + 0.5, "note." + musictype, 3.0f, musicpitch);
        world.spawnParticle("note", (double)xCoord + 0.5, (double)yCoord + 1.2, (double)zCoord + 0.5, (double)var6 / 24.0, 0.0, 0.0);
    }
}

