/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockFlower;
import net.minecraft.src.game.level.World;

public class BlockMushroom
extends BlockFlower {
    protected BlockMushroom(int id, int texture) {
        super(id, texture);
        this.setBlockBounds(0.33f, 0.0f, 0.33f, 0.67f, 0.375f, 0.67f);
        if (this.blockID == 127) {
            this.setBlockBounds(0.26925f, 0.0f, 0.26925f, 0.725f, 0.5f, 0.725f);
        }
        this.setTickOnLoad(true);
    }

    @Override
    public void updateTick(World world, int xCoord, int yCoord, int zCoord, Random rand) {
        int zRand;
        int yRand;
        int xRand;
        if (rand.nextInt(100) == 0 && world.isAirBlock(xRand = xCoord + rand.nextInt(3) - 1, yRand = yCoord + rand.nextInt(2) - rand.nextInt(2), zRand = zCoord + rand.nextInt(3) - 1) && this.canBlockStay(world, xRand, yRand, zRand) && world.isAirBlock(xRand, yRand, zRand) && this.canBlockStay(world, xRand, yRand, zRand)) {
            world.setBlockWithNotify(xRand, yRand, zRand, this.blockID);
        }
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int blockid) {
        return Block.opaqueCubeLookup[blockid];
    }

    @Override
    public boolean canBlockStay(World world, int xCoord, int yCoord, int zCoord) {
        if (yCoord < 0 || yCoord >= world.field_35472_c) {
            return false;
        }
        int blockBelow = world.getBlockId(xCoord, yCoord - 1, zCoord);
        return blockBelow == Block.mycelium.blockID || world.getFullBlockLightValue(xCoord, yCoord, zCoord) < 13 && this.canThisPlantGrowOnThisBlockID(blockBelow);
    }
}

