/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockMotor
extends Block {
    private boolean motorActive = false;

    protected BlockMotor(int var1, int var2, boolean var3) {
        super(var1, var2, Material.moveableCircuit);
        this.motorActive = var3;
        this.setTickOnLoad(true);
    }

    @Override
    public int tickRate() {
        return 2;
    }

    @Override
    public boolean isPoweringTo(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        return this.motorActive;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World var1, int var2, int var3, int var4, int var5) {
        return this.isPoweringTo(var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    public void updateNeighbors(World var1, int var2, int var3, int var4) {
        var1.notifyBlocksOfNeighborChange(var2, var3 - 1, var4, this.blockID);
        var1.notifyBlocksOfNeighborChange(var2, var3 + 1, var4, this.blockID);
        var1.notifyBlocksOfNeighborChange(var2 - 1, var3, var4, this.blockID);
        var1.notifyBlocksOfNeighborChange(var2 + 1, var3, var4, this.blockID);
        var1.notifyBlocksOfNeighborChange(var2, var3, var4 - 1, this.blockID);
        var1.notifyBlocksOfNeighborChange(var2, var3, var4 + 1, this.blockID);
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return Block.motorIdle.blockID;
    }

    @Override
    public int getBlockTexture(IBlockAccess world, int n, int n2, int n3, int n4) {
        if (n4 == 1) {
            return 62;
        }
        if (n4 == 0) {
            return 62;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public final void randomDisplayTick(World world, int n, int n2, int n3, Random random) {
        if (!this.motorActive) {
            return;
        }
        int i = 0;
        while (i < 3) {
            float n4 = (float)n + random.nextFloat();
            float n5 = (float)n2 + random.nextFloat() * 0.5f + 0.5f;
            float n6 = (float)n3 + random.nextFloat();
            world.spawnParticle("smoke", n4, n5, n6, 0.0, 0.0, 0.0);
            ++i;
        }
    }

    @Override
    public boolean blockActivated(World world, int n, int n2, int n3, EntityPlayer entityPlayer) {
        if (world.multiplayerWorld) {
            world.playSoundEffect((float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, "random.wood click", 1.0f, 1.0f);
            world.spawnParticle("explode", (float)n + 0.5f, (float)n2 + 1.1f, (float)n3 + 0.5f, 0.0, 0.0, 0.0);
            return true;
        }
        if (entityPlayer.isSneaking()) {
            return false;
        }
        if (!this.motorActive) {
            this.updateNeighbors(world, n, n2, n3);
            world.playSoundEffect((float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, "random.wood click", 1.0f, 1.0f);
            world.spawnParticle("explode", (float)n + 0.5f, (float)n2 + 1.1f, (float)n3 + 0.5f, 0.0, 0.0, 0.0);
            world.setBlockWithNotify(n, n2, n3, this.blockID + 1);
            return true;
        }
        if (this.motorActive) {
            this.updateNeighbors(world, n, n2, n3);
            world.playSoundEffect((float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f, "random.wood click", 1.0f, 1.0f);
            world.spawnParticle("explode", (float)n + 0.5f, (float)n2 + 1.1f, (float)n3 + 0.5f, 0.0, 0.0, 0.0);
            world.setBlockWithNotify(n, n2, n3, this.blockID - 1);
            return true;
        }
        return false;
    }
}

