/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.BlockLeaves;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockLeavesFalling
extends BlockLeaves {
    private int baseIndexInPNG;

    protected BlockLeavesFalling(int id, int texture) {
        super(id, texture);
        this.baseIndexInPNG = texture;
        this.setTickOnLoad(true);
    }

    @Override
    public final void randomDisplayTick(World world, int xCoord, int yCoord, int zCoord, Random rand) {
        if (rand.nextInt(4) == 0) {
            double xSpawn = (double)xCoord + (double)world.rand.nextFloat() * 0.5 + 0.5;
            double zSpawn = (double)zCoord + (double)world.rand.nextFloat() * 0.5 + 0.5;
            world.spawnParticle("leaf", xSpawn, yCoord, zSpawn, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getBlockTexture(IBlockAccess blockAccess, int xCoord, int yCoord, int zCoord, int metadata) {
        if (this.graphicsLevel) {
            return 52;
        }
        return 53;
    }

    @Override
    public void setGraphicsLevel(boolean fancyLeaves) {
        this.graphicsLevel = fancyLeaves;
        this.blockIndexInTexture = this.baseIndexInPNG + (fancyLeaves ? 0 : 1);
    }

    @Override
    public boolean isOpaqueCube() {
        return !this.graphicsLevel;
    }
}

