/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.BlockLeaves;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockLeavesBlossom
extends BlockLeaves {
    private int baseIndexInPNG;

    protected BlockLeavesBlossom(int id, int texture) {
        super(id, texture);
        this.baseIndexInPNG = texture;
        this.setTickOnLoad(true);
    }

    @Override
    public void randomDisplayTick(World world, int xCoord, int yCoord, int zCoord, Random rand) {
        double zSpawn;
        double xSpawn;
        if (rand.nextInt(10) == 0 && world.getBlockId(xCoord, yCoord - 1, zCoord) == 0) {
            xSpawn = (double)xCoord + (double)rand.nextFloat() * 0.5 + 0.5;
            zSpawn = (double)zCoord + (double)rand.nextFloat() * 0.5 + 0.5;
            world.spawnParticle("blossom", xSpawn, (double)yCoord - 0.125, zSpawn, 0.0, 0.0, 0.0);
        }
        if (rand.nextInt(60) == 0 && world.getBlockId(xCoord, yCoord - 1, zCoord) == 0) {
            xSpawn = (double)xCoord + (double)rand.nextFloat() * 0.5 + 0.5;
            zSpawn = (double)zCoord + (double)rand.nextFloat() * 0.5 + 0.5;
            world.spawnParticle("leaf", xSpawn, (double)yCoord - 0.125, zSpawn, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void leavesMakeParticles(World var1, int var2, int var3, int var4) {
        double zSpawn;
        double ySpawn;
        double xSpawn;
        int itry = 0;
        while (itry < 20) {
            xSpawn = (double)var2 - ((double)var1.rand.nextFloat() * 0.5 + 0.5) + ((double)var1.rand.nextFloat() * 0.5 + 0.5) + 0.5;
            ySpawn = (double)var3 - ((double)var1.rand.nextFloat() * 0.5 + 0.5) + ((double)var1.rand.nextFloat() * 0.5 + 0.5) + 0.5;
            zSpawn = (double)var4 - ((double)var1.rand.nextFloat() * 0.5 + 0.5) + ((double)var1.rand.nextFloat() * 0.5 + 0.5) + 0.5;
            var1.spawnParticle("blossom", xSpawn, ySpawn, zSpawn, 0.0, 0.01, 0.0);
            ++itry;
        }
        itry = 0;
        while (itry < 10) {
            xSpawn = (double)var2 - ((double)var1.rand.nextFloat() * 0.5 + 0.5) + ((double)var1.rand.nextFloat() * 0.5 + 0.5) + 0.5;
            ySpawn = (double)var3 - ((double)var1.rand.nextFloat() * 0.5 + 0.5) + ((double)var1.rand.nextFloat() * 0.5 + 0.5) + 0.5;
            zSpawn = (double)var4 - ((double)var1.rand.nextFloat() * 0.5 + 0.5) + ((double)var1.rand.nextFloat() * 0.5 + 0.5) + 0.5;
            var1.spawnParticle("leaf", xSpawn, ySpawn, zSpawn, 0.0, 0.01, 0.0);
            ++itry;
        }
    }

    @Override
    public void onBlockRemoval(World var1, int var2, int var3, int var4) {
        this.leavesMakeParticles(var1, var2, var3, var4);
    }

    @Override
    public int getBlockTexture(IBlockAccess blockAccess, int xCoord, int yCoord, int zCoord, int metadata) {
        if (this.graphicsLevel) {
            return 277;
        }
        return 278;
    }

    @Override
    public void setGraphicsLevel(boolean fancyLeaves) {
        this.graphicsLevel = fancyLeaves;
        this.blockIndexInTexture = this.baseIndexInPNG + (fancyLeaves ? 0 : 1);
    }

    @Override
    public boolean isOpaqueCube() {
        return !this.graphicsLevel;
    }
}

