/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.level.World;

public class BlockLamp
extends Block {
    private final boolean powered;

    public BlockLamp(int id, boolean isActive) {
        super(id, 258, Material.lightBlock);
        this.powered = isActive;
        if (isActive) {
            this.setLightValue(1.0f);
            ++this.blockIndexInTexture;
        }
    }

    @Override
    public void onBlockAdded(World world, int xCoord, int yCoord, int zCoord) {
        if (!world.multiplayerWorld) {
            if (this.powered && !world.isBlockIndirectlyGettingPowered(xCoord, yCoord, zCoord)) {
                world.scheduleBlockUpdate(xCoord, yCoord, zCoord, this.blockID, 0);
            } else if (!this.powered && world.isBlockIndirectlyGettingPowered(xCoord, yCoord, zCoord)) {
                world.setBlockWithNotify(xCoord, yCoord, zCoord, Block.lampActive.blockID);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int xCoord, int yCoord, int zCoord, int par5) {
        if (!world.multiplayerWorld) {
            if (this.powered && !world.isBlockIndirectlyGettingPowered(xCoord, yCoord, zCoord)) {
                world.scheduleBlockUpdate(xCoord, yCoord, zCoord, this.blockID, 0);
            } else if (!this.powered && world.isBlockIndirectlyGettingPowered(xCoord, yCoord, zCoord)) {
                world.setBlockWithNotify(xCoord, yCoord, zCoord, Block.lampActive.blockID);
            }
        }
    }

    @Override
    public void updateTick(World world, int xCoord, int yCoord, int zCoord, Random par5Random) {
        if (!world.multiplayerWorld && this.powered && !world.isBlockIndirectlyGettingPowered(xCoord, yCoord, zCoord)) {
            world.setBlockWithNotify(xCoord, yCoord, zCoord, Block.lampIdle.blockID);
        }
    }

    @Override
    public int idDropped(int damageMetadata, Random rand) {
        return Block.lampIdle.blockID;
    }

    @Override
    public int idPicked(World world, int xCoord, int yCoord, int zCoord) {
        return Block.lampIdle.blockID;
    }
}

