/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockGearWait
extends Block {
    public static final double[] field_22024_a = new double[]{-0.0625, 0.0625, 0.1875, 0.3125};
    private static final int[] field_22023_b = new int[]{1, 2, 3, 4};
    private final boolean isRepeaterPowered;

    protected BlockGearWait(int var1, boolean var2) {
        super(var1, 309, Material.moveableCircuit);
        this.isRepeaterPowered = var2;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void updateTick(World var1, int var2, int var3, int var4, Random var5) {
        int var6 = var1.getBlockMetadata(var2, var3, var4);
        boolean var7 = this.func_22022_g(var1, var2, var3, var4, var6);
        if (this.isRepeaterPowered && !var7) {
            var1.setBlockAndMetadataWithNotify(var2, var3, var4, Block.gearWaitIdle.blockID, var6);
        } else if (!this.isRepeaterPowered) {
            var1.setBlockAndMetadataWithNotify(var2, var3, var4, Block.gearWaitActive.blockID, var6);
            if (!var7) {
                int var8 = (var6 & 0xC) >> 2;
                var1.scheduleBlockUpdate(var2, var3, var4, Block.gearWaitActive.blockID, field_22023_b[var8] * 2);
            }
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int var1, int var2) {
        if ((var1 == 1 && var2 == 0 || var1 == 1 && var2 == 1 || var1 == 1 && var2 == 2 || var1 == 1 && var2 == 3) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 2;
        }
        if ((var1 == 1 && var2 == 4 || var1 == 1 && var2 == 5 || var1 == 1 && var2 == 6 || var1 == 1 && var2 == 7) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 3;
        }
        if ((var1 == 1 && var2 == 8 || var1 == 1 && var2 == 9 || var1 == 1 && var2 == 10 || var1 == 1 && var2 == 11) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 4;
        }
        if ((var1 == 1 && var2 == 12 || var1 == 1 && var2 == 13 || var1 == 1 && var2 == 14 || var1 == 1 && var2 == 15) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 5;
        }
        if (var1 == 1 && var2 == 0 || var1 == 1 && var2 == 1 || var1 == 1 && var2 == 2 || var1 == 1 && var2 == 3) {
            return this.blockIndexInTexture + 2;
        }
        if (var1 == 1 && var2 == 4 || var1 == 1 && var2 == 5 || var1 == 1 && var2 == 6 || var1 == 1 && var2 == 7) {
            return this.blockIndexInTexture + 3;
        }
        if (var1 == 1 && var2 == 8 || var1 == 1 && var2 == 9 || var1 == 1 && var2 == 10 || var1 == 1 && var2 == 11) {
            return this.blockIndexInTexture + 4;
        }
        if (var1 == 1 && var2 == 12 || var1 == 1 && var2 == 13 || var1 == 1 && var2 == 14 || var1 == 1 && var2 == 15) {
            return this.blockIndexInTexture + 5;
        }
        if ((var1 == 3 && var2 == 1 || var1 == 3 && var2 == 5 || var1 == 3 && var2 == 9 || var1 == 3 && var2 == 13) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 19;
        }
        if ((var1 == 2 && var2 == 1 || var1 == 2 && var2 == 5 || var1 == 2 && var2 == 9 || var1 == 2 && var2 == 13) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 18;
        }
        if ((var1 == 4 && var2 == 1 || var1 == 4 && var2 == 5 || var1 == 4 && var2 == 9 || var1 == 4 && var2 == 13) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 16;
        }
        if ((var1 == 5 && var2 == 1 || var1 == 5 && var2 == 5 || var1 == 5 && var2 == 9 || var1 == 5 && var2 == 13) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 17;
        }
        if ((var1 == 3 && var2 == 4 || var1 == 3 && var2 == 8 || var1 == 3 && var2 == 12 || var1 == 3 && var2 == 0) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 16;
        }
        if ((var1 == 2 && var2 == 4 || var1 == 2 && var2 == 8 || var1 == 2 && var2 == 12 || var1 == 2 && var2 == 0) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 17;
        }
        if ((var1 == 4 && var2 == 4 || var1 == 4 && var2 == 8 || var1 == 4 && var2 == 12 || var1 == 4 && var2 == 0) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 18;
        }
        if ((var1 == 5 && var2 == 4 || var1 == 5 && var2 == 8 || var1 == 5 && var2 == 12 || var1 == 5 && var2 == 0) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 19;
        }
        if ((var1 == 3 && var2 == 3 || var1 == 3 && var2 == 7 || var1 == 3 && var2 == 11 || var1 == 3 && var2 == 15) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 18;
        }
        if ((var1 == 2 && var2 == 3 || var1 == 2 && var2 == 7 || var1 == 2 && var2 == 11 || var1 == 2 && var2 == 15) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 19;
        }
        if ((var1 == 4 && var2 == 3 || var1 == 4 && var2 == 7 || var1 == 4 && var2 == 11 || var1 == 4 && var2 == 15) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 17;
        }
        if ((var1 == 5 && var2 == 3 || var1 == 5 && var2 == 7 || var1 == 5 && var2 == 11 || var1 == 5 && var2 == 15) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 16;
        }
        if ((var1 == 3 && var2 == 2 || var1 == 3 && var2 == 6 || var1 == 3 && var2 == 10 || var1 == 3 && var2 == 14) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 17;
        }
        if ((var1 == 2 && var2 == 2 || var1 == 2 && var2 == 6 || var1 == 2 && var2 == 10 || var1 == 2 && var2 == 14) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 16;
        }
        if ((var1 == 4 && var2 == 2 || var1 == 4 && var2 == 6 || var1 == 4 && var2 == 10 || var1 == 4 && var2 == 14) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 19;
        }
        if ((var1 == 5 && var2 == 2 || var1 == 5 && var2 == 6 || var1 == 5 && var2 == 10 || var1 == 5 && var2 == 14) && this.isRepeaterPowered) {
            return this.blockIndexInTexture + 18;
        }
        if (var1 == 3 && var2 == 1 || var1 == 3 && var2 == 5 || var1 == 3 && var2 == 9 || var1 == 3 && var2 == 13) {
            return this.blockIndexInTexture + 1;
        }
        if (var1 == 2 && var2 == 1 || var1 == 2 && var2 == 5 || var1 == 2 && var2 == 9 || var1 == 2 && var2 == 13) {
            return this.blockIndexInTexture;
        }
        if (var1 == 4 && var2 == 1 || var1 == 4 && var2 == 5 || var1 == 4 && var2 == 9 || var1 == 4 && var2 == 13) {
            return this.blockIndexInTexture + 16;
        }
        if (var1 == 5 && var2 == 1 || var1 == 5 && var2 == 5 || var1 == 5 && var2 == 9 || var1 == 5 && var2 == 13) {
            return this.blockIndexInTexture + 17;
        }
        if (var1 == 3 && var2 == 4 || var1 == 3 && var2 == 8 || var1 == 3 && var2 == 12 || var1 == 3 && var2 == 0) {
            return this.blockIndexInTexture + 16;
        }
        if (var1 == 2 && var2 == 4 || var1 == 2 && var2 == 8 || var1 == 2 && var2 == 12 || var1 == 2 && var2 == 0) {
            return this.blockIndexInTexture + 17;
        }
        if (var1 == 4 && var2 == 4 || var1 == 4 && var2 == 8 || var1 == 4 && var2 == 12 || var1 == 4 && var2 == 0) {
            return this.blockIndexInTexture;
        }
        if (var1 == 5 && var2 == 4 || var1 == 5 && var2 == 8 || var1 == 5 && var2 == 12 || var1 == 5 && var2 == 0) {
            return this.blockIndexInTexture + 1;
        }
        if (var1 == 3 && var2 == 3 || var1 == 3 && var2 == 7 || var1 == 3 && var2 == 11 || var1 == 3 && var2 == 15) {
            return this.blockIndexInTexture;
        }
        if (var1 == 2 && var2 == 3 || var1 == 2 && var2 == 7 || var1 == 2 && var2 == 11 || var1 == 2 && var2 == 15) {
            return this.blockIndexInTexture + 1;
        }
        if (var1 == 4 && var2 == 3 || var1 == 4 && var2 == 7 || var1 == 4 && var2 == 11 || var1 == 4 && var2 == 15) {
            return this.blockIndexInTexture + 17;
        }
        if (var1 == 5 && var2 == 3 || var1 == 5 && var2 == 7 || var1 == 5 && var2 == 11 || var1 == 5 && var2 == 15) {
            return this.blockIndexInTexture + 16;
        }
        if (var1 == 3 && var2 == 2 || var1 == 3 && var2 == 6 || var1 == 3 && var2 == 10 || var1 == 3 && var2 == 14) {
            return this.blockIndexInTexture + 17;
        }
        if (var1 == 2 && var2 == 2 || var1 == 2 && var2 == 6 || var1 == 2 && var2 == 10 || var1 == 2 && var2 == 14) {
            return this.blockIndexInTexture + 16;
        }
        if (var1 == 4 && var2 == 2 || var1 == 4 && var2 == 6 || var1 == 4 && var2 == 10 || var1 == 4 && var2 == 14) {
            return this.blockIndexInTexture + 1;
        }
        if (var1 == 5 && var2 == 2 || var1 == 5 && var2 == 6 || var1 == 5 && var2 == 10 || var1 == 5 && var2 == 14) {
            return this.blockIndexInTexture;
        }
        if (var1 == 0) {
            return 6;
        }
        return 309;
    }

    @Override
    public int getRenderType() {
        return 15;
    }

    @Override
    public int getBlockTextureFromSide(int var1) {
        switch (var1) {
            case 0: {
                return 6;
            }
            case 1: {
                return this.blockIndexInTexture + 2;
            }
            case 2: {
                return this.blockIndexInTexture + 16;
            }
            case 3: {
                return this.blockIndexInTexture + 17;
            }
            case 4: {
                return this.blockIndexInTexture + 1;
            }
            case 5: {
                return this.blockIndexInTexture;
            }
        }
        return 309;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World var1, int var2, int var3, int var4, int var5) {
        return this.isPoweringTo(var1, var2, var3, var4, var5);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        if (!this.isRepeaterPowered) {
            return false;
        }
        int var6 = var1.getBlockMetadata(var2, var3, var4) & 3;
        if (var6 == 0 && var5 == 3) {
            return true;
        }
        if (var6 == 1 && var5 == 4) {
            return true;
        }
        if (var6 == 2 && var5 == 2) {
            return true;
        }
        return var6 == 3 && var5 == 5;
    }

    @Override
    public void onNeighborBlockChange(World var1, int var2, int var3, int var4, int var5) {
        if (!this.canBlockStay(var1, var2, var3, var4)) {
            this.dropBlockAsItem(var1, var2, var3, var4, var1.getBlockMetadata(var2, var3, var4));
            var1.setBlockWithNotify(var2, var3, var4, 0);
        } else {
            int var6 = var1.getBlockMetadata(var2, var3, var4);
            boolean var7 = this.func_22022_g(var1, var2, var3, var4, var6);
            int var8 = (var6 & 0xC) >> 2;
            if (this.isRepeaterPowered && !var7) {
                var1.scheduleBlockUpdate(var2, var3, var4, this.blockID, field_22023_b[var8] * 2);
            } else if (!this.isRepeaterPowered && var7) {
                var1.scheduleBlockUpdate(var2, var3, var4, this.blockID, field_22023_b[var8] * 2);
            }
        }
    }

    private boolean func_22022_g(World var1, int var2, int var3, int var4, int var5) {
        int var6 = var5 & 3;
        switch (var6) {
            case 0: {
                return var1.isBlockIndirectlyProvidingPowerTo(var2, var3, var4 + 1, 3) || var1.getBlockId(var2, var3, var4 + 1) == Block.gear.blockID && var1.getBlockMetadata(var2, var3, var4 + 1) > 0;
            }
            case 1: {
                return var1.isBlockIndirectlyProvidingPowerTo(var2 - 1, var3, var4, 4) || var1.getBlockId(var2 - 1, var3, var4) == Block.gear.blockID && var1.getBlockMetadata(var2 - 1, var3, var4) > 0;
            }
            case 2: {
                return var1.isBlockIndirectlyProvidingPowerTo(var2, var3, var4 - 1, 2) || var1.getBlockId(var2, var3, var4 - 1) == Block.gear.blockID && var1.getBlockMetadata(var2, var3, var4 - 1) > 0;
            }
            case 3: {
                return var1.isBlockIndirectlyProvidingPowerTo(var2 + 1, var3, var4, 5) || var1.getBlockId(var2 + 1, var3, var4) == Block.gear.blockID && var1.getBlockMetadata(var2 + 1, var3, var4) > 0;
            }
        }
        return false;
    }

    @Override
    public boolean blockActivated(World var1, int var2, int var3, int var4, EntityPlayer var5) {
        if (var5.isSneaking()) {
            return false;
        }
        if (var1.multiplayerWorld) {
            return true;
        }
        int var6 = var1.getBlockMetadata(var2, var3, var4);
        int var7 = (var6 & 0xC) >> 2;
        var7 = var7 + 1 << 2 & 0xC;
        var1.setBlockMetadataWithNotify(var2, var3, var4, var7 | var6 & 3);
        return true;
    }

    @Override
    public boolean canProvidePower() {
        return false;
    }

    @Override
    public void onBlockPlacedBy(World var1, int var2, int var3, int var4, EntityLiving var5) {
        int var60 = MathHelper.floor_double((double)(var5.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (var60 == 3) {
            var1.setBlockMetadataWithNotify(var2, var3, var4, 1);
        } else if (var60 == 2) {
            var1.setBlockMetadataWithNotify(var2, var3, var4, 0);
        } else if (var60 == 1) {
            var1.setBlockMetadataWithNotify(var2, var3, var4, 3);
        } else if (var60 == 0) {
            var1.setBlockMetadataWithNotify(var2, var3, var4, 2);
        }
        boolean var7 = this.func_22022_g(var1, var2, var3, var4, var60);
        if (var7) {
            var1.scheduleBlockUpdate(var2, var3, var4, this.blockID, 1);
        }
    }

    @Override
    public void onBlockAdded(World var1, int var2, int var3, int var4) {
        var1.notifyBlocksOfNeighborChange(var2 + 1, var3, var4, this.blockID);
        var1.notifyBlocksOfNeighborChange(var2 - 1, var3, var4, this.blockID);
        var1.notifyBlocksOfNeighborChange(var2, var3, var4 + 1, this.blockID);
        var1.notifyBlocksOfNeighborChange(var2, var3, var4 - 1, this.blockID);
        var1.notifyBlocksOfNeighborChange(var2, var3 - 1, var4, this.blockID);
        var1.notifyBlocksOfNeighborChange(var2, var3 + 1, var4, this.blockID);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int idDropped(int var1, Random var2) {
        return Block.gearWaitIdle.blockID;
    }
}

