/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockFence
extends Block {
    protected boolean fenceType = true;

    public BlockFence(int i, int j) {
        super(i, j, Material.wood);
    }

    public BlockFence(int i, int j, Material material) {
        super(i, material);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        return super.canPlaceBlockAt(world, i, j, k);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int var1, int var2) {
        if (this.blockID == Block.fenceRock.blockID) {
            switch (var2) {
                case 0: {
                    this.blockIndexInTexture = Block.brickBasalt.blockIndexInTexture;
                    return this.blockIndexInTexture;
                }
                case 1: {
                    this.blockIndexInTexture = Block.cobblestone.blockIndexInTexture;
                    return this.blockIndexInTexture;
                }
                case 2: {
                    this.blockIndexInTexture = Block.mossyCobblestone.blockIndexInTexture;
                    return this.blockIndexInTexture;
                }
            }
            return this.blockIndexInTexture;
        }
        return 4;
    }

    @Override
    protected int damageDropped(int var1) {
        return var1;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        boolean flag = this.isFenceAt(world, i, j, k - 1);
        boolean flag1 = this.isFenceAt(world, i, j, k + 1);
        boolean flag2 = this.isFenceAt(world, i - 1, j, k);
        boolean flag3 = this.isFenceAt(world, i + 1, j, k);
        float f = 0.375f;
        float f1 = 0.625f;
        float f2 = 0.375f;
        float f3 = 0.625f;
        if (flag) {
            f2 = 0.0f;
        }
        if (flag1) {
            f3 = 1.0f;
        }
        if (flag2) {
            f = 0.0f;
        }
        if (flag3) {
            f1 = 1.0f;
        }
        return AxisAlignedBB.getBoundingBoxFromPool((float)i + f, j, (float)k + f2, (float)i + f1, (float)j + 1.5f, (float)k + f3);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        boolean flag = this.isFenceAt(iblockaccess, i, j, k - 1);
        boolean flag1 = this.isFenceAt(iblockaccess, i, j, k + 1);
        boolean flag2 = this.isFenceAt(iblockaccess, i - 1, j, k);
        boolean flag3 = this.isFenceAt(iblockaccess, i + 1, j, k);
        float f = 0.375f;
        float f1 = 0.625f;
        float f2 = 0.375f;
        float f3 = 0.625f;
        if (flag) {
            f2 = 0.0f;
        }
        if (flag1) {
            f3 = 1.0f;
        }
        if (flag2) {
            f = 0.0f;
        }
        if (flag3) {
            f1 = 1.0f;
        }
        this.setBlockBounds(f, 0.0f, f2, f1, 1.0f, f3);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 11;
    }

    public boolean isFenceAt(IBlockAccess iblockaccess, int i, int j, int k) {
        int l = iblockaccess.getBlockId(i, j, k);
        if (l == Block.fence.blockID || l == Block.fenceRock.blockID) {
            return true;
        }
        Block block = Block.blocksList[l];
        if (block != null && block.blockMaterial.getIsOpaque() && block.renderAsNormalBlock()) {
            return block.blockMaterial != Material.pumpkin;
        }
        return false;
    }
}

