/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.other.EntityFallingSand;
import net.minecraft.src.game.level.World;

public class BlockFalling
extends Block {
    public static boolean fallInstantly = false;

    public BlockFalling(int id, int texture, Material material) {
        super(id, texture, material);
    }

    @Override
    public void onBlockAdded(World var1, int var2, int var3, int var4) {
        var1.scheduleBlockUpdate(var2, var3, var4, this.blockID, this.tickRate());
    }

    @Override
    public void onNeighborBlockChange(World var1, int var2, int var3, int var4, int var5) {
        var1.scheduleBlockUpdate(var2, var3, var4, this.blockID, this.tickRate());
    }

    @Override
    public void updateTick(World var1, int var2, int var3, int var4, Random var5) {
        this.tryToFall(var1, var2, var3, var4);
    }

    private void tryToFall(World world, int xCoord, int yCoord, int zCoord) {
        int metadata = world.getBlockMetadata(xCoord, yCoord, zCoord) & 7;
        if (BlockFalling.canFallBelow(world, xCoord, yCoord - 1, zCoord) && yCoord >= 0) {
            int chunkCheck = 32;
            if (!fallInstantly && world.checkChunksExist(xCoord - chunkCheck, yCoord - chunkCheck, zCoord - chunkCheck, xCoord + chunkCheck, yCoord + chunkCheck, zCoord + chunkCheck)) {
                EntityFallingSand fallingBlock = new EntityFallingSand(world, (float)xCoord + 0.5f, (float)yCoord + 0.5f, (float)zCoord + 0.5f, this.blockID, metadata);
                world.entityJoinedWorld(fallingBlock);
            } else {
                world.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
                while (BlockFalling.canFallBelow(world, xCoord, yCoord - 1, zCoord) && yCoord > 0) {
                    --yCoord;
                }
                if (yCoord > 0) {
                    world.setBlockWithNotify(xCoord, yCoord, zCoord, this.blockID);
                }
            }
        }
    }

    @Override
    public int tickRate() {
        return 3;
    }

    public static boolean canFallBelow(World var0, int var1, int var2, int var3) {
        int var4 = var0.getBlockId(var1, var2, var3);
        if (var4 == 0) {
            return true;
        }
        if (var4 == Block.fire.blockID) {
            return true;
        }
        if (var4 == Block.ashPile.blockID) {
            return true;
        }
        Material var5 = Block.blocksList[var4].blockMaterial;
        if (var5 == Material.water) {
            return true;
        }
        return var5 == Material.lava;
    }
}

