/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import net.minecraft.src.client.inventory.IInventory;
import net.minecraft.src.client.inventory.InventoryLargeChest;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockContainer;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.block.tileentity.TileEntityChest;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockChest
extends BlockContainer {
    private Random random = new Random();

    protected BlockChest(int var1) {
        super(var1, Material.wood);
        this.blockIndexInTexture = 26;
    }

    @Override
    public int getBlockTexture(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        Calendar calender = Calendar.getInstance();
        calender.setTime(new Date());
        this.blockIndexInTexture = calender.get(2) + 1 == 12 ? 219 : 26;
        int var6 = var1.getBlockId(var2, var3, var4 - 1);
        int var7 = var1.getBlockId(var2, var3, var4 + 1);
        int var8 = var1.getBlockId(var2 - 1, var3, var4);
        int var9 = var1.getBlockId(var2 + 1, var3, var4);
        if (var6 != this.blockID && var7 != this.blockID) {
            if (var8 != this.blockID && var9 != this.blockID) {
                if (var5 == 1 && calender.get(2) + 1 == 12) {
                    return this.blockIndexInTexture - 2;
                }
                if (var5 == 1) {
                    return this.blockIndexInTexture - 1;
                }
                if (var5 == 0) {
                    return this.blockIndexInTexture - 1;
                }
                int var14 = 3;
                if (Block.opaqueCubeLookup[var6] && !Block.opaqueCubeLookup[var7]) {
                    var14 = 3;
                }
                if (Block.opaqueCubeLookup[var7] && !Block.opaqueCubeLookup[var6]) {
                    var14 = 2;
                }
                if (Block.opaqueCubeLookup[var8] && !Block.opaqueCubeLookup[var9]) {
                    var14 = 5;
                }
                if (Block.opaqueCubeLookup[var9] && !Block.opaqueCubeLookup[var8]) {
                    var14 = 4;
                }
                return var5 == var14 ? this.blockIndexInTexture + 1 : this.blockIndexInTexture;
            }
            if (var5 != 4 && var5 != 5) {
                int var10 = 0;
                if (var8 == this.blockID) {
                    var10 = -1;
                }
                int var11 = var1.getBlockId(var8 == this.blockID ? var2 - 1 : var2 + 1, var3, var4 - 1);
                int var12 = var1.getBlockId(var8 == this.blockID ? var2 - 1 : var2 + 1, var3, var4 + 1);
                if (var5 == 3) {
                    var10 = -1 - var10;
                }
                int var13 = 3;
                if ((Block.opaqueCubeLookup[var6] || Block.opaqueCubeLookup[var11]) && !Block.opaqueCubeLookup[var7] && !Block.opaqueCubeLookup[var12]) {
                    var13 = 3;
                }
                if ((Block.opaqueCubeLookup[var7] || Block.opaqueCubeLookup[var12]) && !Block.opaqueCubeLookup[var6] && !Block.opaqueCubeLookup[var11]) {
                    var13 = 2;
                }
                if (var5 == 1 && calender.get(2) + 1 == 12) {
                    return this.blockIndexInTexture + 47 - var10;
                }
                if (var5 == 0 && calender.get(2) + 1 == 12) {
                    return this.blockIndexInTexture + 33;
                }
                if (var5 == 1) {
                    return this.blockIndexInTexture - 1;
                }
                if (var5 == 0) {
                    return this.blockIndexInTexture - 1;
                }
                return (var5 == var13 ? this.blockIndexInTexture + 16 : this.blockIndexInTexture + 32) + var10;
            }
            if (calender.get(2) + 1 == 12) {
                return this.blockIndexInTexture + 17;
            }
            return this.blockIndexInTexture;
        }
        if (var5 != 2 && var5 != 3) {
            int var10 = 0;
            if (var6 == this.blockID) {
                var10 = -1;
            }
            int var11 = var1.getBlockId(var2 - 1, var3, var6 == this.blockID ? var4 - 1 : var4 + 1);
            int var12 = var1.getBlockId(var2 + 1, var3, var6 == this.blockID ? var4 - 1 : var4 + 1);
            if (var5 == 4) {
                var10 = -1 - var10;
            }
            int var13 = 5;
            if ((Block.opaqueCubeLookup[var8] || Block.opaqueCubeLookup[var11]) && !Block.opaqueCubeLookup[var9] && !Block.opaqueCubeLookup[var12]) {
                var13 = 5;
            }
            if ((Block.opaqueCubeLookup[var9] || Block.opaqueCubeLookup[var12]) && !Block.opaqueCubeLookup[var8] && !Block.opaqueCubeLookup[var11]) {
                var13 = 4;
            }
            if (var5 == 1 && calender.get(2) + 1 == 12) {
                return this.blockIndexInTexture + 49 - var10;
            }
            if (var5 == 0 && calender.get(2) + 1 == 12) {
                return this.blockIndexInTexture + 33;
            }
            if (var5 == 1) {
                return this.blockIndexInTexture - 1;
            }
            if (var5 == 0) {
                return this.blockIndexInTexture - 1;
            }
            return (var5 == var13 ? this.blockIndexInTexture + 16 : this.blockIndexInTexture + 32) + var10;
        }
        if (calender.get(2) + 1 == 12) {
            return this.blockIndexInTexture + 17;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public int getBlockTextureFromSide(int var1) {
        Calendar calender = Calendar.getInstance();
        calender.setTime(new Date());
        if (var1 == 1 && calender.get(2) + 1 == 12) {
            return this.blockIndexInTexture - 2;
        }
        if (var1 == 0 && calender.get(2) + 1 == 12) {
            return this.blockIndexInTexture - 1;
        }
        if (var1 == 1) {
            return this.blockIndexInTexture - 1;
        }
        if (var1 == 0) {
            return this.blockIndexInTexture - 1;
        }
        return var1 == 3 ? this.blockIndexInTexture + 1 : this.blockIndexInTexture;
    }

    @Override
    public boolean canPlaceBlockAt(World var1, int var2, int var3, int var4) {
        int var5 = 0;
        if (var1.getBlockId(var2 - 1, var3, var4) == this.blockID) {
            ++var5;
        }
        if (var1.getBlockId(var2 + 1, var3, var4) == this.blockID) {
            ++var5;
        }
        if (var1.getBlockId(var2, var3, var4 - 1) == this.blockID) {
            ++var5;
        }
        if (var1.getBlockId(var2, var3, var4 + 1) == this.blockID) {
            ++var5;
        }
        if (var5 > 1) {
            return false;
        }
        if (this.isThereANeighborChest(var1, var2 - 1, var3, var4)) {
            return false;
        }
        if (this.isThereANeighborChest(var1, var2 + 1, var3, var4)) {
            return false;
        }
        if (this.isThereANeighborChest(var1, var2, var3, var4 - 1)) {
            return false;
        }
        return !this.isThereANeighborChest(var1, var2, var3, var4 + 1);
    }

    private boolean isThereANeighborChest(World var1, int var2, int var3, int var4) {
        if (var1.getBlockId(var2, var3, var4) != this.blockID) {
            return false;
        }
        if (var1.getBlockId(var2 - 1, var3, var4) == this.blockID) {
            return true;
        }
        if (var1.getBlockId(var2 + 1, var3, var4) == this.blockID) {
            return true;
        }
        if (var1.getBlockId(var2, var3, var4 - 1) == this.blockID) {
            return true;
        }
        return var1.getBlockId(var2, var3, var4 + 1) == this.blockID;
    }

    @Override
    public void onBlockRemoval(World var1, int var2, int var3, int var4) {
        TileEntityChest var5 = (TileEntityChest)var1.getBlockTileEntity(var2, var3, var4);
        int var6 = 0;
        while (var6 < var5.getSizeInventory()) {
            ItemStack var7 = var5.getStackInSlot(var6);
            if (var7 != null) {
                float var8 = this.random.nextFloat() * 0.8f + 0.1f;
                float var9 = this.random.nextFloat() * 0.8f + 0.1f;
                float var10 = this.random.nextFloat() * 0.8f + 0.1f;
                while (var7.stackSize > 0) {
                    int var11 = this.random.nextInt(21) + 10;
                    if (var11 > var7.stackSize) {
                        var11 = var7.stackSize;
                    }
                    var7.stackSize -= var11;
                    EntityItem var12 = new EntityItem(var1, (float)var2 + var8, (float)var3 + var9, (float)var4 + var10, new ItemStack(var7.itemID, var11, var7.getItemDamage()));
                    float var13 = 0.05f;
                    var12.motionX = (float)this.random.nextGaussian() * var13;
                    var12.motionY = (float)this.random.nextGaussian() * var13 + 0.2f;
                    var12.motionZ = (float)this.random.nextGaussian() * var13;
                    var1.entityJoinedWorld(var12);
                }
            }
            ++var6;
        }
        super.onBlockRemoval(var1, var2, var3, var4);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean blockActivated(World var1, int var2, int var3, int var4, EntityPlayer var5) {
        IInventory var6 = (TileEntityChest)var1.getBlockTileEntity(var2, var3, var4);
        if (var5.isSneaking()) {
            return false;
        }
        if (var1.isBlockNormalCube(var2, var3 + 1, var4)) {
            return true;
        }
        if (var1.getBlockId(var2 - 1, var3, var4) == this.blockID && var1.isBlockNormalCube(var2 - 1, var3 + 1, var4)) {
            return true;
        }
        if (var1.getBlockId(var2 + 1, var3, var4) == this.blockID && var1.isBlockNormalCube(var2 + 1, var3 + 1, var4)) {
            return true;
        }
        if (var1.getBlockId(var2, var3, var4 - 1) == this.blockID && var1.isBlockNormalCube(var2, var3 + 1, var4 - 1)) {
            return true;
        }
        if (var1.getBlockId(var2, var3, var4 + 1) == this.blockID && var1.isBlockNormalCube(var2, var3 + 1, var4 + 1)) {
            return true;
        }
        if (var1.getBlockId(var2 - 1, var3, var4) == this.blockID) {
            var6 = new InventoryLargeChest("Large chest", (TileEntityChest)var1.getBlockTileEntity(var2 - 1, var3, var4), var6);
        }
        if (var1.getBlockId(var2 + 1, var3, var4) == this.blockID) {
            var6 = new InventoryLargeChest("Large chest", var6, (TileEntityChest)var1.getBlockTileEntity(var2 + 1, var3, var4));
        }
        if (var1.getBlockId(var2, var3, var4 - 1) == this.blockID) {
            var6 = new InventoryLargeChest("Large chest", (TileEntityChest)var1.getBlockTileEntity(var2, var3, var4 - 1), var6);
        }
        if (var1.getBlockId(var2, var3, var4 + 1) == this.blockID) {
            var6 = new InventoryLargeChest("Large chest", var6, (TileEntityChest)var1.getBlockTileEntity(var2, var3, var4 + 1));
        }
        if (var1.multiplayerWorld) {
            return true;
        }
        var5.displayGUIChest(var6);
        return true;
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityChest();
    }
}

