/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockFlower;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.level.World;

public final class BlockCaveSpikeSoft
extends BlockFlower {
    protected BlockCaveSpikeSoft(int n, int n2) {
        super(n, n2);
        this.setBlockBounds(0.1f, 0.1f, 0.1f, 0.9f, 1.0f, 0.9f);
    }

    @Override
    protected final boolean canThisPlantGrowOnThisBlockID(int n) {
        return Block.opaqueCubeLookup[n];
    }

    @Override
    public final boolean canBlockStay(World world, int blockId, int n, int n2) {
        return this.canThisPlantGrowOnThisBlockID(world.getBlockId(blockId, n + 1, n2));
    }

    @Override
    public boolean canPlaceBlockAt(World var1, int var2, int var3, int var4) {
        return super.canPlaceBlockAt(var1, var2, var3, var4) && this.canThisPlantGrowOnThisBlockID(var1.getBlockId(var2, var3 + 1, var4));
    }

    @Override
    public boolean isCollidable() {
        return true;
    }

    @Override
    public final AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int n, int n2, int n3) {
        return null;
    }

    @Override
    public int idDropped(int var1, Random var2) {
        if (this.blockID == 126) {
            return Item.stick.itemID;
        }
        return this.blockID;
    }
}

