/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockContainer;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.block.tileentity.TileEntityBlastFurnace;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockBlastFurnace
extends BlockContainer {
    private Random furnaceRand = new Random();
    private final boolean isActive;
    private static boolean keepFurnaceInventory = false;

    protected BlockBlastFurnace(int id, boolean furnaceType) {
        super(id, Material.rock);
        this.isActive = furnaceType;
        this.blockIndexInTexture = 189;
    }

    @Override
    public int idDropped(int damageMetadata, Random rand) {
        return Block.forgeIdle.blockID;
    }

    @Override
    public int idPicked(World par1World, int par2, int par3, int par4) {
        return Block.forgeIdle.blockID;
    }

    @Override
    public void onBlockAdded(World world, int xCoord, int yCoord, int zCoord) {
        super.onBlockAdded(world, xCoord, yCoord, zCoord);
        this.setDefaultDirection(world, xCoord, yCoord, zCoord);
    }

    private void setDefaultDirection(World world, int xCoord, int yCoord, int zCoord) {
        if (!world.multiplayerWorld) {
            int var5 = world.getBlockId(xCoord, yCoord, zCoord - 1);
            int var6 = world.getBlockId(xCoord, yCoord, zCoord + 1);
            int var7 = world.getBlockId(xCoord - 1, yCoord, zCoord);
            int var8 = world.getBlockId(xCoord + 1, yCoord, zCoord);
            int metadata = 3;
            if (Block.opaqueCubeLookup[var5] && !Block.opaqueCubeLookup[var6]) {
                metadata = 3;
            }
            if (Block.opaqueCubeLookup[var6] && !Block.opaqueCubeLookup[var5]) {
                metadata = 2;
            }
            if (Block.opaqueCubeLookup[var7] && !Block.opaqueCubeLookup[var8]) {
                metadata = 5;
            }
            if (Block.opaqueCubeLookup[var8] && !Block.opaqueCubeLookup[var7]) {
                metadata = 4;
            }
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, metadata);
        }
    }

    @Override
    public int getBlockTexture(IBlockAccess blockAccess, int xCoord, int yCoord, int zCoord, int blockFace) {
        if (blockFace == 1) {
            return this.blockIndexInTexture + 15;
        }
        if (blockFace == 0) {
            return 203;
        }
        int metadata = blockAccess.getBlockMetadata(xCoord, yCoord, zCoord);
        if (blockFace != metadata) {
            return this.blockIndexInTexture;
        }
        return this.isActive ? this.blockIndexInTexture - 1 : this.blockIndexInTexture - 2;
    }

    @Override
    public void randomDisplayTick(World world, int xCoord, int yCoord, int zCoord, Random rand) {
        if (this.isActive) {
            if (this.furnaceRand.nextInt(3) == 0) {
                world.playSoundEffect((float)xCoord + 0.5f, (float)yCoord + 0.5f, (float)zCoord + 0.5f, "step.furnace.fire_crackle", 1.0f, 1.0f);
            }
            int metadata = world.getBlockMetadata(xCoord, yCoord, zCoord);
            float xParticlePos = (float)xCoord + 0.5f;
            float yParticlePos = (float)yCoord + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
            float zParticlePos = (float)zCoord + 0.5f;
            float xExtraMinimumPositioning = 0.52f;
            float xExtramMaximumPositioning = rand.nextFloat() * 0.6f - 0.3f;
            if (metadata == 4) {
                world.spawnParticle("smoke", xParticlePos - xExtraMinimumPositioning, yParticlePos, zParticlePos + xExtramMaximumPositioning, 0.0, 0.0, 0.0);
                world.spawnParticle("smoke", xParticlePos - xExtraMinimumPositioning, yParticlePos, zParticlePos + xExtramMaximumPositioning, 0.0, 0.0, 0.0);
            } else if (metadata == 5) {
                world.spawnParticle("smoke", xParticlePos + xExtraMinimumPositioning, yParticlePos, zParticlePos + xExtramMaximumPositioning, 0.0, 0.0, 0.0);
                world.spawnParticle("smoke", xParticlePos + xExtraMinimumPositioning, yParticlePos, zParticlePos + xExtramMaximumPositioning, 0.0, 0.0, 0.0);
            } else if (metadata == 2) {
                world.spawnParticle("smoke", xParticlePos + xExtramMaximumPositioning, yParticlePos, zParticlePos - xExtraMinimumPositioning, 0.0, 0.0, 0.0);
                world.spawnParticle("smoke", xParticlePos + xExtramMaximumPositioning, yParticlePos, zParticlePos - xExtraMinimumPositioning, 0.0, 0.0, 0.0);
            } else if (metadata == 3) {
                world.spawnParticle("smoke", xParticlePos + xExtramMaximumPositioning, yParticlePos, zParticlePos + xExtraMinimumPositioning, 0.0, 0.0, 0.0);
                world.spawnParticle("smoke", xParticlePos + xExtramMaximumPositioning, yParticlePos, zParticlePos + xExtraMinimumPositioning, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public int getBlockTextureFromSide(int blockFace) {
        if (blockFace == 1) {
            return this.blockIndexInTexture + 15;
        }
        if (blockFace == 0) {
            return this.blockIndexInTexture + 15;
        }
        return blockFace == 3 ? this.blockIndexInTexture - 2 : this.blockIndexInTexture;
    }

    @Override
    public boolean blockActivated(World world, int xCoord, int yCoord, int zCoord, EntityPlayer player) {
        if (world.multiplayerWorld) {
            return true;
        }
        if (player.isSneaking()) {
            return false;
        }
        TileEntityBlastFurnace blockEntity = (TileEntityBlastFurnace)world.getBlockTileEntity(xCoord, yCoord, zCoord);
        player.displayGUIBlastFurnace(blockEntity);
        return true;
    }

    public static void updateFurnaceBlockState(boolean litFurnace, World world, int xCoord, int yCoord, int zCoord) {
        int metadata = world.getBlockMetadata(xCoord, yCoord, zCoord);
        TileEntity blockEntity = world.getBlockTileEntity(xCoord, yCoord, zCoord);
        keepFurnaceInventory = true;
        if (litFurnace) {
            world.setBlockWithNotify(xCoord, yCoord, zCoord, Block.forgeActive.blockID);
        } else {
            world.setBlockWithNotify(xCoord, yCoord, zCoord, Block.forgeIdle.blockID);
        }
        keepFurnaceInventory = false;
        world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, metadata);
        blockEntity.func_31004_j();
        world.setBlockTileEntity(xCoord, yCoord, zCoord, blockEntity);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityBlastFurnace();
    }

    @Override
    public void onBlockPlacedBy(World world, int xCoord, int yCoord, int zCoord, EntityLiving entity) {
        int blockRotationPlacement = MathHelper.floor_double((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (blockRotationPlacement == 0) {
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 2);
        }
        if (blockRotationPlacement == 1) {
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 5);
        }
        if (blockRotationPlacement == 2) {
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 3);
        }
        if (blockRotationPlacement == 3) {
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 4);
        }
    }

    @Override
    public void onBlockRemoval(World world, int xCoord, int yCoord, int zCoord) {
        if (!keepFurnaceInventory) {
            TileEntityBlastFurnace blockEntity = (TileEntityBlastFurnace)world.getBlockTileEntity(xCoord, yCoord, zCoord);
            int furnaceSlot = 0;
            while (furnaceSlot < blockEntity.getSizeInventory()) {
                ItemStack item = blockEntity.getStackInSlot(furnaceSlot);
                if (item != null) {
                    float xRandomMotion = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                    float yRandomMotion = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                    float zRandomMotion = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                    while (item.stackSize > 0) {
                        int itemAmount = this.furnaceRand.nextInt(21) + 10;
                        if (itemAmount > item.stackSize) {
                            itemAmount = item.stackSize;
                        }
                        item.stackSize -= itemAmount;
                        EntityItem itemDropped = new EntityItem(world, (float)xCoord + xRandomMotion, (float)yCoord + yRandomMotion, (float)zCoord + zRandomMotion, new ItemStack(item.itemID, itemAmount, item.getItemDamage()));
                        float extraMotion = 0.05f;
                        itemDropped.motionX = (float)this.furnaceRand.nextGaussian() * extraMotion;
                        itemDropped.motionY = (float)this.furnaceRand.nextGaussian() * extraMotion + 0.2f;
                        itemDropped.motionZ = (float)this.furnaceRand.nextGaussian() * extraMotion;
                        world.entityJoinedWorld(itemDropped);
                    }
                }
                ++furnaceSlot;
            }
        }
        super.onBlockRemoval(world, xCoord, yCoord, zCoord);
    }
}

