/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.player;

import net.minecraft.client.Minecraft;
import net.minecraft.src.client.player.PlayerController;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;

public class PlayerControllerSP
extends PlayerController {
    private int field_1074_c = -1;
    private int field_1073_d = -1;
    private int field_1072_e = -1;
    private float curBlockDamage = 0.0f;
    private float prevBlockDamage = 0.0f;
    private float field_1069_h = 0.0f;
    private int blockHitWait = 0;

    public PlayerControllerSP(Minecraft var1) {
        super(var1);
    }

    @Override
    public void flipPlayer(EntityPlayer var1) {
        var1.rotationYaw = -180.0f;
    }

    @Override
    public boolean sendBlockRemoved(int var1, int var2, int var3, int var4) {
        int var5 = this.mc.theWorld.getBlockId(var1, var2, var3);
        int var6 = this.mc.theWorld.getBlockMetadata(var1, var2, var3);
        boolean var7 = super.sendBlockRemoved(var1, var2, var3, var4);
        ItemStack var8 = this.mc.thePlayer.getCurrentEquippedItem();
        boolean var9 = this.mc.thePlayer.canHarvestBlock(Block.blocksList[var5]);
        if (var7 && var9) {
            Block.blocksList[var5].harvestBlock(this.mc.theWorld, this.mc.thePlayer, var1, var2, var3, var6);
        }
        if (var8 != null) {
            var8.onDestroyBlock(var5, var1, var2, var3, this.mc.thePlayer);
            if (var8.stackSize == 0) {
                var8.func_1097_a(this.mc.thePlayer);
                this.mc.thePlayer.destroyCurrentEquippedItem();
            }
        }
        return var7;
    }

    @Override
    public void clickBlock(int var1, int var2, int var3, int var4) {
        this.mc.theWorld.onBlockHit(this.mc.thePlayer, var1, var2, var3, var4);
        int var5 = this.mc.theWorld.getBlockId(var1, var2, var3);
        if (var5 > 0 && this.curBlockDamage == 0.0f) {
            Block.blocksList[var5].onBlockClicked(this.mc.theWorld, var1, var2, var3, this.mc.thePlayer);
        }
        if (var5 > 0 && Block.blocksList[var5].blockStrength(this.mc.thePlayer) >= 1.0f) {
            this.sendBlockRemoved(var1, var2, var3, var4);
        }
    }

    @Override
    public void resetBlockRemoving() {
        this.curBlockDamage = 0.0f;
        this.blockHitWait = 0;
    }

    @Override
    public void sendBlockRemoving(int var1, int var2, int var3, int var4) {
        if (this.blockHitWait > 0) {
            --this.blockHitWait;
        } else if (var1 == this.field_1074_c && var2 == this.field_1073_d && var3 == this.field_1072_e) {
            int var5 = this.mc.theWorld.getBlockId(var1, var2, var3);
            if (var5 == 0) {
                return;
            }
            Block var6 = Block.blocksList[var5];
            this.curBlockDamage += var6.blockStrength(this.mc.thePlayer);
            if (this.field_1069_h % 4.0f == 0.0f && var6 != null) {
                this.mc.sndManager.playSound(var6.stepSound.func_1145_d(), (float)var1 + 0.5f, (float)var2 + 0.5f, (float)var3 + 0.5f, (var6.stepSound.getVolume() + 1.0f) / 8.0f, var6.stepSound.getPitch() * 0.5f);
            }
            this.field_1069_h += 1.0f;
            if (this.curBlockDamage >= 1.0f) {
                this.sendBlockRemoved(var1, var2, var3, var4);
                this.curBlockDamage = 0.0f;
                this.prevBlockDamage = 0.0f;
                this.field_1069_h = 0.0f;
                this.blockHitWait = 5;
            }
        } else {
            this.curBlockDamage = 0.0f;
            this.prevBlockDamage = 0.0f;
            this.field_1069_h = 0.0f;
            this.field_1074_c = var1;
            this.field_1073_d = var2;
            this.field_1072_e = var3;
        }
    }

    @Override
    public void setPartialTime(float var1) {
        if (this.curBlockDamage <= 0.0f) {
            this.mc.ingameGUI.damageGuiPartialTime = 0.0f;
            this.mc.renderGlobal.damagePartialTime = 0.0f;
        } else {
            float var2;
            this.mc.ingameGUI.damageGuiPartialTime = var2 = this.prevBlockDamage + (this.curBlockDamage - this.prevBlockDamage) * var1;
            this.mc.renderGlobal.damagePartialTime = var2;
        }
    }

    @Override
    public float getBlockReachDistance() {
        return 4.0f;
    }

    @Override
    public void func_717_a(World var1) {
        super.func_717_a(var1);
    }

    @Override
    public void updateController() {
        this.prevBlockDamage = this.curBlockDamage;
        this.mc.sndManager.playRandomMusicIfReady();
    }
}

