/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.client.packets.NetHandler;
import net.minecraft.src.client.packets.Packet;
import net.minecraft.src.game.item.ItemStack;

public class Packet15Place
extends Packet {
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public int direction;
    public ItemStack itemStack;

    public Packet15Place() {
    }

    public Packet15Place(int var1, int var2, int var3, int var4, ItemStack var5) {
        this.xPosition = var1;
        this.yPosition = var2;
        this.zPosition = var3;
        this.direction = var4;
        this.itemStack = var5;
    }

    @Override
    public void readPacketData(DataInputStream var1) throws IOException {
        this.xPosition = var1.readInt();
        this.yPosition = var1.read();
        this.zPosition = var1.readInt();
        this.direction = var1.read();
        short var2 = var1.readShort();
        if (var2 >= 0) {
            byte var3 = var1.readByte();
            short var4 = var1.readShort();
            this.itemStack = new ItemStack(var2, (int)var3, (int)var4);
        } else {
            this.itemStack = null;
        }
    }

    @Override
    public void writePacketData(DataOutputStream var1) throws IOException {
        var1.writeInt(this.xPosition);
        var1.write(this.yPosition);
        var1.writeInt(this.zPosition);
        var1.write(this.direction);
        if (this.itemStack == null) {
            var1.writeShort(-1);
        } else {
            var1.writeShort(this.itemStack.itemID);
            var1.writeByte(this.itemStack.stackSize);
            var1.writeShort(this.itemStack.getItemDamage());
        }
    }

    @Override
    public void processPacket(NetHandler var1) {
        var1.handlePlace(this);
    }

    @Override
    public int getPacketSize() {
        return 15;
    }
}

