/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.client.model.ModelBase2;
import net.minecraft.src.client.model.ModelBox;
import net.minecraft.src.client.model.TextureOffset;
import net.minecraft.src.client.renderer.GLAllocation;
import net.minecraft.src.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class ModelRenderer2 {
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    private int textureOffsetX;
    private int textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    private boolean compiled = false;
    private int displayList = 0;
    public boolean mirror = false;
    public boolean showModel = true;
    public boolean isHidden = false;
    public List<ModelBox> cubeList = new ArrayList<ModelBox>();
    public List<ModelRenderer2> childModels;
    public final String boxName;
    private ModelBase2 baseModel;

    public ModelRenderer2(ModelBase2 modelbase, String s) {
        this.baseModel = modelbase;
        modelbase.boxList.add(this);
        this.boxName = s;
        this.setTextureSize(modelbase.textureWidth, modelbase.textureHeight);
    }

    public ModelRenderer2(ModelBase2 modelbase) {
        this(modelbase, null);
    }

    public ModelRenderer2(ModelBase2 modelbase, int i, int j) {
        this(modelbase);
        this.setTextureOffset(i, j);
    }

    public void addChild(ModelRenderer2 modelrenderer) {
        if (this.childModels == null) {
            this.childModels = new ArrayList<ModelRenderer2>();
        }
        this.childModels.add(modelrenderer);
    }

    public ModelRenderer2 setTextureOffset(int i, int j) {
        this.textureOffsetX = i;
        this.textureOffsetY = j;
        return this;
    }

    public ModelRenderer2 addBox(String s, float f, float f1, float f2, int i, int j, int k) {
        s = this.boxName + "." + s;
        TextureOffset textureoffset = this.baseModel.func_40297_a(s);
        this.setTextureOffset(textureoffset.field_40734_a, textureoffset.field_40733_b);
        this.cubeList.add(new ModelBox(this, this.textureOffsetX, this.textureOffsetY, f, f1, f2, i, j, k, 0.0f).func_40671_a(s));
        return this;
    }

    public ModelRenderer2 addBox(float f, float f1, float f2, int i, int j, int k) {
        this.cubeList.add(new ModelBox(this, this.textureOffsetX, this.textureOffsetY, f, f1, f2, i, j, k, 0.0f));
        return this;
    }

    public void addBox(float f, float f1, float f2, int i, int j, int k, float f3) {
        this.cubeList.add(new ModelBox(this, this.textureOffsetX, this.textureOffsetY, f, f1, f2, i, j, k, f3));
    }

    public void setRotationPoint(float f, float f1, float f2) {
        this.rotationPointX = f;
        this.rotationPointY = f1;
        this.rotationPointZ = f2;
    }

    public void render(float f) {
        if (this.isHidden) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glCallList((int)this.displayList);
            if (this.childModels != null) {
                int i = 0;
                while (i < this.childModels.size()) {
                    this.childModels.get(i).render(f);
                    ++i;
                }
            }
            GL11.glPopMatrix();
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            GL11.glCallList((int)this.displayList);
            if (this.childModels != null) {
                int j = 0;
                while (j < this.childModels.size()) {
                    this.childModels.get(j).render(f);
                    ++j;
                }
            }
            GL11.glTranslatef((float)(-this.rotationPointX * f), (float)(-this.rotationPointY * f), (float)(-this.rotationPointZ * f));
        } else {
            GL11.glCallList((int)this.displayList);
            if (this.childModels != null) {
                int k = 0;
                while (k < this.childModels.size()) {
                    this.childModels.get(k).render(f);
                    ++k;
                }
            }
        }
    }

    public void renderWithRotation(float f) {
        if (this.isHidden) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
        if (this.rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glCallList((int)this.displayList);
        GL11.glPopMatrix();
    }

    public void postRender(float f) {
        if (this.isHidden) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
        }
    }

    private void compileDisplayList(float f) {
        this.displayList = GLAllocation.generateDisplayLists(1);
        GL11.glNewList((int)this.displayList, (int)4864);
        Tessellator tessellator = Tessellator.instance;
        int i = 0;
        while (i < this.cubeList.size()) {
            this.cubeList.get(i).func_40670_a(tessellator, f);
            ++i;
        }
        GL11.glEndList();
        this.compiled = true;
    }

    public ModelRenderer2 setTextureSize(int i, int j) {
        this.textureWidth = i;
        this.textureHeight = j;
        return this;
    }
}

