/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.model;

import net.minecraft.src.client.model.ModelBase;
import net.minecraft.src.client.model.ModelRenderer;
import net.minecraft.src.game.MathHelper;

public class ModelBiped
extends ModelBase {
    public ModelRenderer bipedHead;
    public ModelRenderer bipedHeadwear;
    public ModelRenderer bipedBody;
    public ModelRenderer bipedRightArm;
    public ModelRenderer bipedLeftArm;
    public ModelRenderer bipedRightLeg;
    public ModelRenderer bipedLeftLeg;
    public ModelRenderer bipedEars;
    public ModelRenderer bipedCloak;
    public boolean field_1279_h;
    public boolean field_1278_i;
    public boolean isSneak;
    public boolean aimedBow;
    public int heldItemLeft;
    public int heldItemRight;
    public int _field_1279_h;
    public int isBlocking;
    public boolean _field_40333_u;
    public ModelRenderer bipedHeadEars = new ModelRenderer(0, 0);
    public ModelRenderer bipedHeadEarsOverlay;

    public ModelBiped() {
        this(0.0f);
    }

    public ModelBiped(float var1) {
        this(var1, 0.0f);
    }

    public ModelBiped(float var1, float var2) {
        this.bipedHeadEars.addBox(-4.0f, -16.0f, -1.0f, 8, 8, 1, var1);
        this.bipedHeadEars.setRotationPoint(0.0f, 0.0f + var2, 0.0f);
        this.bipedHeadEarsOverlay = new ModelRenderer(32, 0);
        this.bipedHeadEarsOverlay.addBox(-4.0f, -16.0f, -1.0f, 8, 8, 1, var1 + 0.5f);
        this.bipedHeadEarsOverlay.setRotationPoint(0.0f, 0.0f + var2, 0.0f);
        this.field_1279_h = false;
        this.field_1278_i = false;
        this.isSneak = false;
        this.aimedBow = false;
        this.heldItemLeft = 0;
        this.heldItemRight = 0;
        this.bipedCloak = new ModelRenderer(0, 0);
        this.bipedCloak.addBox(-5.0f, 0.0f, -1.0f, 10, 16, 1, var1);
        this.bipedEars = new ModelRenderer(24, 0);
        this.bipedEars.addBox(-4.0f, -7.0f, -1.0f, 7, 7, 1, var1);
        this.bipedHead = new ModelRenderer(0, 0);
        this.bipedHead.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, var1);
        this.bipedHead.setRotationPoint(0.0f, 0.0f + var2, 0.0f);
        this.bipedHeadwear = new ModelRenderer(32, 0);
        this.bipedHeadwear.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, var1 + 0.5f);
        this.bipedHeadwear.setRotationPoint(0.0f, 0.0f + var2, 0.0f);
        this.bipedBody = new ModelRenderer(16, 16);
        this.bipedBody.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4, var1);
        this.bipedBody.setRotationPoint(0.0f, 0.0f + var2, 0.0f);
        this.bipedRightArm = new ModelRenderer(40, 16);
        this.bipedRightArm.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, var1);
        this.bipedRightArm.setRotationPoint(-5.0f, 2.0f + var2, 0.0f);
        this.bipedLeftArm = new ModelRenderer(40, 16);
        this.bipedLeftArm.mirror = true;
        this.bipedLeftArm.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, var1);
        this.bipedLeftArm.setRotationPoint(5.0f, 2.0f + var2, 0.0f);
        this.bipedRightLeg = new ModelRenderer(0, 16);
        this.bipedRightLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, var1);
        this.bipedRightLeg.setRotationPoint(-2.0f, 12.0f + var2, 0.0f);
        this.bipedLeftLeg = new ModelRenderer(0, 16);
        this.bipedLeftLeg.mirror = true;
        this.bipedLeftLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, var1);
        this.bipedLeftLeg.setRotationPoint(2.0f, 12.0f + var2, 0.0f);
    }

    @Override
    public void render(float var1, float var2, float var3, float var4, float var5, float var6) {
        this.setRotationAngles(var1, var2, var3, var4, var5, var6);
        this.bipedHead.render(var6);
        this.bipedBody.render(var6);
        this.bipedRightArm.render(var6);
        this.bipedLeftArm.render(var6);
        this.bipedRightLeg.render(var6);
        this.bipedLeftLeg.render(var6);
        this.bipedHeadwear.render(var6);
    }

    public void armMoves(ModelRenderer var10000, float var3) {
        var10000 = this.bipedRightArm;
        var10000.rotateAngleZ += MathHelper.cos(var3 * 0.09f) * 0.05f + 0.05f;
        var10000 = this.bipedLeftArm;
        var10000.rotateAngleZ -= MathHelper.cos(var3 * 0.09f) * 0.05f + 0.05f;
        var10000 = this.bipedRightArm;
        var10000.rotateAngleX += MathHelper.sin(var3 * 0.067f) * 0.05f;
        var10000 = this.bipedLeftArm;
        var10000.rotateAngleX -= MathHelper.sin(var3 * 0.067f) * 0.05f;
    }

    @Override
    public void setRotationAngles(float var1, float var2, float var3, float var4, float var5, float var6) {
        float var8;
        float var7;
        ModelRenderer var10000;
        this.bipedHead.rotateAngleY = var4 / 57.295776f;
        this.bipedHead.rotateAngleX = var5 / 57.295776f;
        this.bipedHeadwear.rotateAngleY = this.bipedHead.rotateAngleY;
        this.bipedHeadwear.rotateAngleX = this.bipedHead.rotateAngleX;
        this.bipedRightArm.rotateAngleX = MathHelper.cos(var1 * 0.6662f + (float)Math.PI) * 2.0f * var2;
        this.bipedLeftArm.rotateAngleX = MathHelper.cos(var1 * 0.6662f) * 2.0f * var2;
        this.bipedRightArm.rotateAngleZ = 0.0f;
        this.bipedLeftArm.rotateAngleZ = 0.0f;
        this.bipedRightLeg.rotateAngleX = MathHelper.cos(var1 * 0.6662f) * 1.4f * var2;
        this.bipedLeftLeg.rotateAngleX = MathHelper.cos(var1 * 0.6662f + (float)Math.PI) * 1.4f * var2;
        this.bipedRightLeg.rotateAngleY = 0.0f;
        this.bipedLeftLeg.rotateAngleY = 0.0f;
        if (this.isRiding) {
            var10000 = this.bipedRightArm;
            var10000.rotateAngleX += -0.62831855f;
            var10000 = this.bipedLeftArm;
            var10000.rotateAngleX += -0.62831855f;
            this.bipedRightLeg.rotateAngleX = -1.2566371f;
            this.bipedLeftLeg.rotateAngleX = -1.2566371f;
            this.bipedRightLeg.rotateAngleY = 0.31415927f;
            this.bipedLeftLeg.rotateAngleY = -0.31415927f;
        }
        if (this.field_1279_h) {
            this.bipedLeftArm.rotateAngleX = this.bipedLeftArm.rotateAngleX * 0.5f - 0.31415927f;
        }
        if (this.field_1278_i) {
            this.bipedRightArm.rotateAngleX = this.bipedRightArm.rotateAngleX * 0.5f - 0.31415927f;
        }
        if (this.heldItemLeft != 0) {
            this.bipedLeftArm.rotateAngleX = this.bipedLeftArm.rotateAngleX * 0.5f - 0.31415927f * (float)this.heldItemLeft;
        }
        if (this.heldItemRight != 0) {
            this.bipedRightArm.rotateAngleX = this.bipedRightArm.rotateAngleX * 0.5f - 0.31415927f * (float)this.heldItemRight;
        }
        this.bipedRightArm.rotateAngleY = 0.0f;
        this.bipedLeftArm.rotateAngleY = 0.0f;
        if (this.onGround > -9990.0f) {
            var7 = this.onGround;
            this.bipedBody.rotateAngleY = MathHelper.sin(MathHelper.sqrt_float(var7) * (float)Math.PI * 2.0f) * 0.2f;
            this.bipedRightArm.rotationPointZ = MathHelper.sin(this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedRightArm.rotationPointX = -MathHelper.cos(this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedLeftArm.rotationPointZ = -MathHelper.sin(this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedLeftArm.rotationPointX = MathHelper.cos(this.bipedBody.rotateAngleY) * 5.0f;
            var10000 = this.bipedRightArm;
            var10000.rotateAngleY += this.bipedBody.rotateAngleY;
            var10000 = this.bipedLeftArm;
            var10000.rotateAngleY += this.bipedBody.rotateAngleY;
            var10000 = this.bipedLeftArm;
            var10000.rotateAngleX += this.bipedBody.rotateAngleY;
            var7 = 1.0f - this.onGround;
            var7 *= var7;
            var7 *= var7;
            var7 = 1.0f - var7;
            var8 = MathHelper.sin(var7 * (float)Math.PI);
            float var9 = MathHelper.sin(this.onGround * (float)Math.PI) * -(this.bipedHead.rotateAngleX - 0.7f) * 0.75f;
            var10000 = this.bipedRightArm;
            var10000.rotateAngleX = (float)((double)var10000.rotateAngleX - ((double)var8 * 1.2 + (double)var9));
            var10000 = this.bipedRightArm;
            var10000.rotateAngleY += this.bipedBody.rotateAngleY * 2.0f;
            this.bipedRightArm.rotateAngleZ = MathHelper.sin(this.onGround * (float)Math.PI) * -0.4f;
        }
        if (this.isSneak) {
            this.bipedBody.rotateAngleX = 0.5f;
            var10000 = this.bipedRightLeg;
            var10000.rotateAngleX -= 0.0f;
            var10000 = this.bipedLeftLeg;
            var10000.rotateAngleX -= 0.0f;
            var10000 = this.bipedRightArm;
            var10000.rotateAngleX += 0.4f;
            var10000 = this.bipedLeftArm;
            var10000.rotateAngleX += 0.4f;
            this.bipedRightLeg.rotationPointZ = 4.0f;
            this.bipedLeftLeg.rotationPointZ = 4.0f;
            this.bipedRightLeg.rotationPointY = 9.0f;
            this.bipedLeftLeg.rotationPointY = 9.0f;
            this.bipedHead.rotationPointY = 1.0f;
            this.bipedHeadwear.rotationPointY = 1.0f;
        } else {
            this.bipedBody.rotateAngleX = 0.0f;
            this.bipedRightLeg.rotationPointZ = 0.0f;
            this.bipedLeftLeg.rotationPointZ = 0.0f;
            this.bipedRightLeg.rotationPointY = 12.0f;
            this.bipedLeftLeg.rotationPointY = 12.0f;
            this.bipedHead.rotationPointY = 0.0f;
            this.bipedHeadwear.rotationPointY = 0.0f;
        }
        var10000 = this.bipedRightArm;
        var10000.rotateAngleZ += MathHelper.cos(var3 * 0.09f) * 0.05f + 0.05f;
        var10000 = this.bipedLeftArm;
        var10000.rotateAngleZ -= MathHelper.cos(var3 * 0.09f) * 0.05f + 0.05f;
        var10000 = this.bipedRightArm;
        var10000.rotateAngleX += MathHelper.sin(var3 * 0.067f) * 0.05f;
        var10000 = this.bipedLeftArm;
        var10000.rotateAngleX -= MathHelper.sin(var3 * 0.067f) * 0.05f;
        if (this.aimedBow) {
            var7 = 0.0f;
            var8 = 0.0f;
            this.bipedRightArm.rotateAngleZ = 0.0f;
            this.bipedLeftArm.rotateAngleZ = 0.0f;
            this.bipedRightArm.rotateAngleY = -(0.1f - var7 * 0.6f) + this.bipedHead.rotateAngleY;
            this.bipedLeftArm.rotateAngleY = 0.1f - var7 * 0.6f + this.bipedHead.rotateAngleY + 0.4f;
            this.bipedRightArm.rotateAngleX = -1.5707964f + this.bipedHead.rotateAngleX;
            this.bipedLeftArm.rotateAngleX = -1.5707964f + this.bipedHead.rotateAngleX;
            this.bipedRightArm.rotateAngleX -= var7 * 1.2f - var8 * 0.4f;
            this.bipedLeftArm.rotateAngleX -= var7 * 1.2f - var8 * 0.4f;
            this.bipedRightArm.rotateAngleZ += MathHelper.cos(var3 * 0.09f) * 0.05f + 0.05f;
            this.bipedLeftArm.rotateAngleZ -= MathHelper.cos(var3 * 0.09f) * 0.05f + 0.05f;
            this.bipedRightArm.rotateAngleX += MathHelper.sin(var3 * 0.067f) * 0.05f;
            this.bipedLeftArm.rotateAngleX -= MathHelper.sin(var3 * 0.067f) * 0.05f;
        }
    }

    public void renderEars(float var1) {
        this.bipedEars.rotateAngleY = this.bipedHead.rotateAngleY;
        this.bipedEars.rotateAngleX = this.bipedHead.rotateAngleX;
        this.bipedEars.rotationPointX = 0.0f;
        this.bipedEars.rotationPointY = 0.0f;
        this.bipedEars.render(var1);
    }

    public void renderCloak(float var1) {
        this.bipedCloak.render(var1);
    }
}

