/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.client.GameSettings;
import net.minecraft.src.client.gui.FontRenderer;
import net.minecraft.src.client.gui.Gui;
import net.minecraft.src.client.gui.GuiButton;
import net.minecraft.src.client.gui.GuiParticle;
import net.minecraft.src.client.renderer.Tessellator;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreen
extends Gui {
    protected Minecraft mc;
    public int width;
    public int height;
    protected List controlList = new ArrayList();
    public boolean field_948_f = false;
    protected FontRenderer fontRenderer;
    public GuiParticle field_25091_h;
    private GuiButton selectedButton = null;
    static Random random = new Random();
    static String[] menuBlocks = new String[]{"/gui/menu/built/blockcoal.png", "/gui/menu/built/blockdiamondbottom.png", "/gui/menu/built/blockdiamondside.png", "/gui/menu/built/blockdiamondtop.png", "/gui/menu/built/blockgoldbottom.png", "/gui/menu/built/blockgoldside.png", "/gui/menu/built/blockgoldtop.png", "/gui/menu/built/blockironbottom.png", "/gui/menu/built/blockironside.png", "/gui/menu/built/blockirontop.png", "/gui/menu/built/bookshelf.png", "/gui/menu/built/bookshelfbrick.png", "/gui/menu/built/bookshelfcrimson.png", "/gui/menu/built/bookshelffir.png", "/gui/menu/built/brick.png", "/gui/menu/built/brickfired.png", "/gui/menu/built/brickfiredmossy.png", "/gui/menu/built/brickfiredpyramidion.png", "/gui/menu/built/brickmossy.png", "/gui/menu/built/brickpyramidion.png", "/gui/menu/built/music.png", "/gui/menu/built/netherbrick.png", "/gui/menu/built/piston.png", "/gui/menu/built/planks.png", "/gui/menu/built/plankscrimson.png", "/gui/menu/built/planksfir.png", "/gui/menu/built/reactoractive.png", "/gui/menu/built/reactordead.png", "/gui/menu/built/reactorready.png", "/gui/menu/built/slabbottom.png", "/gui/menu/built/slabside.png", "/gui/menu/built/stonebrick.png", "/gui/menu/built/tntbottom.png", "/gui/menu/built/tntside.png", "/gui/menu/built/trapdoorfir.png", "/gui/menu/built/utilitybenchbottom.png", "/gui/menu/built/utilitybenchtop.png", "/gui/menu/built/utilityforgebottom.png", "/gui/menu/built/utilityforgetop.png", "/gui/menu/built/utilityovenbottom.png", "/gui/menu/built/utilityoventop.png", "/gui/menu/built/utilitystoragebottom.png", "/gui/menu/cloth/black.png", "/gui/menu/cloth/blue.png", "/gui/menu/cloth/brown.png", "/gui/menu/cloth/cyan.png", "/gui/menu/cloth/gray.png", "/gui/menu/cloth/green.png", "/gui/menu/cloth/indigo.png", "/gui/menu/cloth/lightblue.png", "/gui/menu/cloth/lime.png", "/gui/menu/cloth/orange.png", "/gui/menu/cloth/pink.png", "/gui/menu/cloth/purple.png", "/gui/menu/cloth/red.png", "/gui/menu/cloth/silver.png", "/gui/menu/cloth/white.png", "/gui/menu/cloth/yellow.png", "/gui/menu/ground/clay.png", "/gui/menu/ground/dirt.png", "/gui/menu/ground/grass.png", "/gui/menu/ground/grassautumn.png", "/gui/menu/ground/grasspath.png", "/gui/menu/ground/grassspring.png", "/gui/menu/ground/gravel.png", "/gui/menu/ground/ice.png", "/gui/menu/ground/mycel.png", "/gui/menu/ground/sand.png", "/gui/menu/ground/slowsand.png", "/gui/menu/ground/snow.png", "/gui/menu/ground/soildry.png", "/gui/menu/ground/soilwet.png", "/gui/menu/nature/cactibottom.png", "/gui/menu/nature/cactiside.png", "/gui/menu/nature/cactitop.png", "/gui/menu/nature/coralblue.png", "/gui/menu/nature/coralred.png", "/gui/menu/nature/coralwhite.png", "/gui/menu/nature/coralyellow.png", "/gui/menu/nature/leaves.png", "/gui/menu/nature/leavesautumn.png", "/gui/menu/nature/leavesblossom.png", "/gui/menu/nature/leavesfir.png", "/gui/menu/nature/leavesspring.png", "/gui/menu/nature/leaveswinter.png", "/gui/menu/nature/logbottom.png", "/gui/menu/nature/logcrimsonbottom.png", "/gui/menu/nature/logcrimsonside.png", "/gui/menu/nature/logfirbottom.png", "/gui/menu/nature/logfirside.png", "/gui/menu/nature/logside.png", "/gui/menu/nature/mushroombottom.png", "/gui/menu/nature/mushroombrown.png", "/gui/menu/nature/mushroomgreen.png", "/gui/menu/nature/mushroomred.png", "/gui/menu/nature/mushroomstem.png", "/gui/menu/nature/pumpkinside.png", "/gui/menu/nature/sponge.png", "/gui/menu/nature/wart.png", "/gui/menu/rock/basaltbottom.png", "/gui/menu/rock/basaltside.png", "/gui/menu/rock/bedrock.png", "/gui/menu/rock/blackstonebottom.png", "/gui/menu/rock/blackstoneside.png", "/gui/menu/rock/bloodstone.png", "/gui/menu/rock/cobble.png", "/gui/menu/rock/cobblemossy.png", "/gui/menu/rock/lightstone.png", "/gui/menu/rock/magma.png", "/gui/menu/rock/obsidian.png", "/gui/menu/rock/obsidiancatalyst.png", "/gui/menu/rock/obsidiancrying.png", "/gui/menu/rock/obsidianred.png", "/gui/menu/rock/orecoal.png", "/gui/menu/rock/orecoalnether.png", "/gui/menu/rock/orediamond.png", "/gui/menu/rock/orediamondnether.png", "/gui/menu/rock/oregold.png", "/gui/menu/rock/oregoldnether.png", "/gui/menu/rock/oreiron.png", "/gui/menu/rock/oreironnether.png", "/gui/menu/rock/sandstonebottom.png", "/gui/menu/rock/sandstoneside.png", "/gui/menu/rock/sandstonetop.png", "/gui/menu/rock/slowsandstonebottom.png", "/gui/menu/rock/slowsandstoneside.png", "/gui/menu/rock/slowsandstonetop.png", "/gui/menu/rock/stone.png"};
    private static final String menuBlock = menuBlocks[random.nextInt(menuBlocks.length)];

    public void drawScreen(int var1, int var2, float var3) {
        int var4 = 0;
        while (var4 < this.controlList.size()) {
            GuiButton var5 = (GuiButton)this.controlList.get(var4);
            var5.drawButton(this.mc, var1, var2);
            ++var4;
        }
    }

    protected void keyTyped(char var1, int var2) {
        if (var2 == 1) {
            this.mc.displayGuiScreen(null);
            this.mc.setIngameFocus();
        }
    }

    public static String getClipboardString() {
        try {
            Transferable var0 = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (var0 != null && var0.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String var1 = (String)var0.getTransferData(DataFlavor.stringFlavor);
                return var1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void mouseClicked(int var1, int var2, int var3) {
        if (var3 == 0) {
            int var4 = 0;
            while (var4 < this.controlList.size()) {
                GuiButton var5 = (GuiButton)this.controlList.get(var4);
                if (var5.mousePressed(this.mc, var1, var2)) {
                    this.selectedButton = var5;
                    this.mc.sndManager.playSoundFX("random.click", 1.0f, 1.0f);
                    this.actionPerformed(var5);
                }
                ++var4;
            }
        }
    }

    protected void mouseMovedOrUp(int var1, int var2, int var3) {
        if (this.selectedButton != null && var3 == 0) {
            this.selectedButton.mouseReleased(var1, var2);
            this.selectedButton = null;
        }
    }

    protected void actionPerformed(GuiButton var1) {
    }

    public void setWorldAndResolution(Minecraft var1, int var2, int var3) {
        this.field_25091_h = new GuiParticle(var1);
        this.mc = var1;
        this.fontRenderer = var1.fontRenderer;
        this.width = var2;
        this.height = var3;
        this.controlList.clear();
        this.initGui();
    }

    public void initGui() {
    }

    public void handleInput() {
        while (Mouse.next()) {
            this.handleMouseInput();
        }
        while (Keyboard.next()) {
            this.handleKeyboardInput();
        }
    }

    public void handleMouseInput() {
        if (Mouse.getEventButtonState()) {
            int var1 = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int var2 = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            this.mouseClicked(var1, var2, Mouse.getEventButton());
        } else {
            int var1 = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int var2 = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            this.mouseMovedOrUp(var1, var2, Mouse.getEventButton());
        }
    }

    public void handleKeyboardInput() {
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == 87) {
                this.mc.toggleFullscreen();
                return;
            }
            this.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public void onGuiClosed() {
    }

    public void drawDefaultBackground() {
        this.drawWorldBackground(this.updateCounter);
    }

    public void drawDefaultMainMenuBackground(float var1) {
        this.drawSnowyBackgroundRight(var1);
        this.drawSnowyBackgroundLeft(var1);
    }

    public void drawWorldBackground(float var1) {
        if (this.mc.theWorld != null) {
            this.drawGradientRect(0, 0, this.width, this.height, -1072689136, -804253680);
        } else {
            this.drawBackground(var1);
        }
    }

    public void drawBackground(float var1) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator instance = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/menu/ground/dirt.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float texScale = 32.0f;
        instance.startDrawingQuads();
        instance.setColorOpaque_I(0x404040);
        if (GameSettings.doesBackGroundMove) {
            instance.addVertexWithUV(0.0, this.height, 0.0, 0.0, (double)((float)this.height / texScale) + (double)var1);
            instance.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / texScale, (double)((float)this.height / texScale) + (double)var1);
            instance.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / texScale, 0.0f + var1);
            instance.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0f + var1);
        } else {
            instance.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / texScale);
            instance.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / texScale, (float)this.height / texScale);
            instance.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / texScale, 0.0);
            instance.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        }
        instance.draw();
    }

    public void drawSnowyBackgroundRight(float var1) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator instance = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/environment/snow_reversed.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float texScale = 64.0f;
        float texScaleVertical = 256.0f;
        double snowflakeMovement = (double)var1 * 1.5;
        instance.startDrawingQuads();
        instance.addVertexWithUV(0.0, this.height, 0.0, 0.0 + snowflakeMovement, (double)((float)this.height / texScaleVertical) - (double)var1);
        instance.addVertexWithUV(this.width, this.height, 0.0, (double)((float)this.width / texScale) + (0.0 + snowflakeMovement), (double)((float)this.height / texScaleVertical) - (double)var1);
        instance.addVertexWithUV(this.width, 0.0, 0.0, (double)((float)this.width / texScale) + (0.0 + snowflakeMovement), 0.0f - var1);
        instance.addVertexWithUV(0.0, 0.0, 0.0, 0.0 + snowflakeMovement, 0.0f - var1);
        instance.draw();
    }

    public void drawSnowyBackgroundLeft(float var1) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator instance = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/environment/snow.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float texScale = 64.0f;
        float texScaleVertical = 256.0f;
        double snowflakeMovement = (double)var1 * 1.5;
        instance.startDrawingQuads();
        instance.addVertexWithUV(0.0, this.height, 0.0, 0.0 - snowflakeMovement, (double)((float)this.height / texScaleVertical) - (double)var1);
        instance.addVertexWithUV(this.width, this.height, 0.0, (double)((float)this.width / texScale) + (0.0 - snowflakeMovement), (double)((float)this.height / texScaleVertical) - (double)var1);
        instance.addVertexWithUV(this.width, 0.0, 0.0, (double)((float)this.width / texScale) + (0.0 - snowflakeMovement), 0.0f - var1);
        instance.addVertexWithUV(0.0, 0.0, 0.0, 0.0 - snowflakeMovement, 0.0f - var1);
        instance.draw();
    }

    public boolean doesGuiPauseGame() {
        return true;
    }

    public void deleteWorld(boolean var1, int var2) {
    }

    public void selectNextField() {
    }
}

