/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.client.gui;

import java.util.Random;
import net.minecraft.src.client.gui.ChatAllowedCharacters;
import net.minecraft.src.client.gui.GuiButton;
import net.minecraft.src.client.gui.GuiScreen;
import net.minecraft.src.client.gui.GuiTextField;
import net.minecraft.src.client.gui.StringTranslate;
import net.minecraft.src.client.player.PlayerControllerSP;
import net.minecraft.src.client.player.PlayerControllerTest;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.level.WorldSettings;
import net.minecraft.src.game.level.chunk.ISaveFormat;
import net.minecraft.src.game.stats.StatCollector;
import org.lwjgl.input.Keyboard;

public class GuiCreateWorld
extends GuiScreen {
    private GuiScreen parentGuiScreen;
    private GuiTextField textboxWorldName;
    private GuiTextField textboxSeed;
    private String folderName;
    private String field_35364_f = "survival";
    private boolean field_35365_g = true;
    private boolean field_40232_h = false;
    private boolean createClicked;
    private boolean field_35368_i;
    private GuiButton field_35366_j;
    private GuiButton field_35367_k;
    private GuiButton field_35372_s;
    private GuiButton field_35371_t;
    private String field_35370_u;
    private String field_35369_v;
    private String field_41048_x;
    private String field_41047_y;

    public GuiCreateWorld(GuiScreen guiscreen) {
        this.parentGuiScreen = guiscreen;
        this.field_41048_x = "";
        this.field_41047_y = StatCollector.translateToLocal("selectWorld.newWorld");
    }

    @Override
    public void updateScreen() {
        this.textboxWorldName.updateCursorCounter();
        this.textboxSeed.updateCursorCounter();
        this.updateCounter += 0.01f;
    }

    @Override
    public void initGui() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        Keyboard.enableRepeatEvents((boolean)true);
        this.controlList.clear();
        this.controlList.add(new GuiButton(0, this.width / 2 - 155, this.height - 28, 150, 20, stringtranslate.translateKey("selectWorld.create")));
        this.controlList.add(new GuiButton(1, this.width / 2 + 5, this.height - 28, 150, 20, stringtranslate.translateKey("gui.cancel")));
        this.field_35366_j = new GuiButton(2, this.width / 2 - 75, 100, 150, 20, stringtranslate.translateKey("selectWorld.gameMode"));
        this.controlList.add(this.field_35366_j);
        this.field_35367_k = new GuiButton(3, this.width / 2 - 75, 172, 150, 20, stringtranslate.translateKey("selectWorld.moreWorldOptions"));
        this.controlList.add(this.field_35367_k);
        this.field_35372_s = new GuiButton(4, this.width / 2 - 155, 100, 150, 20, stringtranslate.translateKey("selectWorld.mapFeatures"));
        this.controlList.add(this.field_35372_s);
        this.field_35372_s.enabled2 = false;
        this.field_35371_t = new GuiButton(5, this.width / 2 + 5, 100, 150, 20, stringtranslate.translateKey("selectWorld.mapType"));
        this.controlList.add(this.field_35371_t);
        this.field_35371_t.enabled2 = false;
        this.field_35371_t.enabled = false;
        this.textboxWorldName = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, 60, 200, 20, this.field_41047_y);
        this.textboxWorldName.isFocused = true;
        this.textboxWorldName.setMaxStringLength(32);
        this.textboxSeed = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, 60, 200, 20, this.field_41048_x);
        this.makeUseableName();
        this.func_35363_g();
    }

    private void makeUseableName() {
        this.folderName = this.textboxWorldName.getText().trim();
        char[] ac = ChatAllowedCharacters.allowedCharactersArray;
        int i = ac.length;
        int j = 0;
        while (j < i) {
            char c = ac[j];
            this.folderName = this.folderName.replace(c, '_');
            ++j;
        }
        if (MathHelper.stringNullOrLengthZero(this.folderName)) {
            this.folderName = "World";
        }
        this.folderName = GuiCreateWorld.generateUnusedFolderName(this.mc.getSaveLoader(), this.folderName);
    }

    private void func_35363_g() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.field_35366_j.displayString = stringtranslate.translateKey("selectWorld.gameMode") + " " + stringtranslate.translateKey("selectWorld.gameMode." + this.field_35364_f);
        this.field_35370_u = stringtranslate.translateKey("selectWorld.gameMode." + this.field_35364_f + ".line1");
        this.field_35369_v = stringtranslate.translateKey("selectWorld.gameMode." + this.field_35364_f + ".line2");
        this.field_35372_s.displayString = stringtranslate.translateKey("selectWorld.mapFeatures") + " ";
        this.field_35372_s.displayString = this.field_35365_g ? String.valueOf(this.field_35372_s.displayString) + stringtranslate.translateKey("options.on") : String.valueOf(this.field_35372_s.displayString) + stringtranslate.translateKey("options.off");
        this.field_35371_t.displayString = stringtranslate.translateKey("selectWorld.mapType") + " " + stringtranslate.translateKey("selectWorld.mapType.normal");
    }

    public static String generateUnusedFolderName(ISaveFormat isaveformat, String s) {
        while (isaveformat.func_22173_b(s) != null) {
            s = s + "-";
        }
        return s;
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 1) {
            this.mc.displayGuiScreen(this.parentGuiScreen);
        } else if (guibutton.id == 0) {
            this.mc.displayGuiScreen(null);
            if (this.createClicked) {
                return;
            }
            this.createClicked = true;
            long l = new Random().nextLong();
            String s = this.textboxSeed.getText();
            if (!MathHelper.stringNullOrLengthZero(s)) {
                try {
                    long l1 = Long.parseLong(s);
                    if (l1 != 0L) {
                        l = l1;
                    }
                }
                catch (NumberFormatException numberformatexception) {
                    l = s.hashCode();
                }
            }
            int i = 0;
            if (this.field_35364_f.equals("creative")) {
                i = 1;
                this.mc.playerController = new PlayerControllerTest(this.mc);
            } else {
                this.mc.playerController = new PlayerControllerSP(this.mc);
            }
            this.mc.startWorld(this.folderName, this.textboxWorldName.getText(), new WorldSettings(l, i, this.field_35365_g, this.field_40232_h));
            this.mc.displayGuiScreen(null);
        } else if (guibutton.id == 3) {
            this.field_35368_i = !this.field_35368_i;
            this.field_35366_j.enabled2 = !this.field_35368_i;
            this.field_35372_s.enabled2 = this.field_35368_i;
            this.field_35371_t.enabled2 = this.field_35368_i;
            if (this.field_35368_i) {
                StringTranslate stringtranslate = StringTranslate.getInstance();
                this.field_35367_k.displayString = stringtranslate.translateKey("gui.done");
            } else {
                StringTranslate stringtranslate1 = StringTranslate.getInstance();
                this.field_35367_k.displayString = stringtranslate1.translateKey("selectWorld.moreWorldOptions");
            }
        } else if (guibutton.id == 2) {
            if (this.field_35364_f.equals("survival")) {
                this.field_40232_h = false;
                this.field_35364_f = "hardcore";
                this.field_40232_h = true;
                this.func_35363_g();
            } else if (this.field_35364_f.equals("hardcore")) {
                this.field_40232_h = false;
                this.field_35364_f = "creative";
                this.func_35363_g();
                this.field_40232_h = false;
            } else {
                this.field_35364_f = "survival";
                this.func_35363_g();
                this.field_40232_h = false;
            }
            this.func_35363_g();
        } else if (guibutton.id == 4) {
            this.field_35365_g = !this.field_35365_g;
            this.func_35363_g();
        }
    }

    @Override
    protected void keyTyped(char c, int i) {
        if (this.textboxWorldName.isFocused && !this.field_35368_i) {
            this.textboxWorldName.textboxKeyTyped(c, i);
            this.field_41047_y = this.textboxWorldName.getText();
        } else if (this.textboxSeed.isFocused && this.field_35368_i) {
            this.textboxSeed.textboxKeyTyped(c, i);
            this.field_41048_x = this.textboxSeed.getText();
        }
        if (c == '\r') {
            this.actionPerformed((GuiButton)this.controlList.get(0));
        }
        ((GuiButton)this.controlList.get((int)0)).enabled = this.textboxWorldName.getText().length() > 0;
        this.makeUseableName();
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        if (!this.field_35368_i) {
            this.textboxWorldName.mouseClicked(i, j, k);
        } else {
            this.textboxSeed.mouseClicked(i, j, k);
        }
    }

    @Override
    public void drawScreen(int i, int j, float f) {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, stringtranslate.translateKey("selectWorld.create"), this.width / 2, 20, 0xFFFFFF);
        if (!this.field_35368_i) {
            this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.enterName"), this.width / 2 - 100, 47, 0xA0A0A0);
            this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.resultFolder") + " " + this.folderName, this.width / 2 - 100, 85, 0xA0A0A0);
            this.textboxWorldName.drawTextBox();
            this.drawString(this.fontRenderer, this.field_35370_u, this.width / 2 - 100, 122, 0xA0A0A0);
            this.drawString(this.fontRenderer, this.field_35369_v, this.width / 2 - 100, 134, 0xA0A0A0);
        } else {
            this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.enterSeed"), this.width / 2 - 100, 47, 0xA0A0A0);
            this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.seedInfo"), this.width / 2 - 100, 85, 0xA0A0A0);
            this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.mapFeatures.info"), this.width / 2 - 150, 122, 0xA0A0A0);
            this.textboxSeed.drawTextBox();
        }
        super.drawScreen(i, j, f);
    }

    @Override
    public void selectNextField() {
        if (this.textboxWorldName.isFocused) {
            this.textboxWorldName.setFocused(false);
            this.textboxSeed.setFocused(true);
        } else {
            this.textboxWorldName.setFocused(true);
            this.textboxSeed.setFocused(false);
        }
    }
}

