/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.CodeBook;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Floor0$EchstateFloor0;
import com.jcraft.jorbis.Floor0$InfoFloor0;
import com.jcraft.jorbis.Floor0$LookFloor0;
import com.jcraft.jorbis.FuncFloor;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.Lsp;
import com.jcraft.jorbis.Util;

class Floor0
extends FuncFloor {
    float[] lsp = null;

    Floor0() {
    }

    @Override
    void pack(Object object, Buffer buffer) {
        Floor0$InfoFloor0 floor0$InfoFloor0 = (Floor0$InfoFloor0)object;
        buffer.write(floor0$InfoFloor0.order, 8);
        buffer.write(floor0$InfoFloor0.rate, 16);
        buffer.write(floor0$InfoFloor0.barkmap, 16);
        buffer.write(floor0$InfoFloor0.ampbits, 6);
        buffer.write(floor0$InfoFloor0.ampdB, 8);
        buffer.write(floor0$InfoFloor0.numbooks - 1, 4);
        int n2 = 0;
        while (n2 < floor0$InfoFloor0.numbooks) {
            buffer.write(floor0$InfoFloor0.books[n2], 8);
            ++n2;
        }
    }

    @Override
    Object unpack(Info info, Buffer buffer) {
        Floor0$InfoFloor0 floor0$InfoFloor0 = new Floor0$InfoFloor0(this);
        floor0$InfoFloor0.order = buffer.read(8);
        floor0$InfoFloor0.rate = buffer.read(16);
        floor0$InfoFloor0.barkmap = buffer.read(16);
        floor0$InfoFloor0.ampbits = buffer.read(6);
        floor0$InfoFloor0.ampdB = buffer.read(8);
        floor0$InfoFloor0.numbooks = buffer.read(4) + 1;
        if (floor0$InfoFloor0.order < 1 || floor0$InfoFloor0.rate < 1 || floor0$InfoFloor0.barkmap < 1 || floor0$InfoFloor0.numbooks < 1) {
            return null;
        }
        int n2 = 0;
        while (n2 < floor0$InfoFloor0.numbooks) {
            floor0$InfoFloor0.books[n2] = buffer.read(8);
            if (floor0$InfoFloor0.books[n2] < 0 || floor0$InfoFloor0.books[n2] >= info.books) {
                return null;
            }
            ++n2;
        }
        return floor0$InfoFloor0;
    }

    @Override
    Object look(DspState dspState, InfoMode infoMode, Object object) {
        Info info = dspState.vi;
        Floor0$InfoFloor0 floor0$InfoFloor0 = (Floor0$InfoFloor0)object;
        Floor0$LookFloor0 floor0$LookFloor0 = new Floor0$LookFloor0(this);
        floor0$LookFloor0.m = floor0$InfoFloor0.order;
        floor0$LookFloor0.n = info.blocksizes[infoMode.blockflag] / 2;
        floor0$LookFloor0.ln = floor0$InfoFloor0.barkmap;
        floor0$LookFloor0.vi = floor0$InfoFloor0;
        floor0$LookFloor0.lpclook.init(floor0$LookFloor0.ln, floor0$LookFloor0.m);
        float f2 = (float)floor0$LookFloor0.ln / Floor0.toBARK((float)((double)floor0$InfoFloor0.rate / 2.0));
        floor0$LookFloor0.linearmap = new int[floor0$LookFloor0.n];
        int n2 = 0;
        while (n2 < floor0$LookFloor0.n) {
            int n3 = (int)Math.floor(Floor0.toBARK((float)((double)floor0$InfoFloor0.rate / 2.0 / (double)floor0$LookFloor0.n * (double)n2)) * f2);
            if (n3 >= floor0$LookFloor0.ln) {
                n3 = floor0$LookFloor0.ln;
            }
            floor0$LookFloor0.linearmap[n2] = n3;
            ++n2;
        }
        return floor0$LookFloor0;
    }

    static float toBARK(float f2) {
        return (float)(13.1 * Math.atan(7.4E-4 * (double)f2) + 2.24 * Math.atan((double)(f2 * f2) * 1.85E-8) + 1.0E-4 * (double)f2);
    }

    Object state(Object object) {
        Floor0$EchstateFloor0 floor0$EchstateFloor0 = new Floor0$EchstateFloor0(this);
        Floor0$InfoFloor0 floor0$InfoFloor0 = (Floor0$InfoFloor0)object;
        floor0$EchstateFloor0.codewords = new int[floor0$InfoFloor0.order];
        floor0$EchstateFloor0.curve = new float[floor0$InfoFloor0.barkmap];
        floor0$EchstateFloor0.frameno = -1L;
        return floor0$EchstateFloor0;
    }

    @Override
    void free_info(Object object) {
    }

    @Override
    void free_look(Object object) {
    }

    @Override
    void free_state(Object object) {
    }

    @Override
    int forward(Block block, Object object, float[] fArray, float[] fArray2, Object object2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    int inverse(Block block, Object object, float[] fArray) {
        Floor0$LookFloor0 floor0$LookFloor0 = (Floor0$LookFloor0)object;
        Floor0$InfoFloor0 floor0$InfoFloor0 = floor0$LookFloor0.vi;
        int n2 = block.opb.read(floor0$InfoFloor0.ampbits);
        if (n2 > 0) {
            int n3 = (1 << floor0$InfoFloor0.ampbits) - 1;
            float f2 = (float)n2 / (float)n3 * (float)floor0$InfoFloor0.ampdB;
            int n4 = block.opb.read(Util.ilog(floor0$InfoFloor0.numbooks));
            if (n4 != -1 && n4 < floor0$InfoFloor0.numbooks) {
                Floor0 floor0 = this;
                synchronized (floor0) {
                    if (this.lsp == null || this.lsp.length < floor0$LookFloor0.m) {
                        this.lsp = new float[floor0$LookFloor0.m];
                    } else {
                        int n5 = 0;
                        while (n5 < floor0$LookFloor0.m) {
                            this.lsp[n5] = 0.0f;
                            ++n5;
                        }
                    }
                    CodeBook codeBook = block.vd.fullbooks[floor0$InfoFloor0.books[n4]];
                    float f3 = 0.0f;
                    int n6 = 0;
                    while (n6 < floor0$LookFloor0.m) {
                        fArray[n6] = 0.0f;
                        ++n6;
                    }
                    n6 = 0;
                    while (n6 < floor0$LookFloor0.m) {
                        if (codeBook.decodevs(this.lsp, n6, block.opb, 1, -1) == -1) {
                            int n7 = 0;
                            while (n7 < floor0$LookFloor0.n) {
                                fArray[n7] = 0.0f;
                                ++n7;
                            }
                            return 0;
                        }
                        n6 += codeBook.dim;
                    }
                    n6 = 0;
                    while (n6 < floor0$LookFloor0.m) {
                        int n8 = 0;
                        while (n8 < codeBook.dim) {
                            int n9 = n6++;
                            this.lsp[n9] = this.lsp[n9] + f3;
                            ++n8;
                        }
                        f3 = this.lsp[n6 - 1];
                    }
                    Lsp.lsp_to_curve(fArray, floor0$LookFloor0.linearmap, floor0$LookFloor0.n, floor0$LookFloor0.ln, this.lsp, floor0$LookFloor0.m, f2, floor0$InfoFloor0.ampdB);
                    return 1;
                }
            }
        }
        return 0;
    }

    @Override
    Object inverse1(Block block, Object object, Object object2) {
        int n2;
        Floor0$LookFloor0 floor0$LookFloor0 = (Floor0$LookFloor0)object;
        Floor0$InfoFloor0 floor0$InfoFloor0 = floor0$LookFloor0.vi;
        float[] fArray = null;
        if (object2 instanceof float[]) {
            fArray = (float[])object2;
        }
        if ((n2 = block.opb.read(floor0$InfoFloor0.ampbits)) > 0) {
            int n3 = (1 << floor0$InfoFloor0.ampbits) - 1;
            float f2 = (float)n2 / (float)n3 * (float)floor0$InfoFloor0.ampdB;
            int n4 = block.opb.read(Util.ilog(floor0$InfoFloor0.numbooks));
            if (n4 != -1 && n4 < floor0$InfoFloor0.numbooks) {
                int n5;
                CodeBook codeBook = block.vd.fullbooks[floor0$InfoFloor0.books[n4]];
                float f3 = 0.0f;
                if (fArray == null || fArray.length < floor0$LookFloor0.m + 1) {
                    fArray = new float[floor0$LookFloor0.m + 1];
                } else {
                    n5 = 0;
                    while (n5 < fArray.length) {
                        fArray[n5] = 0.0f;
                        ++n5;
                    }
                }
                n5 = 0;
                while (n5 < floor0$LookFloor0.m) {
                    if (codeBook.decodev_set(fArray, n5, block.opb, codeBook.dim) == -1) {
                        return null;
                    }
                    n5 += codeBook.dim;
                }
                n5 = 0;
                while (n5 < floor0$LookFloor0.m) {
                    int n6 = 0;
                    while (n6 < codeBook.dim) {
                        int n7 = n5++;
                        fArray[n7] = fArray[n7] + f3;
                        ++n6;
                    }
                    f3 = fArray[n5 - 1];
                }
                fArray[floor0$LookFloor0.m] = f2;
                return fArray;
            }
        }
        return null;
    }

    @Override
    int inverse2(Block block, Object object, Object object2, float[] fArray) {
        Floor0$LookFloor0 floor0$LookFloor0 = (Floor0$LookFloor0)object;
        Floor0$InfoFloor0 floor0$InfoFloor0 = floor0$LookFloor0.vi;
        if (object2 != null) {
            float[] fArray2 = (float[])object2;
            float f2 = fArray2[floor0$LookFloor0.m];
            Lsp.lsp_to_curve(fArray, floor0$LookFloor0.linearmap, floor0$LookFloor0.n, floor0$LookFloor0.ln, fArray2, floor0$LookFloor0.m, f2, floor0$InfoFloor0.ampdB);
            return 1;
        }
        int n2 = 0;
        while (n2 < floor0$LookFloor0.n) {
            fArray[n2] = 0.0f;
            ++n2;
        }
        return 0;
    }

    static float fromdB(float f2) {
        return (float)Math.exp((double)f2 * 0.11512925);
    }

    static void lsp_to_lpc(float[] fArray, float[] fArray2, int n2) {
        int n3 = n2 / 2;
        float[] fArray3 = new float[n3];
        float[] fArray4 = new float[n3];
        float[] fArray5 = new float[n3 + 1];
        float[] fArray6 = new float[n3 + 1];
        float[] fArray7 = new float[n3];
        float[] fArray8 = new float[n3];
        int n4 = 0;
        while (n4 < n3) {
            fArray3[n4] = (float)(-2.0 * Math.cos(fArray[n4 * 2]));
            fArray4[n4] = (float)(-2.0 * Math.cos(fArray[n4 * 2 + 1]));
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            fArray5[n5] = 0.0f;
            fArray6[n5] = 1.0f;
            fArray7[n5] = 0.0f;
            fArray8[n5] = 1.0f;
            ++n5;
        }
        fArray6[n5] = 1.0f;
        fArray5[n5] = 1.0f;
        n4 = 1;
        while (n4 < n2 + 1) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            n5 = 0;
            while (n5 < n3) {
                float f4 = fArray3[n5] * fArray6[n5] + fArray5[n5];
                fArray5[n5] = fArray6[n5];
                fArray6[n5] = f3;
                f3 += f4;
                f4 = fArray4[n5] * fArray8[n5] + fArray7[n5];
                fArray7[n5] = fArray8[n5];
                fArray8[n5] = f2;
                f2 += f4;
                ++n5;
            }
            fArray2[n4 - 1] = (f3 + fArray6[n5] + f2 - fArray5[n5]) / 2.0f;
            fArray6[n5] = f3;
            fArray5[n5] = f2;
            ++n4;
        }
    }

    static void lpc_to_curve(float[] fArray, float[] fArray2, float f2, Floor0$LookFloor0 floor0$LookFloor0, String string, int n2) {
        float[] fArray3 = new float[Math.max(floor0$LookFloor0.ln * 2, floor0$LookFloor0.m * 2 + 2)];
        if (f2 == 0.0f) {
            int n3 = 0;
            while (n3 < floor0$LookFloor0.n) {
                fArray[n3] = 0.0f;
                ++n3;
            }
            return;
        }
        floor0$LookFloor0.lpclook.lpc_to_curve(fArray3, fArray2, f2);
        int n4 = 0;
        while (n4 < floor0$LookFloor0.n) {
            fArray[n4] = fArray3[floor0$LookFloor0.linearmap[n4]];
            ++n4;
        }
    }
}

