/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.codecs;

import a.a.a.b;
import a.a.a.f;
import a.a.c.g;
import a.a.c.x;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemLogger;
import paulscode.sound.codecs.CodecJOgg$OggInputStream;

public class CodecJOgg
implements ICodec {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final boolean XXX = false;
    private boolean endOfStream = false;
    private boolean initialized = false;
    private boolean reverseBytes = false;
    private b cachedUrlStream = null;
    private f myLogicalOggStream = null;
    private x myVorbisStream = null;
    private CodecJOgg$OggInputStream myOggInputStream = null;
    private g myIdentificationHeader = null;
    private AudioFormat myAudioFormat = null;
    private AudioInputStream myAudioInputStream = null;
    private SoundSystemLogger logger = SoundSystemConfig.getLogger();

    @Override
    public void reverseByteOrder(boolean bl) {
        this.reverseBytes = bl;
    }

    @Override
    public boolean initialize(URL uRL) {
        this.initialized(true, false);
        this.cleanup();
        if (uRL == null) {
            this.errorMessage("url null in method 'initialize'");
            this.cleanup();
            return false;
        }
        try {
            this.cachedUrlStream = new b(uRL);
            this.myLogicalOggStream = (f)this.cachedUrlStream.a().iterator().next();
            this.myVorbisStream = new x(this.myLogicalOggStream);
            this.myOggInputStream = new CodecJOgg$OggInputStream(this, this.myVorbisStream);
            this.myIdentificationHeader = this.myVorbisStream.a();
            this.myAudioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.myIdentificationHeader.a(), 16, this.myIdentificationHeader.e(), this.myIdentificationHeader.e() * 2, this.myIdentificationHeader.a(), true);
            this.myAudioInputStream = new AudioInputStream(this.myOggInputStream, this.myAudioFormat, -1L);
        }
        catch (Exception exception) {
            this.errorMessage("Unable to set up input streams in method 'initialize'");
            this.printStackTrace(exception);
            this.cleanup();
            return false;
        }
        if (this.myAudioInputStream == null) {
            this.errorMessage("Unable to set up audio input stream in method 'initialize'");
            this.cleanup();
            return false;
        }
        this.endOfStream(true, false);
        this.initialized(true, true);
        return true;
    }

    @Override
    public boolean initialized() {
        return this.initialized(false, false);
    }

    @Override
    public SoundBuffer read() {
        if (this.myAudioInputStream == null) {
            this.endOfStream(true, true);
            return null;
        }
        AudioFormat audioFormat = this.myAudioInputStream.getFormat();
        if (audioFormat == null) {
            this.errorMessage("Audio Format null in method 'read'");
            this.endOfStream(true, true);
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[SoundSystemConfig.getStreamingBufferSize()];
        try {
            while (!this.endOfStream(false, false) && n2 < byArray.length) {
                n3 = this.myAudioInputStream.read(byArray, n2, byArray.length - n2);
                if (n3 <= 0) {
                    this.endOfStream(true, true);
                    break;
                }
                n2 += n3;
            }
        }
        catch (IOException iOException) {
            this.endOfStream(true, true);
            return null;
        }
        if (n2 <= 0) {
            this.endOfStream(true, true);
            return null;
        }
        if (this.reverseBytes) {
            CodecJOgg.reverseBytes(byArray, 0, n2);
        }
        if (n2 < byArray.length) {
            byArray = CodecJOgg.trimArray(byArray, n2);
        }
        byte[] byArray2 = CodecJOgg.convertAudioBytes(byArray, audioFormat.getSampleSizeInBits() == 16);
        SoundBuffer soundBuffer = new SoundBuffer(byArray2, audioFormat);
        return soundBuffer;
    }

    @Override
    public SoundBuffer readAll() {
        int n2;
        int n3;
        if (this.myAudioFormat == null) {
            this.errorMessage("Audio Format null in method 'readAll'");
            return null;
        }
        byte[] byArray = null;
        int n4 = this.myAudioFormat.getChannels() * (int)this.myAudioInputStream.getFrameLength() * this.myAudioFormat.getSampleSizeInBits() / 8;
        if (n4 > 0) {
            byArray = new byte[this.myAudioFormat.getChannels() * (int)this.myAudioInputStream.getFrameLength() * this.myAudioFormat.getSampleSizeInBits() / 8];
            n3 = 0;
            n2 = 0;
            try {
                while ((n3 = this.myAudioInputStream.read(byArray, n2, byArray.length - n2)) != -1 && n2 < byArray.length) {
                    n2 += n3;
                }
            }
            catch (IOException iOException) {
                this.errorMessage("Exception thrown while reading from the AudioInputStream (location #1).");
                this.printStackTrace(iOException);
                return null;
            }
        }
        n3 = 0;
        n2 = 0;
        int n5 = 0;
        byte[] byArray2 = null;
        byArray2 = new byte[SoundSystemConfig.getFileChunkSize()];
        while (!this.endOfStream(false, false) && n3 < SoundSystemConfig.getMaxFileSize()) {
            n2 = 0;
            n5 = 0;
            try {
                while (n2 < byArray2.length) {
                    n5 = this.myAudioInputStream.read(byArray2, n2, byArray2.length - n2);
                    if (n5 <= 0) {
                        this.endOfStream(true, true);
                        break;
                    }
                    n2 += n5;
                }
            }
            catch (IOException iOException) {
                this.errorMessage("Exception thrown while reading from the AudioInputStream (location #2).");
                this.printStackTrace(iOException);
                return null;
            }
            if (this.reverseBytes) {
                CodecJOgg.reverseBytes(byArray2, 0, n2);
            }
            n3 += n2;
            byArray = CodecJOgg.appendByteArrays(byArray, byArray2, n2);
        }
        byte[] byArray3 = CodecJOgg.convertAudioBytes(byArray, this.myAudioFormat.getSampleSizeInBits() == 16);
        SoundBuffer soundBuffer = new SoundBuffer(byArray3, this.myAudioFormat);
        try {
            this.myAudioInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return soundBuffer;
    }

    @Override
    public boolean endOfStream() {
        return this.endOfStream(false, false);
    }

    @Override
    public void cleanup() {
        if (this.myLogicalOggStream != null) {
            try {
                this.myLogicalOggStream.d();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.myVorbisStream != null) {
            try {
                this.myVorbisStream.e();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.myOggInputStream != null) {
            try {
                this.myOggInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.myAudioInputStream != null) {
            try {
                this.myAudioInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myLogicalOggStream = null;
        this.myVorbisStream = null;
        this.myOggInputStream = null;
        this.myAudioInputStream = null;
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.myAudioFormat;
    }

    private synchronized boolean initialized(boolean bl, boolean bl2) {
        if (bl) {
            this.initialized = bl2;
        }
        return this.initialized;
    }

    private synchronized boolean endOfStream(boolean bl, boolean bl2) {
        if (bl) {
            this.endOfStream = bl2;
        }
        return this.endOfStream;
    }

    private static byte[] trimArray(byte[] byArray, int n2) {
        byte[] byArray2 = null;
        if (byArray != null && byArray.length > n2) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
        }
        return byArray2;
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] convertAudioBytes(byte[] var0, boolean var1_1) {
        block3: {
            var2_2 = ByteBuffer.allocateDirect(var0.length);
            var2_2.order(ByteOrder.nativeOrder());
            var3_3 = ByteBuffer.wrap(var0);
            var3_3.order(ByteOrder.LITTLE_ENDIAN);
            if (!var1_1) ** GOTO lbl17
            var4_4 = var2_2.asShortBuffer();
            var5_5 = var3_3.asShortBuffer();
            while (var5_5.hasRemaining()) {
                var4_4.put(var5_5.get());
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var2_2.put(var3_3.get());
lbl17:
                // 2 sources

                ** while (var3_3.hasRemaining())
            }
        }
        var2_2.rewind();
        if (!var2_2.hasArray()) {
            var4_4 = new byte[var2_2.capacity()];
            var2_2.get((byte[])var4_4);
            var2_2.clear();
            return var4_4;
        }
        return var2_2.array();
    }

    private static byte[] appendByteArrays(byte[] byArray, byte[] byArray2, int n2) {
        byte[] byArray3;
        if (byArray == null && byArray2 == null) {
            return null;
        }
        if (byArray == null) {
            byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            byArray2 = null;
        } else if (byArray2 == null) {
            byArray3 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            byArray = null;
        } else {
            byArray3 = new byte[byArray.length + n2];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, n2);
            byArray = null;
            byArray2 = null;
        }
        return byArray3;
    }

    public static void reverseBytes(byte[] byArray) {
        CodecJOgg.reverseBytes(byArray, 0, byArray.length);
    }

    public static void reverseBytes(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        while (n4 < n2 + n3) {
            byte by = byArray[n4];
            byArray[n4] = byArray[n4 + 1];
            byArray[n4 + 1] = by;
            n4 += 2;
        }
    }

    private void errorMessage(String string) {
        this.logger.errorMessage("CodecJOgg", string, 0);
    }

    private void printStackTrace(Exception exception) {
        this.logger.printStackTrace(exception, 1);
    }
}

