/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.FuncFloor;
import com.jcraft.jorbis.FuncMapping;
import com.jcraft.jorbis.FuncResidue;
import com.jcraft.jorbis.FuncTime;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.Mapping0$InfoMapping0;
import com.jcraft.jorbis.Mapping0$LookMapping0;
import com.jcraft.jorbis.Mdct;
import com.jcraft.jorbis.Util;

class Mapping0
extends FuncMapping {
    static int seq = 0;
    float[][] pcmbundle = null;
    int[] zerobundle = null;
    int[] nonzero = null;
    Object[] floormemo = null;

    Mapping0() {
    }

    @Override
    void free_info(Object object) {
    }

    @Override
    void free_look(Object object) {
    }

    @Override
    Object look(DspState dspState, InfoMode infoMode, Object object) {
        Info info = dspState.vi;
        Mapping0$LookMapping0 mapping0$LookMapping0 = new Mapping0$LookMapping0(this);
        Mapping0$InfoMapping0 mapping0$InfoMapping0 = mapping0$LookMapping0.map = (Mapping0$InfoMapping0)object;
        mapping0$LookMapping0.mode = infoMode;
        mapping0$LookMapping0.time_look = new Object[mapping0$InfoMapping0.submaps];
        mapping0$LookMapping0.floor_look = new Object[mapping0$InfoMapping0.submaps];
        mapping0$LookMapping0.residue_look = new Object[mapping0$InfoMapping0.submaps];
        mapping0$LookMapping0.time_func = new FuncTime[mapping0$InfoMapping0.submaps];
        mapping0$LookMapping0.floor_func = new FuncFloor[mapping0$InfoMapping0.submaps];
        mapping0$LookMapping0.residue_func = new FuncResidue[mapping0$InfoMapping0.submaps];
        int n2 = 0;
        while (n2 < mapping0$InfoMapping0.submaps) {
            int n3 = mapping0$InfoMapping0.timesubmap[n2];
            int n4 = mapping0$InfoMapping0.floorsubmap[n2];
            int n5 = mapping0$InfoMapping0.residuesubmap[n2];
            mapping0$LookMapping0.time_func[n2] = FuncTime.time_P[info.time_type[n3]];
            mapping0$LookMapping0.time_look[n2] = mapping0$LookMapping0.time_func[n2].look(dspState, infoMode, info.time_param[n3]);
            mapping0$LookMapping0.floor_func[n2] = FuncFloor.floor_P[info.floor_type[n4]];
            mapping0$LookMapping0.floor_look[n2] = mapping0$LookMapping0.floor_func[n2].look(dspState, infoMode, info.floor_param[n4]);
            mapping0$LookMapping0.residue_func[n2] = FuncResidue.residue_P[info.residue_type[n5]];
            mapping0$LookMapping0.residue_look[n2] = mapping0$LookMapping0.residue_func[n2].look(dspState, infoMode, info.residue_param[n5]);
            ++n2;
        }
        if (info.psys != 0) {
            int cfr_ignored_0 = dspState.analysisp;
        }
        mapping0$LookMapping0.ch = info.channels;
        return mapping0$LookMapping0;
    }

    @Override
    void pack(Info info, Object object, Buffer buffer) {
        int n2;
        Mapping0$InfoMapping0 mapping0$InfoMapping0 = (Mapping0$InfoMapping0)object;
        if (mapping0$InfoMapping0.submaps > 1) {
            buffer.write(1, 1);
            buffer.write(mapping0$InfoMapping0.submaps - 1, 4);
        } else {
            buffer.write(0, 1);
        }
        if (mapping0$InfoMapping0.coupling_steps > 0) {
            buffer.write(1, 1);
            buffer.write(mapping0$InfoMapping0.coupling_steps - 1, 8);
            n2 = 0;
            while (n2 < mapping0$InfoMapping0.coupling_steps) {
                buffer.write(mapping0$InfoMapping0.coupling_mag[n2], Util.ilog2(info.channels));
                buffer.write(mapping0$InfoMapping0.coupling_ang[n2], Util.ilog2(info.channels));
                ++n2;
            }
        } else {
            buffer.write(0, 1);
        }
        buffer.write(0, 2);
        if (mapping0$InfoMapping0.submaps > 1) {
            n2 = 0;
            while (n2 < info.channels) {
                buffer.write(mapping0$InfoMapping0.chmuxlist[n2], 4);
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < mapping0$InfoMapping0.submaps) {
            buffer.write(mapping0$InfoMapping0.timesubmap[n2], 8);
            buffer.write(mapping0$InfoMapping0.floorsubmap[n2], 8);
            buffer.write(mapping0$InfoMapping0.residuesubmap[n2], 8);
            ++n2;
        }
    }

    @Override
    Object unpack(Info info, Buffer buffer) {
        int n2;
        Mapping0$InfoMapping0 mapping0$InfoMapping0 = new Mapping0$InfoMapping0(this);
        mapping0$InfoMapping0.submaps = buffer.read(1) != 0 ? buffer.read(4) + 1 : 1;
        if (buffer.read(1) != 0) {
            mapping0$InfoMapping0.coupling_steps = buffer.read(8) + 1;
            n2 = 0;
            while (n2 < mapping0$InfoMapping0.coupling_steps) {
                int n3 = mapping0$InfoMapping0.coupling_mag[n2] = buffer.read(Util.ilog2(info.channels));
                int n4 = mapping0$InfoMapping0.coupling_ang[n2] = buffer.read(Util.ilog2(info.channels));
                if (n3 < 0 || n4 < 0 || n3 == n4 || n3 >= info.channels || n4 >= info.channels) {
                    mapping0$InfoMapping0.free();
                    return null;
                }
                ++n2;
            }
        }
        if (buffer.read(2) > 0) {
            mapping0$InfoMapping0.free();
            return null;
        }
        if (mapping0$InfoMapping0.submaps > 1) {
            n2 = 0;
            while (n2 < info.channels) {
                mapping0$InfoMapping0.chmuxlist[n2] = buffer.read(4);
                if (mapping0$InfoMapping0.chmuxlist[n2] >= mapping0$InfoMapping0.submaps) {
                    mapping0$InfoMapping0.free();
                    return null;
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < mapping0$InfoMapping0.submaps) {
            mapping0$InfoMapping0.timesubmap[n2] = buffer.read(8);
            if (mapping0$InfoMapping0.timesubmap[n2] >= info.times) {
                mapping0$InfoMapping0.free();
                return null;
            }
            mapping0$InfoMapping0.floorsubmap[n2] = buffer.read(8);
            if (mapping0$InfoMapping0.floorsubmap[n2] >= info.floors) {
                mapping0$InfoMapping0.free();
                return null;
            }
            mapping0$InfoMapping0.residuesubmap[n2] = buffer.read(8);
            if (mapping0$InfoMapping0.residuesubmap[n2] >= info.residues) {
                mapping0$InfoMapping0.free();
                return null;
            }
            ++n2;
        }
        return mapping0$InfoMapping0;
    }

    @Override
    synchronized int inverse(Block block, Object object) {
        int n2;
        int n3;
        float[] fArray;
        DspState dspState = block.vd;
        Info info = dspState.vi;
        Mapping0$LookMapping0 mapping0$LookMapping0 = (Mapping0$LookMapping0)object;
        Mapping0$InfoMapping0 mapping0$InfoMapping0 = mapping0$LookMapping0.map;
        InfoMode infoMode = mapping0$LookMapping0.mode;
        int n4 = block.pcmend = info.blocksizes[block.W];
        float[] fArray2 = dspState.window[block.W][block.lW][block.nW][infoMode.windowtype];
        if (this.pcmbundle == null || this.pcmbundle.length < info.channels) {
            this.pcmbundle = new float[info.channels][];
            this.nonzero = new int[info.channels];
            this.zerobundle = new int[info.channels];
            this.floormemo = new Object[info.channels];
        }
        int n5 = 0;
        while (n5 < info.channels) {
            fArray = block.pcm[n5];
            n3 = mapping0$InfoMapping0.chmuxlist[n5];
            this.floormemo[n5] = mapping0$LookMapping0.floor_func[n3].inverse1(block, mapping0$LookMapping0.floor_look[n3], this.floormemo[n5]);
            this.nonzero[n5] = this.floormemo[n5] != null ? 1 : 0;
            n2 = 0;
            while (n2 < n4 / 2) {
                fArray[n2] = 0.0f;
                ++n2;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < mapping0$InfoMapping0.coupling_steps) {
            if (this.nonzero[mapping0$InfoMapping0.coupling_mag[n5]] != 0 || this.nonzero[mapping0$InfoMapping0.coupling_ang[n5]] != 0) {
                this.nonzero[mapping0$InfoMapping0.coupling_mag[n5]] = 1;
                this.nonzero[mapping0$InfoMapping0.coupling_ang[n5]] = 1;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < mapping0$InfoMapping0.submaps) {
            int n6 = 0;
            n3 = 0;
            while (n3 < info.channels) {
                if (mapping0$InfoMapping0.chmuxlist[n3] == n5) {
                    this.zerobundle[n6] = this.nonzero[n3] != 0 ? 1 : 0;
                    this.pcmbundle[n6++] = block.pcm[n3];
                }
                ++n3;
            }
            mapping0$LookMapping0.residue_func[n5].inverse(block, mapping0$LookMapping0.residue_look[n5], this.pcmbundle, this.zerobundle, n6);
            ++n5;
        }
        n5 = mapping0$InfoMapping0.coupling_steps - 1;
        while (n5 >= 0) {
            fArray = block.pcm[mapping0$InfoMapping0.coupling_mag[n5]];
            float[] fArray3 = block.pcm[mapping0$InfoMapping0.coupling_ang[n5]];
            n2 = 0;
            while (n2 < n4 / 2) {
                float f2 = fArray[n2];
                float f3 = fArray3[n2];
                if (f2 > 0.0f) {
                    if (f3 > 0.0f) {
                        fArray[n2] = f2;
                        fArray3[n2] = f2 - f3;
                    } else {
                        fArray3[n2] = f2;
                        fArray[n2] = f2 + f3;
                    }
                } else if (f3 > 0.0f) {
                    fArray[n2] = f2;
                    fArray3[n2] = f2 + f3;
                } else {
                    fArray3[n2] = f2;
                    fArray[n2] = f2 - f3;
                }
                ++n2;
            }
            --n5;
        }
        n5 = 0;
        while (n5 < info.channels) {
            fArray = block.pcm[n5];
            int n7 = mapping0$InfoMapping0.chmuxlist[n5];
            mapping0$LookMapping0.floor_func[n7].inverse2(block, mapping0$LookMapping0.floor_look[n7], this.floormemo[n5], fArray);
            ++n5;
        }
        n5 = 0;
        while (n5 < info.channels) {
            fArray = block.pcm[n5];
            ((Mdct)dspState.transform[block.W][0]).backward(fArray, fArray);
            ++n5;
        }
        n5 = 0;
        while (n5 < info.channels) {
            int n8;
            fArray = block.pcm[n5];
            if (this.nonzero[n5] != 0) {
                n8 = 0;
                while (n8 < n4) {
                    int n9 = n8;
                    fArray[n9] = fArray[n9] * fArray2[n8];
                    ++n8;
                }
            } else {
                n8 = 0;
                while (n8 < n4) {
                    fArray[n8] = 0.0f;
                    ++n8;
                }
            }
            ++n5;
        }
        return 0;
    }
}

