/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.JOrbisException;
import com.jcraft.jorbis.VorbisFile$SeekableInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VorbisFile {
    static final int CHUNKSIZE = 8500;
    static final int SEEK_SET = 0;
    static final int SEEK_CUR = 1;
    static final int SEEK_END = 2;
    static final int OV_FALSE = -1;
    static final int OV_EOF = -2;
    static final int OV_HOLE = -3;
    static final int OV_EREAD = -128;
    static final int OV_EFAULT = -129;
    static final int OV_EIMPL = -130;
    static final int OV_EINVAL = -131;
    static final int OV_ENOTVORBIS = -132;
    static final int OV_EBADHEADER = -133;
    static final int OV_EVERSION = -134;
    static final int OV_ENOTAUDIO = -135;
    static final int OV_EBADPACKET = -136;
    static final int OV_EBADLINK = -137;
    static final int OV_ENOSEEK = -138;
    InputStream datasource;
    boolean seekable = false;
    long offset;
    long end;
    SyncState oy = new SyncState();
    int links;
    long[] offsets;
    long[] dataoffsets;
    int[] serialnos;
    long[] pcmlengths;
    Info[] vi;
    Comment[] vc;
    long pcm_offset;
    boolean decode_ready = false;
    int current_serialno;
    int current_link;
    float bittrack;
    float samptrack;
    StreamState os = new StreamState();
    DspState vd = new DspState();
    Block vb = new Block(this.vd);

    public VorbisFile(String string) {
        VorbisFile$SeekableInputStream vorbisFile$SeekableInputStream = null;
        try {
            try {
                vorbisFile$SeekableInputStream = new VorbisFile$SeekableInputStream(this, string);
                int n2 = this.open(vorbisFile$SeekableInputStream, null, 0);
                if (n2 == -1) {
                    throw new JOrbisException("VorbisFile: open return -1");
                }
            }
            catch (Exception exception) {
                throw new JOrbisException("VorbisFile: " + exception.toString());
            }
        }
        finally {
            if (vorbisFile$SeekableInputStream != null) {
                try {
                    ((InputStream)vorbisFile$SeekableInputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public VorbisFile(InputStream inputStream, byte[] byArray, int n2) {
        int n3 = this.open(inputStream, byArray, n2);
    }

    private int get_data() {
        int n2 = this.oy.buffer(8500);
        byte[] byArray = this.oy.data;
        int n3 = 0;
        try {
            n3 = this.datasource.read(byArray, n2, 8500);
        }
        catch (Exception exception) {
            return -128;
        }
        this.oy.wrote(n3);
        if (n3 == -1) {
            n3 = 0;
        }
        return n3;
    }

    private void seek_helper(long l2) {
        VorbisFile.fseek(this.datasource, l2, 0);
        this.offset = l2;
        this.oy.reset();
    }

    private int get_next_page(Page page, long l2) {
        int n2;
        int n3;
        block6: {
            if (l2 > 0L) {
                l2 += this.offset;
            }
            while (true) {
                if (l2 > 0L && this.offset >= l2) {
                    return -1;
                }
                n3 = this.oy.pageseek(page);
                if (n3 < 0) {
                    this.offset -= (long)n3;
                    continue;
                }
                if (n3 != 0) break block6;
                if (l2 == 0L) {
                    return -1;
                }
                n2 = this.get_data();
                if (n2 == 0) {
                    return -2;
                }
                if (n2 < 0) break;
            }
            return -128;
        }
        n2 = (int)this.offset;
        this.offset += (long)n3;
        return n2;
    }

    private int get_prev_page(Page page) {
        int n2;
        long l2 = this.offset;
        int n3 = -1;
        block0: while (n3 == -1) {
            if ((l2 -= 8500L) < 0L) {
                l2 = 0L;
            }
            this.seek_helper(l2);
            while (this.offset < l2 + 8500L) {
                n2 = this.get_next_page(page, l2 + 8500L - this.offset);
                if (n2 == -128) {
                    return -128;
                }
                if (n2 < 0) {
                    if (n3 != -1) continue block0;
                    throw new JOrbisException();
                }
                n3 = n2;
            }
        }
        this.seek_helper(n3);
        n2 = this.get_next_page(page, 8500L);
        if (n2 < 0) {
            return -129;
        }
        return n3;
    }

    int bisect_forward_serialno(long l2, long l3, long l4, int n2, int n3) {
        int n4;
        long l5 = l4;
        long l6 = l4;
        Page page = new Page();
        while (l3 < l5) {
            long l7 = l5 - l3 < 8500L ? l3 : (l3 + l5) / 2L;
            this.seek_helper(l7);
            n4 = this.get_next_page(page, -1L);
            if (n4 == -128) {
                return -128;
            }
            if (n4 < 0 || page.serialno() != n2) {
                l5 = l7;
                if (n4 < 0) continue;
                l6 = n4;
                continue;
            }
            l3 = n4 + page.header_len + page.body_len;
        }
        this.seek_helper(l6);
        n4 = this.get_next_page(page, -1L);
        if (n4 == -128) {
            return -128;
        }
        if (l3 >= l4 || n4 == -1) {
            this.links = n3 + 1;
            this.offsets = new long[n3 + 2];
            this.offsets[n3 + 1] = l3;
        } else {
            n4 = this.bisect_forward_serialno(l6, this.offset, l4, page.serialno(), n3 + 1);
            if (n4 == -128) {
                return -128;
            }
        }
        this.offsets[n3] = l2;
        return 0;
    }

    int fetch_headers(Info info, Comment comment, int[] nArray, Page page) {
        Page page2 = new Page();
        Packet packet = new Packet();
        if (page == null) {
            int n2 = this.get_next_page(page2, 8500L);
            if (n2 == -128) {
                return -128;
            }
            if (n2 < 0) {
                return -132;
            }
            page = page2;
        }
        if (nArray != null) {
            nArray[0] = page.serialno();
        }
        this.os.init(page.serialno());
        info.init();
        comment.init();
        int n3 = 0;
        while (n3 < 3) {
            this.os.pagein(page);
            while (n3 < 3) {
                int n4 = this.os.packetout(packet);
                if (n4 == 0) break;
                if (n4 == -1) {
                    info.clear();
                    comment.clear();
                    this.os.clear();
                    return -1;
                }
                if (info.synthesis_headerin(comment, packet) != 0) {
                    info.clear();
                    comment.clear();
                    this.os.clear();
                    return -1;
                }
                ++n3;
            }
            if (n3 >= 3 || this.get_next_page(page, 1L) >= 0) continue;
            info.clear();
            comment.clear();
            this.os.clear();
            return -1;
        }
        return 0;
    }

    void prefetch_all_headers(Info info, Comment comment, int n2) {
        Page page = new Page();
        this.vi = new Info[this.links];
        this.vc = new Comment[this.links];
        this.dataoffsets = new long[this.links];
        this.pcmlengths = new long[this.links];
        this.serialnos = new int[this.links];
        int n3 = 0;
        while (n3 < this.links) {
            block6: {
                if (info != null && comment != null && n3 == 0) {
                    this.vi[n3] = info;
                    this.vc[n3] = comment;
                    this.dataoffsets[n3] = n2;
                } else {
                    this.seek_helper(this.offsets[n3]);
                    this.vi[n3] = new Info();
                    this.vc[n3] = new Comment();
                    if (this.fetch_headers(this.vi[n3], this.vc[n3], null, null) == -1) {
                        this.dataoffsets[n3] = -1L;
                    } else {
                        this.dataoffsets[n3] = this.offset;
                        this.os.clear();
                    }
                }
                long l2 = this.offsets[n3 + 1];
                this.seek_helper(l2);
                do {
                    int n4;
                    if ((n4 = this.get_prev_page(page)) != -1) continue;
                    this.vi[n3].clear();
                    this.vc[n3].clear();
                    break block6;
                } while (page.granulepos() == -1L);
                this.serialnos[n3] = page.serialno();
                this.pcmlengths[n3] = page.granulepos();
            }
            ++n3;
        }
    }

    private int make_decode_ready() {
        if (this.decode_ready) {
            System.exit(1);
        }
        this.vd.synthesis_init(this.vi[0]);
        this.vb.init(this.vd);
        this.decode_ready = true;
        return 0;
    }

    int open_seekable() {
        Info info = new Info();
        Comment comment = new Comment();
        Page page = new Page();
        int[] nArray = new int[1];
        int n2 = this.fetch_headers(info, comment, nArray, null);
        int n3 = nArray[0];
        int n4 = (int)this.offset;
        this.os.clear();
        if (n2 == -1) {
            return -1;
        }
        if (n2 < 0) {
            return n2;
        }
        this.seekable = true;
        VorbisFile.fseek(this.datasource, 0L, 2);
        long l2 = this.offset = VorbisFile.ftell(this.datasource);
        l2 = this.get_prev_page(page);
        if (page.serialno() != n3) {
            if (this.bisect_forward_serialno(0L, 0L, l2 + 1L, n3, 0) < 0) {
                this.clear();
                return -128;
            }
        } else if (this.bisect_forward_serialno(0L, l2, l2 + 1L, n3, 0) < 0) {
            this.clear();
            return -128;
        }
        this.prefetch_all_headers(info, comment, n4);
        return 0;
    }

    int open_nonseekable() {
        this.links = 1;
        this.vi = new Info[this.links];
        this.vi[0] = new Info();
        this.vc = new Comment[this.links];
        this.vc[0] = new Comment();
        int[] nArray = new int[1];
        if (this.fetch_headers(this.vi[0], this.vc[0], nArray, null) == -1) {
            return -1;
        }
        this.current_serialno = nArray[0];
        this.make_decode_ready();
        return 0;
    }

    void decode_clear() {
        this.os.clear();
        this.vd.clear();
        this.vb.clear();
        this.decode_ready = false;
        this.bittrack = 0.0f;
        this.samptrack = 0.0f;
    }

    int process_packet(int n2) {
        Page page = new Page();
        while (true) {
            Packet packet;
            int n3;
            if (this.decode_ready && (n3 = this.os.packetout(packet = new Packet())) > 0) {
                long l2 = packet.granulepos;
                if (this.vb.synthesis(packet) == 0) {
                    int n4 = this.vd.synthesis_pcmout(null, null);
                    this.vd.synthesis_blockin(this.vb);
                    this.samptrack += (float)(this.vd.synthesis_pcmout(null, null) - n4);
                    this.bittrack += (float)(packet.bytes * 8);
                    if (l2 != -1L && packet.e_o_s == 0) {
                        n4 = this.seekable ? this.current_link : 0;
                        int n5 = this.vd.synthesis_pcmout(null, null);
                        l2 -= (long)n5;
                        int n6 = 0;
                        while (n6 < n4) {
                            l2 += this.pcmlengths[n6];
                            ++n6;
                        }
                        this.pcm_offset = l2;
                    }
                    return 1;
                }
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.get_next_page(page, -1L) < 0) {
                return 0;
            }
            this.bittrack += (float)(page.header_len * 8);
            if (this.decode_ready && this.current_serialno != page.serialno()) {
                this.decode_clear();
            }
            if (!this.decode_ready) {
                int n7;
                if (this.seekable) {
                    this.current_serialno = page.serialno();
                    n7 = 0;
                    while (n7 < this.links) {
                        if (this.serialnos[n7] == this.current_serialno) break;
                        ++n7;
                    }
                    if (n7 == this.links) {
                        return -1;
                    }
                    this.current_link = n7;
                    this.os.init(this.current_serialno);
                    this.os.reset();
                } else {
                    int[] nArray = new int[1];
                    int n8 = this.fetch_headers(this.vi[0], this.vc[0], nArray, page);
                    this.current_serialno = nArray[0];
                    if (n8 != 0) {
                        return n8;
                    }
                    ++this.current_link;
                    n7 = 0;
                }
                this.make_decode_ready();
            }
            this.os.pagein(page);
        }
    }

    int clear() {
        this.vb.clear();
        this.vd.clear();
        this.os.clear();
        if (this.vi != null && this.links != 0) {
            int n2 = 0;
            while (n2 < this.links) {
                this.vi[n2].clear();
                this.vc[n2].clear();
                ++n2;
            }
            this.vi = null;
            this.vc = null;
        }
        if (this.dataoffsets != null) {
            this.dataoffsets = null;
        }
        if (this.pcmlengths != null) {
            this.pcmlengths = null;
        }
        if (this.serialnos != null) {
            this.serialnos = null;
        }
        if (this.offsets != null) {
            this.offsets = null;
        }
        this.oy.clear();
        return 0;
    }

    static int fseek(InputStream inputStream, long l2, int n2) {
        if (inputStream instanceof VorbisFile$SeekableInputStream) {
            VorbisFile$SeekableInputStream vorbisFile$SeekableInputStream = (VorbisFile$SeekableInputStream)inputStream;
            try {
                if (n2 == 0) {
                    vorbisFile$SeekableInputStream.seek(l2);
                } else if (n2 == 2) {
                    vorbisFile$SeekableInputStream.seek(vorbisFile$SeekableInputStream.getLength() - l2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }
        try {
            if (n2 == 0) {
                inputStream.reset();
            }
            inputStream.skip(l2);
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    static long ftell(InputStream inputStream) {
        try {
            if (inputStream instanceof VorbisFile$SeekableInputStream) {
                VorbisFile$SeekableInputStream vorbisFile$SeekableInputStream = (VorbisFile$SeekableInputStream)inputStream;
                return vorbisFile$SeekableInputStream.tell();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    int open(InputStream inputStream, byte[] byArray, int n2) {
        return this.open_callbacks(inputStream, byArray, n2);
    }

    int open_callbacks(InputStream inputStream, byte[] byArray, int n2) {
        int n3;
        this.datasource = inputStream;
        this.oy.init();
        if (byArray != null) {
            int n4 = this.oy.buffer(n2);
            System.arraycopy(byArray, 0, this.oy.data, n4, n2);
            this.oy.wrote(n2);
        }
        if ((n3 = inputStream instanceof VorbisFile$SeekableInputStream ? this.open_seekable() : this.open_nonseekable()) != 0) {
            this.datasource = null;
            this.clear();
        }
        return n3;
    }

    public int streams() {
        return this.links;
    }

    public boolean seekable() {
        return this.seekable;
    }

    public int bitrate(int n2) {
        if (n2 >= this.links) {
            return -1;
        }
        if (!this.seekable && n2 != 0) {
            return this.bitrate(0);
        }
        if (n2 < 0) {
            long l2 = 0L;
            int n3 = 0;
            while (n3 < this.links) {
                l2 += (this.offsets[n3 + 1] - this.dataoffsets[n3]) * 8L;
                ++n3;
            }
            return (int)Math.rint((float)l2 / this.time_total(-1));
        }
        if (this.seekable) {
            return (int)Math.rint((float)((this.offsets[n2 + 1] - this.dataoffsets[n2]) * 8L) / this.time_total(n2));
        }
        if (this.vi[n2].bitrate_nominal > 0) {
            return this.vi[n2].bitrate_nominal;
        }
        if (this.vi[n2].bitrate_upper > 0) {
            if (this.vi[n2].bitrate_lower > 0) {
                return (this.vi[n2].bitrate_upper + this.vi[n2].bitrate_lower) / 2;
            }
            return this.vi[n2].bitrate_upper;
        }
        return -1;
    }

    public int bitrate_instant() {
        int n2;
        int n3 = n2 = this.seekable ? this.current_link : 0;
        if (this.samptrack == 0.0f) {
            return -1;
        }
        int n4 = (int)((double)(this.bittrack / this.samptrack * (float)this.vi[n2].rate) + 0.5);
        this.bittrack = 0.0f;
        this.samptrack = 0.0f;
        return n4;
    }

    public int serialnumber(int n2) {
        if (n2 >= this.links) {
            return -1;
        }
        if (!this.seekable && n2 >= 0) {
            return this.serialnumber(-1);
        }
        if (n2 < 0) {
            return this.current_serialno;
        }
        return this.serialnos[n2];
    }

    public long raw_total(int n2) {
        if (!this.seekable || n2 >= this.links) {
            return -1L;
        }
        if (n2 < 0) {
            long l2 = 0L;
            int n3 = 0;
            while (n3 < this.links) {
                l2 += this.raw_total(n3);
                ++n3;
            }
            return l2;
        }
        return this.offsets[n2 + 1] - this.offsets[n2];
    }

    public long pcm_total(int n2) {
        if (!this.seekable || n2 >= this.links) {
            return -1L;
        }
        if (n2 < 0) {
            long l2 = 0L;
            int n3 = 0;
            while (n3 < this.links) {
                l2 += this.pcm_total(n3);
                ++n3;
            }
            return l2;
        }
        return this.pcmlengths[n2];
    }

    public float time_total(int n2) {
        if (!this.seekable || n2 >= this.links) {
            return -1.0f;
        }
        if (n2 < 0) {
            float f2 = 0.0f;
            int n3 = 0;
            while (n3 < this.links) {
                f2 += this.time_total(n3);
                ++n3;
            }
            return f2;
        }
        return (float)this.pcmlengths[n2] / (float)this.vi[n2].rate;
    }

    public int raw_seek(int n2) {
        if (!this.seekable) {
            return -1;
        }
        if (n2 < 0 || (long)n2 > this.offsets[this.links]) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        this.pcm_offset = -1L;
        this.decode_clear();
        this.seek_helper(n2);
        switch (this.process_packet(1)) {
            case 0: {
                this.pcm_offset = this.pcm_total(-1);
                return 0;
            }
            case -1: {
                this.pcm_offset = -1L;
                this.decode_clear();
                return -1;
            }
        }
        while (true) {
            switch (this.process_packet(0)) {
                case 0: {
                    return 0;
                }
                case -1: {
                    this.pcm_offset = -1L;
                    this.decode_clear();
                    return -1;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public int pcm_seek(long var1_1) {
        var3_2 = -1;
        var4_3 = this.pcm_total(-1);
        if (!this.seekable) {
            return -1;
        }
        if (var1_1 < 0L || var1_1 > var4_3) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        var3_2 = this.links - 1;
        while (var3_2 >= 0) {
            if (var1_1 >= (var4_3 -= this.pcmlengths[var3_2])) break;
            --var3_2;
        }
        var6_4 = var1_1 - var4_3;
        var8_6 = this.offsets[var3_2 + 1];
        var10_8 = this.offsets[var3_2];
        var12_9 = (int)var10_8;
        var13_10 = new Page();
        while (var10_8 < var8_6) {
            var14_13 = var8_6 - var10_8 < 8500L ? var10_8 : (var8_6 + var10_8) / 2L;
            this.seek_helper(var14_13);
            var16_11 = this.get_next_page(var13_10, var8_6 - var14_13);
            if (var16_11 == -1) {
                var8_6 = var14_13;
                continue;
            }
            var17_12 = var13_10.granulepos();
            if (var17_12 < var6_4) {
                var12_9 = var16_11;
                var10_8 = this.offset;
                continue;
            }
            var8_6 = var14_13;
        }
        if (this.raw_seek(var12_9) != 0) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        if (this.pcm_offset >= var1_1) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        if (var1_1 <= this.pcm_total(-1)) ** GOTO lbl56
        this.pcm_offset = -1L;
        this.decode_clear();
        return -1;
lbl-1000:
        // 1 sources

        {
            var6_5 = (int)(var1_1 - this.pcm_offset);
            var7_14 = new float[1][][];
            var8_7 = new int[this.getInfo((int)-1).channels];
            var9_15 = this.vd.synthesis_pcmout(var7_14, var8_7);
            if (var9_15 > var6_5) {
                var9_15 = var6_5;
            }
            this.vd.synthesis_read(var9_15);
            this.pcm_offset += (long)var9_15;
            if (var9_15 >= var6_5 || this.process_packet(1) != 0) continue;
            this.pcm_offset = this.pcm_total(-1);
lbl56:
            // 3 sources

            ** while (this.pcm_offset < var1_1)
        }
lbl57:
        // 1 sources

        return 0;
    }

    int time_seek(float f2) {
        int n2 = -1;
        long l2 = this.pcm_total(-1);
        float f3 = this.time_total(-1);
        if (!this.seekable) {
            return -1;
        }
        if (f2 < 0.0f || f2 > f3) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        n2 = this.links - 1;
        while (n2 >= 0) {
            l2 -= this.pcmlengths[n2];
            if (f2 >= (f3 -= this.time_total(n2))) break;
            --n2;
        }
        long l3 = (long)((float)l2 + (f2 - f3) * (float)this.vi[n2].rate);
        return this.pcm_seek(l3);
    }

    public long raw_tell() {
        return this.offset;
    }

    public long pcm_tell() {
        return this.pcm_offset;
    }

    public float time_tell() {
        int n2 = -1;
        long l2 = 0L;
        float f2 = 0.0f;
        if (this.seekable) {
            l2 = this.pcm_total(-1);
            f2 = this.time_total(-1);
            n2 = this.links - 1;
            while (n2 >= 0) {
                f2 -= this.time_total(n2);
                if (this.pcm_offset >= (l2 -= this.pcmlengths[n2])) break;
                --n2;
            }
        }
        return f2 + (float)(this.pcm_offset - l2) / (float)this.vi[n2].rate;
    }

    public Info getInfo(int n2) {
        if (this.seekable) {
            if (n2 < 0) {
                if (this.decode_ready) {
                    return this.vi[this.current_link];
                }
                return null;
            }
            if (n2 >= this.links) {
                return null;
            }
            return this.vi[n2];
        }
        if (this.decode_ready) {
            return this.vi[0];
        }
        return null;
    }

    public Comment getComment(int n2) {
        if (this.seekable) {
            if (n2 < 0) {
                if (this.decode_ready) {
                    return this.vc[this.current_link];
                }
                return null;
            }
            if (n2 >= this.links) {
                return null;
            }
            return this.vc[n2];
        }
        if (this.decode_ready) {
            return this.vc[0];
        }
        return null;
    }

    int host_is_big_endian() {
        return 1;
    }

    int read(byte[] byArray, int n2, int n3, int n4, int n5, int[] nArray) {
        int n6 = this.host_is_big_endian();
        int n7 = 0;
        while (true) {
            if (this.decode_ready) {
                float[][][] fArrayArray = new float[1][][];
                int[] nArray2 = new int[this.getInfo((int)-1).channels];
                int n8 = this.vd.synthesis_pcmout(fArrayArray, nArray2);
                float[][] fArray = fArrayArray[0];
                if (n8 != 0) {
                    int n9 = this.getInfo((int)-1).channels;
                    int n10 = n4 * n9;
                    if (n8 > n2 / n10) {
                        n8 = n2 / n10;
                    }
                    if (n4 == 1) {
                        int n11 = n5 != 0 ? 0 : 128;
                        int n12 = 0;
                        while (n12 < n8) {
                            int n13 = 0;
                            while (n13 < n9) {
                                int n14 = (int)((double)fArray[n13][nArray2[n13] + n12] * 128.0 + 0.5);
                                if (n14 > 127) {
                                    n14 = 127;
                                } else if (n14 < -128) {
                                    n14 = -128;
                                }
                                byArray[n7++] = (byte)(n14 + n11);
                                ++n13;
                            }
                            ++n12;
                        }
                    } else {
                        int n15;
                        int n16 = n15 = n5 != 0 ? 0 : 32768;
                        if (n6 == n3) {
                            if (n5 != 0) {
                                int n17 = 0;
                                while (n17 < n9) {
                                    int n18 = nArray2[n17];
                                    int n19 = n17;
                                    int n20 = 0;
                                    while (n20 < n8) {
                                        int n21 = (int)((double)fArray[n17][n18 + n20] * 32768.0 + 0.5);
                                        if (n21 > Short.MAX_VALUE) {
                                            n21 = Short.MAX_VALUE;
                                        } else if (n21 < Short.MIN_VALUE) {
                                            n21 = Short.MIN_VALUE;
                                        }
                                        byArray[n19] = (byte)(n21 >>> 8);
                                        byArray[n19 + 1] = (byte)n21;
                                        n19 += n9 * 2;
                                        ++n20;
                                    }
                                    ++n17;
                                }
                            } else {
                                int n22 = 0;
                                while (n22 < n9) {
                                    float[] fArray2 = fArray[n22];
                                    int n23 = n22;
                                    int n24 = 0;
                                    while (n24 < n8) {
                                        int n25 = (int)((double)fArray2[n24] * 32768.0 + 0.5);
                                        if (n25 > Short.MAX_VALUE) {
                                            n25 = Short.MAX_VALUE;
                                        } else if (n25 < Short.MIN_VALUE) {
                                            n25 = Short.MIN_VALUE;
                                        }
                                        byArray[n23] = (byte)(n25 + n15 >>> 8);
                                        byArray[n23 + 1] = (byte)(n25 + n15);
                                        n23 += n9 * 2;
                                        ++n24;
                                    }
                                    ++n22;
                                }
                            }
                        } else if (n3 != 0) {
                            int n26 = 0;
                            while (n26 < n8) {
                                int n27 = 0;
                                while (n27 < n9) {
                                    int n28 = (int)((double)fArray[n27][n26] * 32768.0 + 0.5);
                                    if (n28 > Short.MAX_VALUE) {
                                        n28 = Short.MAX_VALUE;
                                    } else if (n28 < Short.MIN_VALUE) {
                                        n28 = Short.MIN_VALUE;
                                    }
                                    byArray[n7++] = (byte)((n28 += n15) >>> 8);
                                    byArray[n7++] = (byte)n28;
                                    ++n27;
                                }
                                ++n26;
                            }
                        } else {
                            int n29 = 0;
                            while (n29 < n8) {
                                int n30 = 0;
                                while (n30 < n9) {
                                    int n31 = (int)((double)fArray[n30][n29] * 32768.0 + 0.5);
                                    if (n31 > Short.MAX_VALUE) {
                                        n31 = Short.MAX_VALUE;
                                    } else if (n31 < Short.MIN_VALUE) {
                                        n31 = Short.MIN_VALUE;
                                    }
                                    byArray[n7++] = (byte)(n31 += n15);
                                    byArray[n7++] = (byte)(n31 >>> 8);
                                    ++n30;
                                }
                                ++n29;
                            }
                        }
                    }
                    this.vd.synthesis_read(n8);
                    this.pcm_offset += (long)n8;
                    if (nArray != null) {
                        nArray[0] = this.current_link;
                    }
                    return n8 * n10;
                }
            }
            switch (this.process_packet(1)) {
                case 0: {
                    return 0;
                }
                case -1: {
                    return -1;
                }
            }
        }
    }

    public Info[] getInfo() {
        return this.vi;
    }

    public Comment[] getComment() {
        return this.vc;
    }

    public void close() {
        this.datasource.close();
    }
}

