/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.mob;

import com.mojang.minecraft.Entity;
import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.mob.a.a;
import com.mojang.minecraft.mob.a.c;
import org.lwjgl.opengl.GL11;

public class Mob
extends Entity {
    public static final int ATTACK_DURATION = 5;
    public static final int TOTAL_AIR_SUPPLY = 300;
    public int invulnerableDuration = 30;
    public float rot;
    public float timeOffs;
    public float speed;
    public float rotA = (float)(Math.random() + 1.0) * 0.01f;
    protected float yBodyRot = 0.0f;
    protected float yBodyRotO = 0.0f;
    protected float oRun;
    protected float run;
    protected float animStep;
    protected float animStepO;
    protected int tickCount = 0;
    public boolean hasHair = true;
    protected String textureName = "/char.png";
    public boolean allowAlpha = true;
    public com.mojang.minecraft.d.a model = null;
    public float rotOffs = 0.0f;
    public int health = 20;
    public int lastHealth;
    public int invulnerableTime = 0;
    public int airSupply = 300;
    public int hurtTime;
    public int hurtDuration;
    public float hurtDir = 0.0f;
    public int deathTime = 0;
    public int attackTime = 0;
    public float oTilt;
    public float tilt;
    protected boolean dead = false;
    public a ai;

    public Mob(Level level) {
        super(level);
        this.setPos(this.x, this.y, this.z);
        this.timeOffs = (float)Math.random() * 12398.0f;
        this.rot = (float)(Math.random() * Math.PI * 2.0);
        this.speed = 1.0f;
        this.ai = new c();
    }

    public boolean isPickable() {
        return !this.removed;
    }

    public boolean isPushable() {
        return !this.removed;
    }

    public final void tick() {
        boolean bl;
        super.tick();
        this.oTilt = this.tilt;
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        if (this.health <= 0) {
            ++this.deathTime;
            if (this.deathTime > 20) {
                if (this.ai != null) {
                    this.ai.a();
                }
                this.remove();
            }
        }
        if (this.isUnderWater()) {
            if (this.airSupply > 0) {
                --this.airSupply;
            } else {
                this.hurt(null, 2);
            }
        } else {
            this.airSupply = 300;
        }
        if (this.isInWater()) {
            this.fallDistance = 0.0f;
        }
        if (this.isInLava()) {
            this.hurt(null, 10);
        }
        this.animStepO = this.animStep;
        this.yBodyRotO = this.yBodyRot;
        this.yRotO = this.yRot;
        this.xRotO = this.xRot;
        ++this.tickCount;
        this.aiStep();
        float f2 = this.x - this.xo;
        float f3 = this.z - this.zo;
        float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
        float f5 = this.yBodyRot;
        float f6 = 0.0f;
        this.oRun = this.run;
        float f7 = 0.0f;
        if (!(f4 <= 0.05f)) {
            f7 = 1.0f;
            f6 = f4 * 3.0f;
            f5 = (float)Math.atan2(f3, f2) * 180.0f / (float)Math.PI - 90.0f;
        }
        if (!this.onGround) {
            f7 = 0.0f;
        }
        this.run += (f7 - this.run) * 0.3f;
        for (f2 = f5 - this.yBodyRot; f2 < -180.0f; f2 += 360.0f) {
        }
        while (f2 >= 180.0f) {
            f2 -= 360.0f;
        }
        this.yBodyRot += f2 * 0.1f;
        for (f2 = this.yRot - this.yBodyRot; f2 < -180.0f; f2 += 360.0f) {
        }
        while (f2 >= 180.0f) {
            f2 -= 360.0f;
        }
        boolean bl2 = bl = f2 < -90.0f || f2 >= 90.0f;
        if (f2 < -75.0f) {
            f2 = -75.0f;
        }
        if (f2 >= 75.0f) {
            f2 = 75.0f;
        }
        this.yBodyRot = this.yRot - f2;
        this.yBodyRot += f2 * 0.1f;
        if (bl) {
            f6 = -f6;
        }
        while (this.yRot - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.yRot - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO < -180.0f) {
            this.yBodyRotO -= 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO >= 180.0f) {
            this.yBodyRotO += 360.0f;
        }
        while (this.xRot - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.xRot - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        this.animStep += f6;
    }

    public void aiStep() {
        if (this.ai != null) {
            this.ai.a(this.level, this);
        }
    }

    protected void bindTexture$4211e026(com.mojang.minecraft.a.a a2) {
        GL11.glBindTexture((int)3553, (int)a2.a(this.textureName));
    }

    public void render$2a8c5a(com.mojang.minecraft.a.a a2, float f2) {
        float f3;
        if (this.model == null) {
            return;
        }
        float f4 = (float)this.attackTime - f2;
        if (f3 < 0.0f) {
            f4 = 0.0f;
        }
        while (this.yBodyRotO - this.yBodyRot < -180.0f) {
            this.yBodyRotO += 360.0f;
        }
        while (this.yBodyRotO - this.yBodyRot >= 180.0f) {
            this.yBodyRotO -= 360.0f;
        }
        float f5 = this.yBodyRotO + (this.yBodyRot - this.yBodyRotO) * f2;
        while (this.xRotO - this.xRot < -180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.xRotO - this.xRot >= 180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.yRotO - this.yRot < -180.0f) {
            this.yRotO += 360.0f;
        }
        while (this.yRotO - this.yRot >= 180.0f) {
            this.yRotO -= 360.0f;
        }
        float f6 = this.oRun + (this.run - this.oRun) * f2;
        GL11.glEnable((int)3553);
        float f7 = this.yRotO + (this.yRot - this.yRotO) * f2;
        float f8 = this.xRotO + (this.xRot - this.xRotO) * f2;
        f7 -= f5;
        GL11.glPushMatrix();
        float f9 = this.animStepO + (this.animStep - this.animStepO) * f2;
        float f10 = this.getBrightness(f2);
        GL11.glColor3f((float)f10, (float)f10, (float)f10);
        f10 = 0.0625f;
        float f11 = (float)(-Math.abs(Math.cos((double)f9 * 0.6662)) * 5.0 * (double)f6 - 23.0);
        GL11.glTranslatef((float)(this.xo + (this.x - this.xo) * f2), (float)(this.yo + (this.y - this.yo) * f2 - 1.62f), (float)(this.zo + (this.z - this.zo) * f2));
        float f12 = (float)this.hurtTime - f2;
        if (f12 > 0.0f || this.health <= 0) {
            float f13;
            if (f12 < 0.0f) {
                f12 = 0.0f;
            } else {
                f12 /= (float)this.hurtDuration;
                f12 = (float)Math.sin((double)(f12 * f12 * f12 * f12) * Math.PI) * 14.0f;
            }
            if (this.health <= 0) {
                float f14;
                f13 = ((float)this.deathTime + f2) / 20.0f;
                f12 += f13 * f13 * 800.0f;
                if (f14 > 90.0f) {
                    f12 = 90.0f;
                }
            }
            f13 = this.hurtDir;
            GL11.glRotatef((float)(180.0f - f5 + this.rotOffs), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)(-f13), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-f12), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)f13, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-(180.0f - f5 + this.rotOffs)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)(f11 * f10), (float)0.0f);
        GL11.glRotatef((float)(180.0f - f5 + this.rotOffs), (float)0.0f, (float)1.0f, (float)0.0f);
        if (!this.allowAlpha) {
            GL11.glDisable((int)3008);
        } else {
            GL11.glDisable((int)2884);
        }
        GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
        this.model.a = f4 / 5.0f;
        GL11.glEnable((int)3553);
        this.bindTexture$4211e026(a2);
        this.renderModel$f1c6c5a(a2, f9, f2, f6, f7, f8, f10);
        if (this.invulnerableTime > this.invulnerableDuration - 10) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            this.bindTexture$4211e026(a2);
            this.renderModel$f1c6c5a(a2, f9, f2, f6, f7, f8, f10);
            GL11.glDisable((int)3042);
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3008);
        if (this.allowAlpha) {
            GL11.glEnable((int)2884);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3553);
        GL11.glPopMatrix();
    }

    public void renderModel$f1c6c5a(com.mojang.minecraft.a.a a2, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.model.a(f2, f4, (float)this.tickCount + f3, f5, f6, f7);
    }

    public void heal(int n2) {
        if (this.health <= 0) {
            return;
        }
        this.health += n2;
        if (this.health > 20) {
            this.health = 20;
        }
        this.invulnerableTime = this.invulnerableDuration / 2;
    }

    public void hurt(Entity entity, int n2) {
        if (this.health <= 0) {
            return;
        }
        if ((float)this.invulnerableTime > (float)this.invulnerableDuration / 2.0f) {
            if (this.lastHealth - n2 >= this.health) {
                return;
            }
            this.health = this.lastHealth - n2;
        } else {
            this.lastHealth = this.health;
            this.invulnerableTime = this.invulnerableDuration;
            this.health -= n2;
            this.hurtDuration = 10;
            this.hurtTime = 10;
        }
        this.hurtDir = 0.0f;
        if (entity != null) {
            float f2 = entity.x - this.x;
            float f3 = entity.z - this.z;
            this.hurtDir = (float)(Math.atan2(f3, f2) * 180.0 / Math.PI) - this.yRot;
            this.knockback(entity, n2, f2, f3);
        } else {
            this.hurtDir = (int)(Math.random() * 2.0) * 180;
        }
        if (this.health <= 0) {
            this.die(entity);
        }
    }

    public void knockback(Entity entity, int n2, float f2, float f3) {
        float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
        float f5 = 0.4f;
        this.xd /= 2.0f;
        this.yd /= 2.0f;
        this.zd /= 2.0f;
        this.xd -= f2 / f4 * f5;
        this.yd += 0.4f;
        this.zd -= f3 / f4 * f5;
        if (this.yd > 0.4f) {
            this.yd = 0.4f;
        }
    }

    public void die(Entity entity) {
        this.dead = true;
    }

    protected void causeFallDamage(float f2) {
        int n2 = (int)Math.ceil(f2 - 3.0f);
        if (n2 > 0) {
            this.hurt(null, n2);
        }
    }

    public void travel(float f2, float f3) {
        if (this.isInWater()) {
            float f4 = this.y;
            this.moveRelative(f2, f3, 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.8f;
            this.yd *= 0.8f;
            this.zd *= 0.8f;
            this.yd = (float)((double)this.yd - 0.02);
            if (this.horizontalCollision && this.isFree(this.xd, this.yd + 0.6f - this.y + f4, this.zd)) {
                this.yd = 0.3f;
            }
            return;
        }
        if (this.isInLava()) {
            float f5 = this.y;
            this.moveRelative(f2, f3, 0.02f);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.5f;
            this.yd *= 0.5f;
            this.zd *= 0.5f;
            this.yd = (float)((double)this.yd - 0.02);
            if (this.horizontalCollision && this.isFree(this.xd, this.yd + 0.6f - this.y + f5, this.zd)) {
                this.yd = 0.3f;
            }
            return;
        }
        this.moveRelative(f2, f3, this.onGround ? 0.1f : 0.02f);
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.91f;
        this.yd *= 0.98f;
        this.zd *= 0.91f;
        this.yd = (float)((double)this.yd - 0.08);
        if (this.onGround) {
            float f6 = 0.6f;
            this.xd *= f6;
            this.zd *= f6;
        }
    }

    public boolean isShootable() {
        return true;
    }
}

