/*
 * Decompiled with CFR 0.152.
 */
public class ByteArray3D {
    private final byte[] array;
    public final int width;
    public final int length;
    public final int height;
    public final int volume;

    public ByteArray3D(int n2, int n3, int n4) {
        this(null, n2, n3, n4);
    }

    public ByteArray3D(byte[] byArray, int n2, int n3, int n4) {
        if (byArray == null) {
            byArray = new byte[n2 * n3 * n4];
        } else if (byArray.length < n2 * n3 * n4) {
            throw new IllegalArgumentException("Array is too small!");
        }
        this.array = byArray;
        this.width = n2;
        this.length = n3;
        this.height = n4;
        this.volume = n2 * n3 * n4;
    }

    public int get(int n2, int n3, int n4) {
        return this.array[(n3 * this.width + n2) * this.length + n4] & 0xFF;
    }

    public void set(int n2, int n3, int n4, int n5) {
        this.array[(n3 * this.width + n2) * this.length + n4] = (byte)n5;
    }

    public byte[] getArray() {
        return this.array;
    }
}

