/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

public class XORInputStream
extends InputStream {
    private final InputStream in;
    private final byte[] key;
    private int kIdx;

    public XORInputStream(InputStream inputStream, byte[] byArray) {
        this.in = inputStream;
        this.key = byArray;
    }

    @Override
    public int read() throws IOException {
        byte by2 = this.key[this.kIdx];
        int n2 = this.in.read();
        if (n2 < 0) {
            return -1;
        }
        this.kIdx = (this.kIdx + 1) % this.key.length;
        return (n2 ^ by2) & 0xFF;
    }

    @Override
    public long skip(long l2) throws IOException {
        this.kIdx = (int)(((long)this.kIdx + l2) % (long)this.key.length);
        return super.skip(l2);
    }
}

