/*
 * Decompiled with CFR 0.152.
 */
public class MCHashTable2 {
    private transient MCHashEntry2[] slots = new MCHashEntry2[16];
    private transient int count;
    private int threshold = 12;
    private final float growFactor = 0.75f;

    private static int computeHash(long l2) {
        return MCHashTable2.computeHash((int)(l2 ^ l2 >>> 32));
    }

    private static int computeHash(int n2) {
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        return n2 ^ n2 >>> 7 ^ n2 >>> 4;
    }

    private static int getSlotIndex(int n2, int n3) {
        return n2 & n3 - 1;
    }

    public Object lookup(long l2) {
        int n2 = MCHashTable2.computeHash(l2);
        MCHashEntry2 mCHashEntry2 = this.slots[MCHashTable2.getSlotIndex(n2, this.slots.length)];
        while (mCHashEntry2 != null) {
            if (mCHashEntry2.hashEntry == l2) {
                return mCHashEntry2.valueEntry;
            }
            mCHashEntry2 = mCHashEntry2.nextEntry;
        }
        return null;
    }

    public void addKey(long l2, Object object) {
        int n2 = MCHashTable2.computeHash(l2);
        int n3 = MCHashTable2.getSlotIndex(n2, this.slots.length);
        MCHashEntry2 mCHashEntry2 = this.slots[n3];
        while (mCHashEntry2 != null) {
            if (mCHashEntry2.hashEntry == l2) {
                mCHashEntry2.valueEntry = object;
            }
            mCHashEntry2 = mCHashEntry2.nextEntry;
        }
        this.insert(n2, l2, object, n3);
    }

    private void grow(int n2) {
        MCHashEntry2[] mCHashEntry2Array = this.slots;
        int n3 = mCHashEntry2Array.length;
        if (n3 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
        } else {
            MCHashEntry2[] mCHashEntry2Array2 = new MCHashEntry2[n2];
            this.copyTo(mCHashEntry2Array2);
            this.slots = mCHashEntry2Array2;
            this.threshold = (int)((float)n2 * this.growFactor);
        }
    }

    private void copyTo(MCHashEntry2[] mCHashEntry2Array) {
        MCHashEntry2[] mCHashEntry2Array2 = this.slots;
        int n2 = mCHashEntry2Array.length;
        for (int i2 = 0; i2 < mCHashEntry2Array2.length; ++i2) {
            MCHashEntry2 mCHashEntry2;
            MCHashEntry2 mCHashEntry22 = mCHashEntry2Array2[i2];
            if (mCHashEntry22 == null) continue;
            mCHashEntry2Array2[i2] = null;
            do {
                mCHashEntry2 = mCHashEntry22.nextEntry;
                int n3 = MCHashTable2.getSlotIndex(mCHashEntry22.slotHash, n2);
                mCHashEntry22.nextEntry = mCHashEntry2Array[n3];
                mCHashEntry2Array[n3] = mCHashEntry22;
                mCHashEntry22 = mCHashEntry2;
            } while (mCHashEntry2 != null);
        }
    }

    public Object removeObject(long l2) {
        MCHashEntry2 mCHashEntry2 = this.removeEntry(l2);
        return mCHashEntry2 == null ? null : mCHashEntry2.valueEntry;
    }

    final MCHashEntry2 removeEntry(long l2) {
        MCHashEntry2 mCHashEntry2;
        int n2 = MCHashTable2.computeHash(l2);
        int n3 = MCHashTable2.getSlotIndex(n2, this.slots.length);
        MCHashEntry2 mCHashEntry22 = mCHashEntry2 = this.slots[n3];
        while (mCHashEntry22 != null) {
            MCHashEntry2 mCHashEntry23 = mCHashEntry22.nextEntry;
            if (mCHashEntry22.hashEntry == l2) {
                --this.count;
                if (mCHashEntry2 == mCHashEntry22) {
                    this.slots[n3] = mCHashEntry23;
                } else {
                    mCHashEntry2.nextEntry = mCHashEntry23;
                }
                return mCHashEntry22;
            }
            mCHashEntry2 = mCHashEntry22;
            mCHashEntry22 = mCHashEntry23;
        }
        return null;
    }

    private void insert(int n2, long l2, Object object, int n3) {
        MCHashEntry2 mCHashEntry2 = this.slots[n3];
        this.slots[n3] = new MCHashEntry2(n2, l2, object, mCHashEntry2);
        if (this.count++ >= this.threshold) {
            this.grow(2 * this.slots.length);
        }
    }

    static int getHash(long l2) {
        return MCHashTable2.computeHash(l2);
    }

    public int getNumHashElements() {
        return this.count;
    }
}

