/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

public class IntCache {
    private static int intCacheSize = 256;
    private static final List<int[]> freeSmallArrays = new ArrayList<int[]>();
    private static final List<int[]> inUseSmallArrays = new ArrayList<int[]>();
    private static final List<int[]> freeLargeArrays = new ArrayList<int[]>();
    private static final List<int[]> inUseLargeArrays = new ArrayList<int[]>();

    public static int[] getIntCache(int n2) {
        int[] nArray;
        if (n2 <= 256) {
            int[] nArray2 = freeSmallArrays.isEmpty() ? new int[256] : freeSmallArrays.remove(freeSmallArrays.size() - 1);
            inUseSmallArrays.add(nArray2);
            return nArray2;
        }
        if (n2 > intCacheSize) {
            intCacheSize = n2;
            freeLargeArrays.clear();
            inUseLargeArrays.clear();
            nArray = new int[intCacheSize];
        } else {
            nArray = freeLargeArrays.isEmpty() ? new int[intCacheSize] : freeLargeArrays.remove(freeLargeArrays.size() - 1);
        }
        inUseLargeArrays.add(nArray);
        return nArray;
    }

    public static void resetIntCache() {
        if (!freeLargeArrays.isEmpty()) {
            freeLargeArrays.remove(freeLargeArrays.size() - 1);
        }
        if (!freeSmallArrays.isEmpty()) {
            freeSmallArrays.remove(freeSmallArrays.size() - 1);
        }
        freeLargeArrays.addAll(inUseLargeArrays);
        freeSmallArrays.addAll(inUseSmallArrays);
        inUseLargeArrays.clear();
        inUseSmallArrays.clear();
    }
}

