/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft;

import com.mojang.minecraft.HitResult;
import com.mojang.minecraft.Player;
import com.mojang.minecraft.Textures;
import com.mojang.minecraft.Timer;
import com.mojang.minecraft.character.Zombie;
import com.mojang.minecraft.level.Chunk;
import com.mojang.minecraft.level.Frustum;
import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.level.LevelRenderer;
import com.mojang.minecraft.level.Tesselator;
import com.mojang.minecraft.level.tile.Tile;
import com.mojang.minecraft.particle.ParticleEngine;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class RubyDung
implements Runnable {
    private static final boolean FULLSCREEN_MODE = false;
    private int width;
    private int height;
    private FloatBuffer fogColor0 = BufferUtils.createFloatBuffer((int)4);
    private FloatBuffer fogColor1 = BufferUtils.createFloatBuffer((int)4);
    private Timer timer = new Timer(20.0f);
    private Level level;
    private LevelRenderer levelRenderer;
    private Player player;
    private int paintTexture = 1;
    private ParticleEngine particleEngine;
    private ArrayList<Zombie> zombies = new ArrayList();
    private IntBuffer viewportBuffer = BufferUtils.createIntBuffer((int)16);
    private IntBuffer selectBuffer = BufferUtils.createIntBuffer((int)2000);
    private HitResult hitResult = null;
    FloatBuffer lb = BufferUtils.createFloatBuffer((int)16);

    public void init() {
        int col0 = 16710650;
        int col1 = 920330;
        float fr = 0.5f;
        float fg = 0.8f;
        float fb = 1.0f;
        this.fogColor0.put(new float[]{(float)(col0 >> 16 & 0xFF) / 255.0f, (float)(col0 >> 8 & 0xFF) / 255.0f, (float)(col0 & 0xFF) / 255.0f, 1.0f});
        this.fogColor0.flip();
        this.fogColor1.put(new float[]{(float)(col1 >> 16 & 0xFF) / 255.0f, (float)(col1 >> 8 & 0xFF) / 255.0f, (float)(col1 & 0xFF) / 255.0f, 1.0f});
        this.fogColor1.flip();
        Display.setDisplayMode((DisplayMode)new DisplayMode(1024, 768));
        Display.create();
        Keyboard.create();
        Mouse.create();
        this.width = Display.getDisplayMode().getWidth();
        this.height = Display.getDisplayMode().getHeight();
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearColor((float)fr, (float)fg, (float)fb, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.5f);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        this.level = new Level(512, 512, 256);
        this.levelRenderer = new LevelRenderer(this.level);
        this.player = new Player(this.level);
        this.particleEngine = new ParticleEngine(this.level);
        Mouse.setGrabbed((boolean)true);
        int i = 0;
        while (i < 10) {
            Zombie zombie = new Zombie(this.level, 128.0f, 0.0f, 128.0f);
            zombie.resetPos();
            this.zombies.add(zombie);
            ++i;
        }
    }

    public void destroy() {
        this.level.save();
        Mouse.destroy();
        Keyboard.destroy();
        Display.destroy();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            this.init();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Failed to start RubyDung", 0);
            System.exit(0);
        }
        long lastTime = System.currentTimeMillis();
        int frames = 0;
        try {
            try {
                block12: {
                    block11: {
                        if (!true) break block11;
                        if (Keyboard.isKeyDown((int)1)) return;
                        if (Display.isCloseRequested()) break block12;
                    }
                    do {
                        this.timer.advanceTime();
                        int i = 0;
                        while (i < this.timer.ticks) {
                            this.tick();
                            ++i;
                        }
                        this.render(this.timer.a);
                        ++frames;
                        while (System.currentTimeMillis() >= lastTime + 1000L) {
                            System.out.println(String.valueOf(frames) + " fps, " + Chunk.updates);
                            Chunk.updates = 0;
                            lastTime += 1000L;
                            frames = 0;
                        }
                        if (Keyboard.isKeyDown((int)1)) return;
                    } while (!Display.isCloseRequested());
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.destroy();
                return;
            }
        }
        finally {
            this.destroy();
        }
    }

    public void tick() {
        while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            if (Keyboard.getEventKey() == 28) {
                this.level.save();
            }
            if (Keyboard.getEventKey() == 2) {
                this.paintTexture = 1;
            }
            if (Keyboard.getEventKey() == 3) {
                this.paintTexture = 3;
            }
            if (Keyboard.getEventKey() == 4) {
                this.paintTexture = 4;
            }
            if (Keyboard.getEventKey() == 5) {
                this.paintTexture = 5;
            }
            if (Keyboard.getEventKey() == 7) {
                this.paintTexture = 6;
            }
            if (Keyboard.getEventKey() != 34) continue;
            this.zombies.add(new Zombie(this.level, this.player.x, this.player.y, this.player.z));
        }
        this.level.tick();
        this.particleEngine.tick();
        int i = 0;
        while (i < this.zombies.size()) {
            this.zombies.get(i).tick();
            if (this.zombies.get((int)i).removed) {
                this.zombies.remove(i--);
            }
            ++i;
        }
        this.player.tick();
    }

    private void moveCameraToPlayer(float a) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.3f);
        GL11.glRotatef((float)this.player.xRot, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)this.player.yRot, (float)0.0f, (float)1.0f, (float)0.0f);
        float x = this.player.xo + (this.player.x - this.player.xo) * a;
        float y = this.player.yo + (this.player.y - this.player.yo) * a;
        float z = this.player.zo + (this.player.z - this.player.zo) * a;
        GL11.glTranslatef((float)(-x), (float)(-y), (float)(-z));
    }

    private void setupCamera(float a) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)70.0f, (float)((float)this.width / (float)this.height), (float)0.05f, (float)1000.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.moveCameraToPlayer(a);
    }

    private void setupPickCamera(float a, int x, int y) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        this.viewportBuffer.clear();
        GL11.glGetInteger((int)2978, (IntBuffer)this.viewportBuffer);
        this.viewportBuffer.flip();
        this.viewportBuffer.limit(16);
        GLU.gluPickMatrix((float)x, (float)y, (float)5.0f, (float)5.0f, (IntBuffer)this.viewportBuffer);
        GLU.gluPerspective((float)70.0f, (float)((float)this.width / (float)this.height), (float)0.05f, (float)1000.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.moveCameraToPlayer(a);
    }

    private void pick(float a) {
        this.selectBuffer.clear();
        GL11.glSelectBuffer((IntBuffer)this.selectBuffer);
        GL11.glRenderMode((int)7170);
        this.setupPickCamera(a, this.width / 2, this.height / 2);
        this.levelRenderer.pick(this.player, Frustum.getFrustum());
        int hits = GL11.glRenderMode((int)7168);
        this.selectBuffer.flip();
        this.selectBuffer.limit(this.selectBuffer.capacity());
        long closest = 0L;
        int[] names = new int[10];
        int hitNameCount = 0;
        int i = 0;
        while (i < hits) {
            int j;
            int nameCount = this.selectBuffer.get();
            long minZ = this.selectBuffer.get();
            this.selectBuffer.get();
            long dist = minZ;
            if (dist < closest || i == 0) {
                closest = dist;
                hitNameCount = nameCount;
                j = 0;
                while (j < nameCount) {
                    names[j] = this.selectBuffer.get();
                    ++j;
                }
            } else {
                j = 0;
                while (j < nameCount) {
                    this.selectBuffer.get();
                    ++j;
                }
            }
            ++i;
        }
        this.hitResult = hitNameCount > 0 ? new HitResult(names[0], names[1], names[2], names[3], names[4]) : null;
    }

    public void render(float a) {
        float xo = Mouse.getDX();
        float yo = Mouse.getDY();
        this.player.turn(xo, yo);
        this.pick(a);
        while (Mouse.next()) {
            if (Mouse.getEventButton() == 1 && Mouse.getEventButtonState() && this.hitResult != null) {
                Tile oldTile = Tile.tiles[this.level.getTile(this.hitResult.x, this.hitResult.y, this.hitResult.z)];
                boolean changed = this.level.setTile(this.hitResult.x, this.hitResult.y, this.hitResult.z, 0);
                if (oldTile != null && changed) {
                    oldTile.destroy(this.level, this.hitResult.x, this.hitResult.y, this.hitResult.z, this.particleEngine);
                }
            }
            if (Mouse.getEventButton() != 0 || !Mouse.getEventButtonState() || this.hitResult == null) continue;
            int x = this.hitResult.x;
            int y = this.hitResult.y;
            int z = this.hitResult.z;
            if (this.hitResult.f == 0) {
                --y;
            }
            if (this.hitResult.f == 1) {
                ++y;
            }
            if (this.hitResult.f == 2) {
                --z;
            }
            if (this.hitResult.f == 3) {
                ++z;
            }
            if (this.hitResult.f == 4) {
                --x;
            }
            if (this.hitResult.f == 5) {
                ++x;
            }
            this.level.setTile(x, y, z, this.paintTexture);
        }
        GL11.glClear((int)16640);
        this.setupCamera(a);
        GL11.glEnable((int)2884);
        Frustum frustum = Frustum.getFrustum();
        this.levelRenderer.updateDirtyChunks(this.player);
        this.setupFog(0);
        GL11.glEnable((int)2912);
        this.levelRenderer.render(this.player, 0);
        int i = 0;
        while (i < this.zombies.size()) {
            Zombie zombie = this.zombies.get(i);
            if (zombie.isLit() && frustum.isVisible(zombie.bb)) {
                this.zombies.get(i).render(a);
            }
            ++i;
        }
        this.particleEngine.render(this.player, a, 0);
        this.setupFog(1);
        this.levelRenderer.render(this.player, 1);
        i = 0;
        while (i < this.zombies.size()) {
            Zombie zombie = this.zombies.get(i);
            if (!zombie.isLit() && frustum.isVisible(zombie.bb)) {
                this.zombies.get(i).render(a);
            }
            ++i;
        }
        this.particleEngine.render(this.player, a, 1);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2912);
        if (this.hitResult != null) {
            GL11.glDisable((int)3008);
            this.levelRenderer.renderHit(this.hitResult);
            GL11.glEnable((int)3008);
        }
        this.drawGui(a);
        Display.update();
    }

    private void drawGui(float a) {
        int screenWidth = this.width * 240 / this.height;
        int screenHeight = this.height * 240 / this.height;
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)screenWidth, (double)screenHeight, (double)0.0, (double)100.0, (double)300.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(screenWidth - 16), (float)16.0f, (float)0.0f);
        Tesselator t = Tesselator.instance;
        GL11.glScalef((float)16.0f, (float)16.0f, (float)16.0f);
        GL11.glRotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-1.5f, (float)0.5f, (float)-0.5f);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        int id = Textures.loadTexture("/terrain.png", 9728);
        GL11.glBindTexture((int)3553, (int)id);
        GL11.glEnable((int)3553);
        t.init();
        Tile.tiles[this.paintTexture].render(t, this.level, 0, -2, 0, 0);
        t.flush();
        GL11.glDisable((int)3553);
        GL11.glPopMatrix();
        int wc = screenWidth / 2;
        int hc = screenHeight / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        t.init();
        t.vertex(wc + 1, hc - 4, 0.0f);
        t.vertex(wc - 0, hc - 4, 0.0f);
        t.vertex(wc - 0, hc + 5, 0.0f);
        t.vertex(wc + 1, hc + 5, 0.0f);
        t.vertex(wc + 5, hc - 0, 0.0f);
        t.vertex(wc - 4, hc - 0, 0.0f);
        t.vertex(wc - 4, hc + 1, 0.0f);
        t.vertex(wc + 5, hc + 1, 0.0f);
        t.flush();
    }

    private void setupFog(int i) {
        if (i == 0) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)0.001f);
            GL11.glFog((int)2918, (FloatBuffer)this.fogColor0);
            GL11.glDisable((int)2896);
        } else if (i == 1) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)0.06f);
            GL11.glFog((int)2918, (FloatBuffer)this.fogColor1);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2903);
            float br = 0.6f;
            GL11.glLightModel((int)2899, (FloatBuffer)this.getBuffer(br, br, br, 1.0f));
        }
    }

    private FloatBuffer getBuffer(float a, float b, float c, float d) {
        this.lb.clear();
        this.lb.put(a).put(b).put(c).put(d);
        this.lb.flip();
        return this.lb;
    }

    public static void checkError() {
        int e = GL11.glGetError();
        if (e != 0) {
            throw new IllegalStateException(GLU.gluErrorString((int)e));
        }
    }

    public static void main(String[] args) throws LWJGLException {
        new Thread(new RubyDung()).start();
    }
}

