/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.Entity;
import com.mojang.minecraft.a.a;
import com.mojang.minecraft.a.e;
import com.mojang.minecraft.d.b;
import com.mojang.minecraft.level.BlockMap$Slot;
import com.mojang.minecraft.phys.AABB;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BlockMap
implements Serializable {
    public static final long serialVersionUID = 0L;
    private int width;
    private int depth;
    private int height;
    private BlockMap$Slot slot = new BlockMap$Slot(this, null);
    private BlockMap$Slot slot2 = new BlockMap$Slot(this, null);
    public List[] entityGrid;
    public List all = new ArrayList();
    private List tmp = new ArrayList();

    public BlockMap(int n2, int n3, int n4) {
        this.width = n2 / 16;
        this.depth = n3 / 16;
        this.height = n4 / 16;
        if (this.width == 0) {
            this.width = 1;
        }
        if (this.depth == 0) {
            this.depth = 1;
        }
        if (this.height == 0) {
            this.height = 1;
        }
        this.entityGrid = new ArrayList[this.width * this.depth * this.height];
        for (n2 = 0; n2 < this.width; ++n2) {
            for (n3 = 0; n3 < this.depth; ++n3) {
                for (n4 = 0; n4 < this.height; ++n4) {
                    this.entityGrid[(n4 * this.depth + n3) * this.width + n2] = new ArrayList();
                }
            }
        }
    }

    public void insert(Entity entity) {
        this.all.add(entity);
        this.slot.init(entity.x, entity.y, entity.z).add(entity);
        entity.xOld = entity.x;
        entity.yOld = entity.y;
        entity.zOld = entity.z;
        entity.blockMap = this;
    }

    public void remove(Entity entity) {
        this.slot.init(entity.xOld, entity.yOld, entity.zOld).remove(entity);
        this.all.remove(entity);
    }

    public void moved(Entity entity) {
        BlockMap$Slot blockMap$Slot = ((BlockMap)this).slot.init(entity.xOld, entity.yOld, entity.zOld);
        if (blockMap$Slot.equals(this = ((BlockMap)this).slot2.init(entity.x, entity.y, entity.z))) {
            return;
        }
        blockMap$Slot.remove(entity);
        ((BlockMap$Slot)this).add(entity);
        entity.xOld = entity.x;
        entity.yOld = entity.y;
        entity.zOld = entity.z;
    }

    public List getEntities(Entity entity, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.tmp.clear();
        return this.getEntities(entity, f2, f3, f4, f5, f6, f7, this.tmp);
    }

    public List getEntities(Entity entity, float f2, float f3, float f4, float f5, float f6, float f7, List list) {
        BlockMap$Slot blockMap$Slot = this.slot.init(f2, f3, f4);
        BlockMap$Slot blockMap$Slot2 = this.slot2.init(f5, f6, f7);
        for (int i2 = BlockMap$Slot.access$400(blockMap$Slot) - 1; i2 <= BlockMap$Slot.access$400(blockMap$Slot2) + 1; ++i2) {
            for (int i3 = BlockMap$Slot.access$500(blockMap$Slot) - 1; i3 <= BlockMap$Slot.access$500(blockMap$Slot2) + 1; ++i3) {
                for (int i4 = BlockMap$Slot.access$600(blockMap$Slot) - 1; i4 <= BlockMap$Slot.access$600(blockMap$Slot2) + 1; ++i4) {
                    if (i2 < 0 || i3 < 0 || i4 < 0 || i2 >= this.width || i3 >= this.depth || i4 >= this.height) continue;
                    List list2 = this.entityGrid[(i4 * this.depth + i3) * this.width + i2];
                    for (int i5 = 0; i5 < list2.size(); ++i5) {
                        Entity entity2 = (Entity)list2.get(i5);
                        if (entity2 == entity || !entity2.intersects(f2, f3, f4, f5, f6, f7)) continue;
                        list.add(entity2);
                    }
                }
            }
        }
        return list;
    }

    public void clear() {
        for (int i2 = 0; i2 < this.width; ++i2) {
            for (int i3 = 0; i3 < this.depth; ++i3) {
                for (int i4 = 0; i4 < this.height; ++i4) {
                    this.entityGrid[(i4 * this.depth + i3) * this.width + i2].clear();
                }
            }
        }
    }

    public List getEntities(Entity entity, AABB aABB) {
        this.tmp.clear();
        return this.getEntities(entity, aABB.x0, aABB.y0, aABB.z0, aABB.x1, aABB.y1, aABB.z1, this.tmp);
    }

    public List getEntities(Entity entity, AABB aABB, List list) {
        return this.getEntities(entity, aABB.x0, aABB.y0, aABB.z0, aABB.x1, aABB.y1, aABB.z1, list);
    }

    public void tickAll() {
        for (int i2 = 0; i2 < this.all.size(); ++i2) {
            Entity entity = (Entity)this.all.get(i2);
            entity.tick();
            if (entity.removed) {
                this.all.remove(i2--);
                this.slot.init(entity.xOld, entity.yOld, entity.zOld).remove(entity);
                continue;
            }
            int n2 = (int)(entity.xOld / 16.0f);
            int n3 = (int)(entity.yOld / 16.0f);
            int n4 = (int)(entity.zOld / 16.0f);
            int n5 = (int)(entity.x / 16.0f);
            int n6 = (int)(entity.y / 16.0f);
            int n7 = (int)(entity.z / 16.0f);
            if (n2 == n5 && n3 == n6 && n4 == n7) continue;
            this.moved(entity);
        }
    }

    public void render$55df6f7(b b2, e e2, a a2, float f2) {
        for (int i2 = 0; i2 < this.width; ++i2) {
            float f3 = (i2 << 4) - 2;
            float f4 = (i2 + 1 << 4) + 2;
            for (int i3 = 0; i3 < this.depth; ++i3) {
                float f5 = (i3 << 4) - 2;
                float f6 = (i3 + 1 << 4) + 2;
                for (int i4 = 0; i4 < this.height; ++i4) {
                    float f7;
                    float f8;
                    boolean bl;
                    List list = this.entityGrid[(i4 * this.depth + i3) * this.width + i2];
                    if (list.size() == 0 || !(bl = e2.b(f3, f5, f8 = (float)((i4 << 4) - 2), f4, f6, f7 = (float)((i4 + 1 << 4) + 2)))) continue;
                    boolean bl2 = e2.a(f3, f5, f8, f4, f6, f7);
                    for (int i5 = 0; i5 < list.size(); ++i5) {
                        Entity entity = (Entity)list.get(i5);
                        if (!entity.shouldRender(b2) || !bl2 && !e2.a(entity.bb)) continue;
                        entity.render$2a8c5a(a2, f2);
                    }
                }
            }
        }
    }

    static /* synthetic */ int access$000(BlockMap blockMap) {
        return blockMap.width;
    }

    static /* synthetic */ int access$100(BlockMap blockMap) {
        return blockMap.depth;
    }

    static /* synthetic */ int access$200(BlockMap blockMap) {
        return blockMap.height;
    }
}

