/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.phys;

public class AABB {
    private float epsilon = 0.0f;
    public float x0;
    public float y0;
    public float z0;
    public float x1;
    public float y1;
    public float z1;

    public AABB(float a1, float a2, float a3, float a4, float a5, float a6) {
        this.x0 = a1;
        this.y0 = a2;
        this.z0 = a3;
        this.x1 = a4;
        this.y1 = a5;
        this.z1 = a6;
    }

    public AABB expand(float a1, float a2, float a3) {
        float v1 = this.x0;
        float v2 = this.y0;
        float v3 = this.z0;
        float v4 = this.x1;
        float v5 = this.y1;
        float v6 = this.z1;
        if (a1 < 0.0f) {
            v1 += a1;
        }
        if (a1 > 0.0f) {
            v4 += a1;
        }
        if (a2 < 0.0f) {
            v2 += a2;
        }
        if (a2 > 0.0f) {
            v5 += a2;
        }
        if (a3 < 0.0f) {
            v3 += a3;
        }
        if (a3 > 0.0f) {
            v6 += a3;
        }
        return new AABB(v1, v2, v3, v4, v5, v6);
    }

    public AABB grow(float a1, float a2, float a3) {
        float v1 = this.x0 - a1;
        float v2 = this.y0 - a2;
        float v3 = this.z0 - a3;
        float v4 = this.x1 + a1;
        float v5 = this.y1 + a2;
        float v6 = this.z1 + a3;
        return new AABB(v1, v2, v3, v4, v5, v6);
    }

    public float clipXCollide(AABB a1, float a2) {
        float v1;
        if (a1.y1 <= this.y0 || a1.y0 >= this.y1) {
            return a2;
        }
        if (a1.z1 <= this.z0 || a1.z0 >= this.z1) {
            return a2;
        }
        if (a2 > 0.0f && a1.x1 <= this.x0 && (v1 = this.x0 - a1.x1 - this.epsilon) < a2) {
            a2 = v1;
        }
        if (a2 < 0.0f && a1.x0 >= this.x1 && (v1 = this.x1 - a1.x0 + this.epsilon) > a2) {
            a2 = v1;
        }
        return a2;
    }

    public float clipYCollide(AABB a1, float a2) {
        float v1;
        if (a1.x1 <= this.x0 || a1.x0 >= this.x1) {
            return a2;
        }
        if (a1.z1 <= this.z0 || a1.z0 >= this.z1) {
            return a2;
        }
        if (a2 > 0.0f && a1.y1 <= this.y0 && (v1 = this.y0 - a1.y1 - this.epsilon) < a2) {
            a2 = v1;
        }
        if (a2 < 0.0f && a1.y0 >= this.y1 && (v1 = this.y1 - a1.y0 + this.epsilon) > a2) {
            a2 = v1;
        }
        return a2;
    }

    public float clipZCollide(AABB a1, float a2) {
        float v1;
        if (a1.x1 <= this.x0 || a1.x0 >= this.x1) {
            return a2;
        }
        if (a1.y1 <= this.y0 || a1.y0 >= this.y1) {
            return a2;
        }
        if (a2 > 0.0f && a1.z1 <= this.z0 && (v1 = this.z0 - a1.z1 - this.epsilon) < a2) {
            a2 = v1;
        }
        if (a2 < 0.0f && a1.z0 >= this.z1 && (v1 = this.z1 - a1.z0 + this.epsilon) > a2) {
            a2 = v1;
        }
        return a2;
    }

    public boolean intersects(AABB a1) {
        return a1.x1 > this.x0 && a1.x0 < this.x1 && a1.y1 > this.y0 && a1.y0 < this.y1 && a1.z1 > this.z0 && a1.z0 < this.z1;
    }

    public void move(float a1, float a2, float a3) {
        this.x0 += a1;
        this.y0 += a2;
        this.z0 += a3;
        this.x1 += a1;
        this.y1 += a2;
        this.z1 += a3;
    }
}

