/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.particle;

import com.mojang.minecraft.Entity;
import com.mojang.minecraft.RubyDung;
import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.level.Tesselator;

public class Particle
extends Entity {
    private float xd;
    private float yd;
    private float zd;
    public int tex;
    private float uo;
    private float vo;
    private int age = 0;
    private int lifetime = 0;
    private float size;

    public Particle(RubyDung g, Level a1, float a2, float a3, float a4, float a5, float a6, float a7, int a8) {
        super(g, a1);
        this.tex = a8;
        this.setSize(0.2f, 0.2f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(a2, a3, a4);
        this.xd = a5 + (float)(Math.random() * 2.0 - 1.0) * 0.4f;
        this.yd = a6 + (float)(Math.random() * 2.0 - 1.0) * 0.4f;
        this.zd = a7 + (float)(Math.random() * 2.0 - 1.0) * 0.4f;
        float v1 = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
        float v2 = (float)Math.sqrt(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
        this.xd = this.xd / v2 * v1 * 0.4f;
        this.yd = this.yd / v2 * v1 * 0.4f + 0.1f;
        this.zd = this.zd / v2 * v1 * 0.4f;
        this.uo = (float)Math.random() * 3.0f;
        this.vo = (float)Math.random() * 3.0f;
        this.size = (float)(Math.random() * 0.5 + 0.5);
        this.lifetime = (int)(4.0 / (Math.random() * 0.9 + 0.1));
        this.age = 0;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.yd = (float)((double)this.yd - 0.04);
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98f;
        this.yd *= 0.98f;
        this.zd *= 0.98f;
        if (this.onGround) {
            this.xd *= 0.7f;
            this.zd *= 0.7f;
        }
    }

    public void render(Tesselator a1, float a2, float a3, float a4, float a5, float a6, float a7) {
        float v1 = ((float)(this.tex % 16) + this.uo / 4.0f) / 16.0f;
        float v2 = v1 + 0.015609375f;
        float v3 = ((float)(this.tex / 16) + this.vo / 4.0f) / 16.0f;
        float v4 = v3 + 0.015609375f;
        float v5 = 0.1f * this.size;
        float v6 = this.xo + (this.x - this.xo) * a2;
        float v7 = this.yo + (this.y - this.yo) * a2;
        float v8 = this.zo + (this.z - this.zo) * a2;
        a1.vertexUV(v6 - a3 * v5 - a6 * v5, v7 - a4 * v5, v8 - a5 * v5 - a7 * v5, v1, v4);
        a1.vertexUV(v6 - a3 * v5 + a6 * v5, v7 + a4 * v5, v8 - a5 * v5 + a7 * v5, v1, v3);
        a1.vertexUV(v6 + a3 * v5 + a6 * v5, v7 + a4 * v5, v8 + a5 * v5 + a7 * v5, v2, v3);
        a1.vertexUV(v6 + a3 * v5 - a6 * v5, v7 - a4 * v5, v8 + a5 * v5 - a7 * v5, v2, v4);
    }
}

