/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft;

import com.mojang.minecraft.HitResult;
import com.mojang.minecraft.Player;
import com.mojang.minecraft.Textures;
import com.mojang.minecraft.Timer;
import com.mojang.minecraft.character.Zombie;
import com.mojang.minecraft.gui.Font;
import com.mojang.minecraft.gui.Gui;
import com.mojang.minecraft.gui.GuiDisclaimer;
import com.mojang.minecraft.gui.GuiIngame;
import com.mojang.minecraft.gui.GuiTitle;
import com.mojang.minecraft.gui.PauseMenu;
import com.mojang.minecraft.level.Chunk;
import com.mojang.minecraft.level.Frustum;
import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.level.LevelRenderer;
import com.mojang.minecraft.level.Tesselator;
import com.mojang.minecraft.level.tile.Tile;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class RubyDung
implements Runnable {
    private static final boolean FULLSCREEN_MODE = false;
    public int width;
    public int height;
    private FloatBuffer fogColor0 = BufferUtils.createFloatBuffer((int)4);
    private FloatBuffer fogColor1 = BufferUtils.createFloatBuffer((int)4);
    private Timer timer = new Timer(20.0f);
    public Level level;
    public LevelRenderer levelRenderer;
    public Player player;
    private int paintTexture = 1;
    private ArrayList<Zombie> zombies;
    private IntBuffer viewportBuffer;
    private IntBuffer selectBuffer;
    private HitResult hitResult = null;
    FloatBuffer lb;
    public Gui gui = null;
    public Textures textures = new Textures();
    public int tickCount = 0;
    boolean disclaimerDeath = false;
    public Font font;
    public int fpsCount;
    public Textures foliage = new Textures();

    public RubyDung() {
        this.zombies = new ArrayList();
        this.viewportBuffer = BufferUtils.createIntBuffer((int)16);
        this.selectBuffer = BufferUtils.createIntBuffer((int)2000);
        this.lb = BufferUtils.createFloatBuffer((int)16);
    }

    public void init() throws LWJGLException, IOException {
        int integer1 = 16710650;
        int integer2 = 920330;
        float float3 = 0.5f;
        float float4 = 0.8f;
        float float5 = 1.0f;
        this.fogColor0.put(new float[]{0.05490196f, 0.043137256f, 0.039215688f, 1.0f});
        this.fogColor0.flip();
        this.fogColor1.put(new float[]{0.05490196f, 0.043137256f, 0.039215688f, 1.0f});
        this.fogColor1.flip();
        Display.setDisplayMode((DisplayMode)new DisplayMode(1024, 768));
        Display.setTitle((String)"RubyRevived");
        Display.create();
        Keyboard.create();
        Mouse.create();
        this.width = Display.getDisplayMode().getWidth();
        this.height = Display.getDisplayMode().getHeight();
        GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)50.0, (double)150.0);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.5f);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        this.font = new Font("/default.gif", this.textures);
        this.level = new Level(256, 256, 64);
        this.levelRenderer = new LevelRenderer(this, this.level);
        this.player = new Player(this, this.level);
        int integer3 = 0;
        while (integer3 < 10) {
            Zombie zombie7 = new Zombie(this, this.level, 128.0f, 0.0f, 128.0f);
            zombie7.resetPos();
            this.zombies.add(zombie7);
            ++integer3;
        }
        try {
            this.setCurrentScreen(new GuiDisclaimer());
        }
        catch (Exception exception6) {
            exception6.printStackTrace();
            this.setCurrentScreen(new GuiTitle());
        }
    }

    public void resetLevel() {
        RubyDung rubyDung1 = this;
        rubyDung1.level = null;
        rubyDung1.level = new Level(256, 256, 64, 1);
        rubyDung1.levelRenderer = null;
        rubyDung1.player = null;
        rubyDung1.levelRenderer = new LevelRenderer(rubyDung1, rubyDung1.level);
        rubyDung1.player = new Player(rubyDung1, rubyDung1.level);
    }

    public final void grabMouse() {
        Mouse.setGrabbed((boolean)true);
    }

    public final void releaseMouse() {
        Mouse.setGrabbed((boolean)false);
    }

    public final void setCurrentScreen(Gui gui) {
        if (this.gui != null) {
            this.gui.onGuiClosed();
        }
        if ((this.gui = gui) != null) {
            this.releaseMouse();
            gui.setResolution(this, this.width * 240 / this.height, this.height * 240 / this.height);
        } else {
            this.grabMouse();
        }
    }

    public void destroy() {
        Mouse.destroy();
        Keyboard.destroy();
        Display.destroy();
    }

    @Override
    public void run() {
        try {
            this.init();
        }
        catch (Exception exception1) {
            JOptionPane.showMessageDialog(null, exception1.toString(), "Failed to start RubyDung", 0);
            System.exit(0);
            exception1.printStackTrace();
        }
        long long1 = System.currentTimeMillis();
        int integer3 = 0;
        try {
            try {
                while (!Keyboard.isKeyDown((int)6)) {
                    if (Display.isCloseRequested()) {
                        break;
                    }
                    this.timer.advanceTime();
                    int integer4 = 0;
                    while (integer4 < this.timer.ticks) {
                        this.tick();
                        ++integer4;
                    }
                    this.render(this.timer.a);
                    ++integer3;
                    while (System.currentTimeMillis() >= long1 + 1000L) {
                        this.fpsCount = integer3;
                        Chunk.updates = 0;
                        long1 += 1000L;
                        integer3 = 0;
                    }
                }
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                this.destroy();
                return;
            }
        }
        finally {
            this.destroy();
        }
        this.destroy();
        this.destroy();
    }

    public void tick() {
        ++this.tickCount;
        if (this.tickCount > 100 && this.tickCount <= 101) {
            this.disclaimerDeath = true;
        }
        if (this.disclaimerDeath) {
            this.disclaimerDeath = false;
            this.setCurrentScreen(new GuiTitle());
        }
        while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            if (Keyboard.getEventKey() == 1) {
                this.releaseMouse();
                this.setCurrentScreen(new PauseMenu());
            }
            if (Keyboard.getEventKey() == 28) {
                this.level.save();
            }
            if (Keyboard.getEventKey() == 2) {
                this.paintTexture = 1;
            }
            if (Keyboard.getEventKey() == 3) {
                this.paintTexture = 2;
            }
            if (Keyboard.getEventKey() == 4) {
                this.paintTexture = 17;
            }
            if (Keyboard.getEventKey() == 5) {
                this.paintTexture = 18;
            }
            if (Keyboard.getEventKey() == 7) {
                this.paintTexture = 19;
            }
            if (Keyboard.getEventKey() == 34) continue;
        }
        if (this.gui != null) {
            this.gui.updateEvents();
            if (this.gui != null) {
                try {
                    this.gui.updateScreen();
                }
                catch (Exception exception1) {
                    exception1.printStackTrace();
                }
            }
        }
        if (this.gui == null && this.level != null) {
            this.setCurrentScreen(new GuiIngame());
            this.grabMouse();
        }
        if (this.level != null) {
            this.level.tick();
            int integer1 = 0;
            while (integer1 < this.zombies.size()) {
                this.zombies.get(integer1).tick();
                if (this.zombies.get((int)integer1).removed) {
                    this.zombies.remove(integer1--);
                }
                ++integer1;
            }
        }
        this.player.tick();
    }

    private void moveCameraToPlayer(float float1) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.3f);
        GL11.glRotatef((float)this.player.xRot, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)this.player.yRot, (float)0.0f, (float)1.0f, (float)0.0f);
        float float2 = this.player.xo + (this.player.x - this.player.xo) * float1;
        float float3 = this.player.yo + (this.player.y - this.player.yo) * float1;
        float float4 = this.player.zo + (this.player.z - this.player.zo) * float1;
        GL11.glTranslatef((float)(-float2), (float)(-float3), (float)(-float4));
    }

    private void setupCamera(float float1) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)70.0f, (float)((float)this.width / (float)this.height), (float)0.05f, (float)1000.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.moveCameraToPlayer(float1);
    }

    private void setupPickCamera(float float1, int integer2, int integer3) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        this.viewportBuffer.clear();
        GL11.glGetInteger((int)2978, (IntBuffer)this.viewportBuffer);
        this.viewportBuffer.flip();
        this.viewportBuffer.limit(16);
        GLU.gluPickMatrix((float)integer2, (float)integer3, (float)5.0f, (float)5.0f, (IntBuffer)this.viewportBuffer);
        GLU.gluPerspective((float)70.0f, (float)(this.width / this.height), (float)0.05f, (float)1000.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.moveCameraToPlayer(float1);
    }

    private void pick(float float1) {
        this.selectBuffer.clear();
        GL11.glSelectBuffer((IntBuffer)this.selectBuffer);
        GL11.glRenderMode((int)7170);
        this.setupPickCamera(float1, this.width / 2, this.height / 2);
        this.levelRenderer.pick(this.player, Frustum.getFrustum());
        int integer2 = GL11.glRenderMode((int)7168);
        this.selectBuffer.flip();
        this.selectBuffer.limit(this.selectBuffer.capacity());
        long long3 = 0L;
        int[] arr5 = new int[10];
        int integer3 = 0;
        int integer4 = 0;
        while (integer4 < integer2) {
            int integer6;
            int integer5 = this.selectBuffer.get();
            long long4 = this.selectBuffer.get();
            this.selectBuffer.get();
            long long5 = long4;
            if (long5 < long3 || integer4 == 0) {
                long3 = long5;
                integer3 = integer5;
                integer6 = 0;
                while (integer6 < integer5) {
                    arr5[integer6] = this.selectBuffer.get();
                    ++integer6;
                }
            } else {
                integer6 = 0;
                while (integer6 < integer5) {
                    this.selectBuffer.get();
                    ++integer6;
                }
            }
            ++integer4;
        }
        this.hitResult = integer3 > 0 ? new HitResult(arr5[0], arr5[1], arr5[2], arr5[3], arr5[4]) : null;
    }

    public void render(float float1) {
        int integer5;
        float float2 = Mouse.getDX();
        float float3 = Mouse.getDY();
        if (!(this.gui instanceof PauseMenu)) {
            this.player.turn(float2, float3);
        }
        this.pick(float1);
        if (this.gui instanceof GuiIngame) {
            while (Mouse.next()) {
                if (Mouse.getEventButton() == 1 && Mouse.getEventButtonState() && this.hitResult != null) {
                    Tile tile4 = Tile.tiles[this.level.getTile(this.hitResult.x, this.hitResult.y, this.hitResult.z)];
                    boolean bl = this.level.setTile(this.hitResult.x, this.hitResult.y, this.hitResult.z, 0);
                }
                if (Mouse.getEventButton() != 0 || !Mouse.getEventButtonState() || this.hitResult == null) continue;
                int integer4 = this.hitResult.x;
                integer5 = this.hitResult.y;
                int integer6 = this.hitResult.z;
                if (this.hitResult.f == 0) {
                    --integer5;
                }
                if (this.hitResult.f == 1) {
                    ++integer5;
                }
                if (this.hitResult.f == 2) {
                    --integer6;
                }
                if (this.hitResult.f == 3) {
                    ++integer6;
                }
                if (this.hitResult.f == 4) {
                    --integer4;
                }
                if (this.hitResult.f == 5) {
                    ++integer4;
                }
                this.level.setTile(integer4, integer5, integer6, this.paintTexture);
            }
        }
        GL11.glClear((int)16640);
        this.setupCamera(float1);
        GL11.glEnable((int)2884);
        Frustum frustum4 = Frustum.getFrustum();
        this.levelRenderer.updateDirtyChunks(this.player);
        this.setupFog(0);
        GL11.glEnable((int)2912);
        this.levelRenderer.render(this.player, 0);
        integer5 = 0;
        while (integer5 < this.zombies.size()) {
            Zombie zombie6 = this.zombies.get(integer5);
            if (zombie6.isLit() && frustum4.isVisible(zombie6.bb)) {
                this.zombies.get(integer5).render(float1);
            }
            ++integer5;
        }
        this.setupFog(1);
        this.levelRenderer.render(this.player, 1);
        integer5 = 0;
        while (integer5 < this.zombies.size()) {
            Zombie zombie6 = this.zombies.get(integer5);
            if (!zombie6.isLit() && frustum4.isVisible(zombie6.bb)) {
                this.zombies.get(integer5).render(float1);
            }
            ++integer5;
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2912);
        if (this.hitResult != null) {
            GL11.glDisable((int)3008);
            this.levelRenderer.renderHit(this.hitResult);
            GL11.glEnable((int)3008);
        }
        this.drawGui(float1);
        Display.update();
    }

    private void drawGui(float float1) {
        int integer2 = this.width * 240 / this.height;
        int integer3 = this.height * 240 / this.height;
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)integer2, (double)integer3, (double)0.0, (double)100.0, (double)300.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(integer2 - 16), (float)16.0f, (float)0.0f);
        Tesselator tesselator4 = Tesselator.instance;
        GL11.glScalef((float)16.0f, (float)16.0f, (float)16.0f);
        GL11.glRotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-1.5f, (float)0.5f, (float)-0.5f);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        int integer4 = this.textures.loadTexture("/terrain.png", 9728);
        GL11.glBindTexture((int)3553, (int)integer4);
        GL11.glEnable((int)3553);
        tesselator4.init();
        if (this.gui instanceof GuiIngame) {
            Tile.tiles[this.paintTexture].render(tesselator4, this.level, 0, -2, 0, 0);
        }
        tesselator4.flush();
        GL11.glDisable((int)3553);
        GL11.glPopMatrix();
        int integer5 = integer2 / 2;
        int integer6 = integer3 / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tesselator4.init();
        tesselator4.vertex(integer5 + 1, integer6 - 4, 0.0f);
        tesselator4.vertex(integer5 - 0, integer6 - 4, 0.0f);
        tesselator4.vertex(integer5 - 0, integer6 + 5, 0.0f);
        tesselator4.vertex(integer5 + 1, integer6 + 5, 0.0f);
        tesselator4.vertex(integer5 + 5, integer6 - 0, 0.0f);
        tesselator4.vertex(integer5 - 4, integer6 - 0, 0.0f);
        tesselator4.vertex(integer5 - 4, integer6 + 1, 0.0f);
        tesselator4.vertex(integer5 + 5, integer6 + 1, 0.0f);
        tesselator4.flush();
        int integer7 = this.width * 240 / this.height;
        int integer8 = this.height * 240 / this.height;
        int integer9 = Mouse.getX() * integer7 / this.width;
        int integer10 = integer8 - Mouse.getY() * integer8 / this.height - 1;
        if (this.gui != null) {
            this.gui.drawScreen(integer9, integer10);
        }
    }

    private void setupFog(int integer) {
        GL11.glFogi((int)2917, (int)2048);
        GL11.glFogf((int)2914, (float)0.009f);
        GL11.glFog((int)2918, (FloatBuffer)this.fogColor1);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2903);
        float float2 = 0.8f;
        GL11.glLightModel((int)2899, (FloatBuffer)this.getBuffer(0.8f, 0.8f, 0.8f, 1.0f));
    }

    private FloatBuffer getBuffer(float float1, float float2, float float3, float float4) {
        this.lb.clear();
        this.lb.put(float1).put(float2).put(float3).put(float4);
        this.lb.flip();
        return this.lb;
    }

    public static void checkError() {
        int integer1 = GL11.glGetError();
        if (integer1 != 0) {
            throw new IllegalStateException(GLU.gluErrorString((int)integer1));
        }
    }

    public static void main(String[] arr) throws LWJGLException {
        new Thread(new RubyDung()).start();
    }
}

