/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft;

import com.mojang.minecraft.RubyDung;
import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.phys.AABB;
import java.util.ArrayList;

public class Entity {
    protected Level level;
    public float xo;
    public float yo;
    public float zo;
    public float x;
    public float y;
    public float z;
    public float xd;
    public float yd;
    public float zd;
    public float yRot;
    public float xRot;
    public AABB bb;
    public boolean onGround;
    public boolean removed;
    protected float heightOffset;
    protected float bbWidth;
    protected float bbHeight;
    protected RubyDung game;

    public Entity(RubyDung g, Level a1) {
        this.game = g;
        this.onGround = false;
        this.removed = false;
        this.heightOffset = 0.0f;
        this.bbWidth = 0.6f;
        this.bbHeight = 1.8f;
        this.level = a1;
        this.resetPos();
    }

    protected void resetPos() {
        float v1 = (float)Math.random() * (float)this.level.width;
        float v2 = this.level.depth + 10;
        float v3 = (float)Math.random() * (float)this.level.height;
        this.setPos(v1, v2, v3);
    }

    public void remove() {
        this.removed = true;
    }

    protected void setSize(float a1, float a2) {
        this.bbWidth = a1;
        this.bbHeight = a2;
    }

    protected void setPos(float a1, float a2, float a3) {
        this.x = a1;
        this.y = a2;
        this.z = a3;
        float v1 = this.bbWidth / 2.0f;
        float v2 = this.bbHeight / 2.0f;
        this.bb = new AABB(a1 - v1, a2 - v2, a3 - v1, a1 + v1, a2 + v2, a3 + v1);
    }

    public void turn(float a1, float a2) {
        this.yRot += (float)((double)a1 * 0.15);
        this.xRot -= (float)((double)a2 * 0.15);
        if (this.xRot < -90.0f) {
            this.xRot = -90.0f;
        }
        if (this.xRot > 90.0f) {
            this.xRot = 90.0f;
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
    }

    public void move(float a1, float a2, float a3) {
        float v1 = a1;
        float v2 = a2;
        float v3 = a3;
        ArrayList<AABB> v4 = this.level.getCubes(this.bb.expand(a1, a2, a3));
        int v5 = 0;
        while (v5 < v4.size()) {
            a2 = ((AABB)v4.get(v5)).clipYCollide(this.bb, a2);
            ++v5;
        }
        this.bb.move(0.0f, a2, 0.0f);
        v5 = 0;
        while (v5 < v4.size()) {
            a1 = ((AABB)v4.get(v5)).clipXCollide(this.bb, a1);
            ++v5;
        }
        this.bb.move(a1, 0.0f, 0.0f);
        v5 = 0;
        while (v5 < v4.size()) {
            a3 = ((AABB)v4.get(v5)).clipZCollide(this.bb, a3);
            ++v5;
        }
        this.bb.move(0.0f, 0.0f, a3);
        boolean bl = this.onGround = v2 != a2 && v2 < 0.0f;
        if (v1 != a1) {
            this.xd = 0.0f;
        }
        if (v2 != a2) {
            this.yd = 0.0f;
        }
        if (v3 != a3) {
            this.zd = 0.0f;
        }
        this.x = (this.bb.x0 + this.bb.x1) / 2.0f;
        this.y = this.bb.y0 + this.heightOffset;
        this.z = (this.bb.z0 + this.bb.z1) / 2.0f;
    }

    public void moveRelative(float a1, float a2, float a3) {
        float v1 = a1 * a1 + a2 * a2;
        if (v1 < 0.01f) {
            return;
        }
        v1 = a3 / (float)Math.sqrt(v1);
        float v2 = (float)Math.sin((double)this.yRot * Math.PI / 180.0);
        float v3 = (float)Math.cos((double)this.yRot * Math.PI / 180.0);
        this.xd += (a1 *= v1) * v3 - (a2 *= v1) * v2;
        this.zd += a2 * v3 + a1 * v2;
    }

    public boolean isLit() {
        int v1 = (int)this.x;
        int v2 = (int)this.y;
        int v3 = (int)this.z;
        return this.level.isLit(v1, v2, v3);
    }
}

