/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.level.Tesselator;
import com.mojang.minecraft.level.tile.Bush;
import com.mojang.minecraft.level.tile.DirtTile;
import com.mojang.minecraft.level.tile.GrassTile;
import com.mojang.minecraft.particle.Particle;
import com.mojang.minecraft.particle.ParticleEngine;
import com.mojang.minecraft.phys.AABB;
import java.util.Random;

public class Tile {
    public static final Tile[] tiles = new Tile[256];
    public static final Tile empty = null;
    public static final Tile rock = new Tile(1, 1);
    public static final Tile grass = new GrassTile(2);
    public static final Tile dirt = new DirtTile(3, 2);
    public static final Tile stoneBrick = new Tile(4, 16);
    public static final Tile wood = new Tile(5, 4);
    public static final Tile bush = new Bush(6);
    public int tex;
    public final int id;

    protected Tile(int integer) {
        Tile.tiles[integer] = this;
        this.id = integer;
    }

    protected Tile(int integer1, int integer2) {
        this(integer1);
        this.tex = integer2;
    }

    public void render(Tesselator tesselator, Level level, int integer3, int integer4, int integer5, int integer6) {
        float float7 = 1.0f;
        float float8 = 0.8f;
        float float9 = 0.6f;
        if (this.shouldRenderFace(level, integer4, integer5 - 1, integer6, integer3)) {
            tesselator.color(1.0f, 1.0f, 1.0f);
            this.renderFace(tesselator, integer4, integer5, integer6, 0);
        }
        if (this.shouldRenderFace(level, integer4, integer5 + 1, integer6, integer3)) {
            tesselator.color(1.0f, 1.0f, 1.0f);
            this.renderFace(tesselator, integer4, integer5, integer6, 1);
        }
        if (this.shouldRenderFace(level, integer4, integer5, integer6 - 1, integer3)) {
            tesselator.color(0.8f, 0.8f, 0.8f);
            this.renderFace(tesselator, integer4, integer5, integer6, 2);
        }
        if (this.shouldRenderFace(level, integer4, integer5, integer6 + 1, integer3)) {
            tesselator.color(0.8f, 0.8f, 0.8f);
            this.renderFace(tesselator, integer4, integer5, integer6, 3);
        }
        if (this.shouldRenderFace(level, integer4 - 1, integer5, integer6, integer3)) {
            tesselator.color(0.6f, 0.6f, 0.6f);
            this.renderFace(tesselator, integer4, integer5, integer6, 4);
        }
        if (this.shouldRenderFace(level, integer4 + 1, integer5, integer6, integer3)) {
            tesselator.color(0.6f, 0.6f, 0.6f);
            this.renderFace(tesselator, integer4, integer5, integer6, 5);
        }
    }

    private boolean shouldRenderFace(Level level, int integer2, int integer3, int integer4, int integer5) {
        return !level.isSolidTile(integer2, integer3, integer4) && level.isLit(integer2, integer3, integer4) ^ integer5 == 1;
    }

    protected int getTexture(int integer) {
        return this.tex;
    }

    public void renderFace(Tesselator tesselator, int integer2, int integer3, int integer4, int integer5) {
        int integer6 = this.getTexture(integer5);
        float float7 = (float)(integer6 % 16) / 16.0f;
        float float8 = float7 + 0.0624375f;
        float float9 = (float)(integer6 / 16) / 16.0f;
        float float10 = float9 + 0.0624375f;
        float float11 = (float)integer2 + 0.0f;
        float float12 = (float)integer2 + 1.0f;
        float float13 = (float)integer3 + 0.0f;
        float float14 = (float)integer3 + 1.0f;
        float float15 = (float)integer4 + 0.0f;
        float float16 = (float)integer4 + 1.0f;
        if (integer5 == 0) {
            tesselator.vertexUV(float11, float13, float16, float7, float10);
            tesselator.vertexUV(float11, float13, float15, float7, float9);
            tesselator.vertexUV(float12, float13, float15, float8, float9);
            tesselator.vertexUV(float12, float13, float16, float8, float10);
        }
        if (integer5 == 1) {
            tesselator.vertexUV(float12, float14, float16, float8, float10);
            tesselator.vertexUV(float12, float14, float15, float8, float9);
            tesselator.vertexUV(float11, float14, float15, float7, float9);
            tesselator.vertexUV(float11, float14, float16, float7, float10);
        }
        if (integer5 == 2) {
            tesselator.vertexUV(float11, float14, float15, float8, float9);
            tesselator.vertexUV(float12, float14, float15, float7, float9);
            tesselator.vertexUV(float12, float13, float15, float7, float10);
            tesselator.vertexUV(float11, float13, float15, float8, float10);
        }
        if (integer5 == 3) {
            tesselator.vertexUV(float11, float14, float16, float7, float9);
            tesselator.vertexUV(float11, float13, float16, float7, float10);
            tesselator.vertexUV(float12, float13, float16, float8, float10);
            tesselator.vertexUV(float12, float14, float16, float8, float9);
        }
        if (integer5 == 4) {
            tesselator.vertexUV(float11, float14, float16, float8, float9);
            tesselator.vertexUV(float11, float14, float15, float7, float9);
            tesselator.vertexUV(float11, float13, float15, float7, float10);
            tesselator.vertexUV(float11, float13, float16, float8, float10);
        }
        if (integer5 == 5) {
            tesselator.vertexUV(float12, float13, float16, float7, float10);
            tesselator.vertexUV(float12, float13, float15, float8, float10);
            tesselator.vertexUV(float12, float14, float15, float8, float9);
            tesselator.vertexUV(float12, float14, float16, float7, float9);
        }
    }

    public void renderFaceNoTexture(Tesselator tesselator, int integer2, int integer3, int integer4, int integer5) {
        float float6 = (float)integer2 + 0.0f;
        float float7 = (float)integer2 + 1.0f;
        float float8 = (float)integer3 + 0.0f;
        float float9 = (float)integer3 + 1.0f;
        float float10 = (float)integer4 + 0.0f;
        float float11 = (float)integer4 + 1.0f;
        if (integer5 == 0) {
            tesselator.vertex(float6, float8, float11);
            tesselator.vertex(float6, float8, float10);
            tesselator.vertex(float7, float8, float10);
            tesselator.vertex(float7, float8, float11);
        }
        if (integer5 == 1) {
            tesselator.vertex(float7, float9, float11);
            tesselator.vertex(float7, float9, float10);
            tesselator.vertex(float6, float9, float10);
            tesselator.vertex(float6, float9, float11);
        }
        if (integer5 == 2) {
            tesselator.vertex(float6, float9, float10);
            tesselator.vertex(float7, float9, float10);
            tesselator.vertex(float7, float8, float10);
            tesselator.vertex(float6, float8, float10);
        }
        if (integer5 == 3) {
            tesselator.vertex(float6, float9, float11);
            tesselator.vertex(float6, float8, float11);
            tesselator.vertex(float7, float8, float11);
            tesselator.vertex(float7, float9, float11);
        }
        if (integer5 == 4) {
            tesselator.vertex(float6, float9, float11);
            tesselator.vertex(float6, float9, float10);
            tesselator.vertex(float6, float8, float10);
            tesselator.vertex(float6, float8, float11);
        }
        if (integer5 == 5) {
            tesselator.vertex(float7, float8, float11);
            tesselator.vertex(float7, float8, float10);
            tesselator.vertex(float7, float9, float10);
            tesselator.vertex(float7, float9, float11);
        }
    }

    public final AABB getTileAABB(int integer1, int integer2, int integer3) {
        return new AABB(integer1, integer2, integer3, integer1 + 1, integer2 + 1, integer3 + 1);
    }

    public AABB getAABB(int integer1, int integer2, int integer3) {
        return new AABB(integer1, integer2, integer3, integer1 + 1, integer2 + 1, integer3 + 1);
    }

    public boolean blocksLight() {
        return true;
    }

    public boolean isSolid() {
        return true;
    }

    public void tick(Level level, int integer2, int integer3, int integer4, Random random) {
    }

    public void destroy(Level level, int integer2, int integer3, int integer4, ParticleEngine particleEngine) {
        int integer5 = 4;
        int integer6 = 0;
        while (integer6 < integer5) {
            int integer7 = 0;
            while (integer7 < integer5) {
                int integer8 = 0;
                while (integer8 < integer5) {
                    float float10 = (float)integer2 + ((float)integer6 + 0.5f) / (float)integer5;
                    float float11 = (float)integer3 + ((float)integer7 + 0.5f) / (float)integer5;
                    float float12 = (float)integer4 + ((float)integer8 + 0.5f) / (float)integer5;
                    particleEngine.add(new Particle(null, level, float10, float11, float12, float10 - (float)integer2 - 0.5f, float11 - (float)integer3 - 0.5f, float12 - (float)integer4 - 0.5f, this.tex));
                    ++integer8;
                }
                ++integer7;
            }
            ++integer6;
        }
    }
}

