/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.level.LevelListener;
import com.mojang.minecraft.level.PerlinNoiseFilter;
import com.mojang.minecraft.level.tile.Tile;
import com.mojang.minecraft.phys.AABB;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Level {
    private static final int TILE_UPDATE_INTERVAL = 400;
    public final int width;
    public final int height;
    public final int depth;
    private byte[] blocks;
    private int[] lightDepths;
    private ArrayList<LevelListener> levelListeners = new ArrayList();
    private Random random = new Random();
    int unprocessed = 0;
    public int seed;

    public Level(int integer1, int integer2, int integer3) {
        this.width = integer1;
        this.height = integer2;
        this.depth = integer3;
        this.blocks = new byte[integer1 * integer2 * integer3];
        this.lightDepths = new int[integer1 * integer2];
        this.calcLightDepths(0, 0, integer1, integer2);
    }

    public Level(int integer1, int integer2, int integer3, int integer4) {
        this.width = integer1;
        this.height = integer2;
        this.depth = integer3;
        this.blocks = new byte[integer1 * integer2 * integer3];
        this.lightDepths = new int[integer1 * integer2];
        if (integer4 == 0) {
            this.generateMap();
        } else if (integer4 == 1) {
            this.load();
        } else if (integer4 == 2) {
            this.generateMap();
            this.save();
            this.load();
        }
        this.calcLightDepths(0, 0, integer1, integer2);
    }

    public void generateMap() {
        int integer1 = this.width;
        int integer2 = this.height;
        int integer3 = this.depth;
        int[] arr4 = new PerlinNoiseFilter(0).read(integer1, integer2);
        int[] arr5 = new PerlinNoiseFilter(0).read(integer1, integer2);
        int[] arr6 = new PerlinNoiseFilter(2).read(integer1, integer2);
        int[] arr7 = new PerlinNoiseFilter(5).read(integer1, integer2);
        int integer4 = 0;
        while (integer4 < integer1) {
            int integer5 = 0;
            while (integer5 < integer3) {
                int integer6 = 0;
                while (integer6 < integer2) {
                    int integer10;
                    int integer7 = arr4[integer4 + integer6 * this.width];
                    int integer8 = arr5[integer4 + integer6 * this.width];
                    int integer9 = arr6[integer4 + integer6 * this.width];
                    if (integer9 < 128) {
                        integer8 = integer7;
                    }
                    if (integer8 > (integer10 = integer7)) {
                        integer10 = integer8;
                    } else {
                        integer8 = integer7;
                    }
                    ++integer10;
                    integer10 = integer10 / 8 / 3;
                    int integer11 = arr7[integer4 + integer6 * this.width] / 8 / 3;
                    integer11 = this.random.nextInt(5) == 0 ? arr7[integer4 + integer6 * this.width] / 8 + integer3 / 3 : arr7[integer4 + integer6 * this.width] / 8 / 3;
                    if (integer11 > integer10 - 2) {
                        integer11 = integer10 - 2;
                    }
                    int integer12 = (integer5 * this.height + integer6) * this.width + integer4;
                    int integer14 = this.random.nextInt(4);
                    int integer13 = 0;
                    if (integer5 == integer10) {
                        integer13 = Tile.grass.id;
                    }
                    if (integer5 < integer10) {
                        integer13 = Tile.rock.id;
                    }
                    this.blocks[integer12] = (byte)integer13;
                    ++integer6;
                }
                ++integer5;
            }
            ++integer4;
        }
    }

    public boolean load() {
        try {
            DataInputStream dataInputStream1 = new DataInputStream(new GZIPInputStream(new FileInputStream(new File("level.dat"))));
            dataInputStream1.readFully(this.blocks);
            this.calcLightDepths(0, 0, this.width, this.height);
            int integer2 = 0;
            while (integer2 < this.levelListeners.size()) {
                this.levelListeners.get(integer2).allChanged();
                ++integer2;
            }
            dataInputStream1.close();
            return true;
        }
        catch (Exception exception1) {
            exception1.printStackTrace();
            return false;
        }
    }

    public void save() {
        try {
            DataOutputStream dataOutputStream1 = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(new File("level.dat"))));
            dataOutputStream1.write(this.blocks);
            dataOutputStream1.close();
        }
        catch (Exception exception1) {
            exception1.printStackTrace();
        }
    }

    public void calcLightDepths(int integer1, int integer2, int integer3, int integer4) {
        int integer5 = integer1;
        while (integer5 < integer1 + integer3) {
            int integer6 = integer2;
            while (integer6 < integer2 + integer4) {
                int integer7 = this.lightDepths[integer5 + integer6 * this.width];
                int integer8 = this.depth - 1;
                while (integer8 > 0 && !this.isLightBlocker(integer5, integer8, integer6)) {
                    --integer8;
                }
                this.lightDepths[integer5 + integer6 * this.width] = integer8;
                if (integer7 != this.lightDepths[integer5 + integer6 * this.width]) {
                    int integer9 = integer7 < integer8 ? integer7 : integer8;
                    int integer10 = integer7 > integer8 ? integer7 : integer8;
                    int integer11 = 0;
                    while (integer11 < this.levelListeners.size()) {
                        this.levelListeners.get(integer11).lightColumnChanged(integer5, integer6, integer9, integer10);
                        ++integer11;
                    }
                }
                ++integer6;
            }
            ++integer5;
        }
    }

    public void addListener(LevelListener levelListener) {
        this.levelListeners.add(levelListener);
    }

    public void removeListener(LevelListener levelListener) {
        this.levelListeners.remove(levelListener);
    }

    public boolean isLightBlocker(int integer1, int integer2, int integer3) {
        Tile tile4 = Tile.tiles[this.getTile(integer1, integer2, integer3)];
        return tile4 != null && tile4.blocksLight();
    }

    public ArrayList<AABB> getCubes(AABB aABB) {
        ArrayList<AABB> arrayList2 = new ArrayList<AABB>();
        int integer3 = (int)aABB.x0;
        int integer4 = (int)(aABB.x1 + 1.0f);
        int integer5 = (int)aABB.y0;
        int integer6 = (int)(aABB.y1 + 1.0f);
        int integer7 = (int)aABB.z0;
        int integer8 = (int)(aABB.z1 + 1.0f);
        if (integer3 < 0) {
            integer3 = 0;
        }
        if (integer5 < 0) {
            integer5 = 0;
        }
        if (integer7 < 0) {
            integer7 = 0;
        }
        if (integer4 > this.width) {
            integer4 = this.width;
        }
        if (integer6 > this.depth) {
            integer6 = this.depth;
        }
        if (integer8 > this.height) {
            integer8 = this.height;
        }
        int integer9 = integer3;
        while (integer9 < integer4) {
            int integer10 = integer5;
            while (integer10 < integer6) {
                int integer11 = integer7;
                while (integer11 < integer8) {
                    AABB aABB2;
                    Tile tile12 = Tile.tiles[this.getTile(integer9, integer10, integer11)];
                    if (tile12 != null && (aABB2 = tile12.getAABB(integer9, integer10, integer11)) != null) {
                        arrayList2.add(aABB2);
                    }
                    ++integer11;
                }
                ++integer10;
            }
            ++integer9;
        }
        return arrayList2;
    }

    public boolean setTile(int integer1, int integer2, int integer3, int integer4) {
        if (integer1 < 0 || integer2 < 0 || integer3 < 0 || integer1 >= this.width || integer2 >= this.depth || integer3 >= this.height) {
            return false;
        }
        if (integer4 == this.blocks[(integer2 * this.height + integer3) * this.width + integer1]) {
            return false;
        }
        this.blocks[(integer2 * this.height + integer3) * this.width + integer1] = (byte)integer4;
        this.calcLightDepths(integer1, integer3, 1, 1);
        int integer5 = 0;
        while (integer5 < this.levelListeners.size()) {
            this.levelListeners.get(integer5).tileChanged(integer1, integer2, integer3);
            ++integer5;
        }
        return true;
    }

    public boolean isLit(int integer1, int integer2, int integer3) {
        return integer1 < 0 || integer2 < 0 || integer3 < 0 || integer1 >= this.width || integer2 >= this.depth || integer3 >= this.height || integer2 >= this.lightDepths[integer1 + integer3 * this.width];
    }

    public int getTile(int integer1, int integer2, int integer3) {
        if (integer1 < 0 || integer2 < 0 || integer3 < 0 || integer1 >= this.width || integer2 >= this.depth || integer3 >= this.height) {
            return 0;
        }
        return this.blocks[(integer2 * this.height + integer3) * this.width + integer1];
    }

    public boolean isSolidTile(int integer1, int integer2, int integer3) {
        Tile tile4 = Tile.tiles[this.getTile(integer1, integer2, integer3)];
        return tile4 != null && tile4.isSolid();
    }

    public void tick() {
        this.unprocessed += this.width * this.height * this.depth;
        int integer1 = this.unprocessed / 400;
        this.unprocessed -= integer1 * 400;
        int integer2 = 0;
        while (integer2 < integer1) {
            int integer5;
            int integer4;
            int integer3 = this.random.nextInt(this.width);
            Tile tile6 = Tile.tiles[this.getTile(integer3, integer4 = this.random.nextInt(this.depth), integer5 = this.random.nextInt(this.height))];
            if (tile6 != null) {
                tile6.tick(this, integer3, integer4, integer5, this.random);
            }
            ++integer2;
        }
    }
}

