/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import java.io.IOException;
import javazoom.jl.decoder.JavaLayerUtils;
import javazoom.jl.decoder.Obuffer;

final class SynthesisFilter {
    private float[] v1;
    private float[] v2;
    private float[] actual_v;
    private int actual_write_pos;
    private float[] samples;
    private int channel;
    private float scalefactor;
    private float[] eq;
    private float[] _tmpOut = new float[32];
    private static final double MY_PI = Math.PI;
    private static final float cos1_64 = (float)(1.0 / (2.0 * Math.cos(0.04908738521234052)));
    private static final float cos3_64 = (float)(1.0 / (2.0 * Math.cos(0.14726215563702155)));
    private static final float cos5_64 = (float)(1.0 / (2.0 * Math.cos(0.2454369260617026)));
    private static final float cos7_64 = (float)(1.0 / (2.0 * Math.cos(0.3436116964863836)));
    private static final float cos9_64 = (float)(1.0 / (2.0 * Math.cos(0.44178646691106466)));
    private static final float cos11_64 = (float)(1.0 / (2.0 * Math.cos(0.5399612373357456)));
    private static final float cos13_64 = (float)(1.0 / (2.0 * Math.cos(0.6381360077604268)));
    private static final float cos15_64 = (float)(1.0 / (2.0 * Math.cos(0.7363107781851077)));
    private static final float cos17_64 = (float)(1.0 / (2.0 * Math.cos(0.8344855486097889)));
    private static final float cos19_64 = (float)(1.0 / (2.0 * Math.cos(0.9326603190344698)));
    private static final float cos21_64 = (float)(1.0 / (2.0 * Math.cos(1.030835089459151)));
    private static final float cos23_64 = (float)(1.0 / (2.0 * Math.cos(1.1290098598838318)));
    private static final float cos25_64 = (float)(1.0 / (2.0 * Math.cos(1.227184630308513)));
    private static final float cos27_64 = (float)(1.0 / (2.0 * Math.cos(1.325359400733194)));
    private static final float cos29_64 = (float)(1.0 / (2.0 * Math.cos(1.423534171157875)));
    private static final float cos31_64 = (float)(1.0 / (2.0 * Math.cos(1.521708941582556)));
    private static final float cos1_32 = (float)(1.0 / (2.0 * Math.cos(0.09817477042468103)));
    private static final float cos3_32 = (float)(1.0 / (2.0 * Math.cos(0.2945243112740431)));
    private static final float cos5_32 = (float)(1.0 / (2.0 * Math.cos(0.4908738521234052)));
    private static final float cos7_32 = (float)(1.0 / (2.0 * Math.cos(0.6872233929727672)));
    private static final float cos9_32 = (float)(1.0 / (2.0 * Math.cos(0.8835729338221293)));
    private static final float cos11_32 = (float)(1.0 / (2.0 * Math.cos(1.0799224746714913)));
    private static final float cos13_32 = (float)(1.0 / (2.0 * Math.cos(1.2762720155208536)));
    private static final float cos15_32 = (float)(1.0 / (2.0 * Math.cos(1.4726215563702154)));
    private static final float cos1_16 = (float)(1.0 / (2.0 * Math.cos(0.19634954084936207)));
    private static final float cos3_16 = (float)(1.0 / (2.0 * Math.cos(0.5890486225480862)));
    private static final float cos5_16 = (float)(1.0 / (2.0 * Math.cos(0.9817477042468103)));
    private static final float cos7_16 = (float)(1.0 / (2.0 * Math.cos(1.3744467859455345)));
    private static final float cos1_8 = (float)(1.0 / (2.0 * Math.cos(0.39269908169872414)));
    private static final float cos3_8 = (float)(1.0 / (2.0 * Math.cos(1.1780972450961724)));
    private static final float cos1_4 = (float)(1.0 / (2.0 * Math.cos(0.7853981633974483)));
    private static float[] d = null;
    private static float[][] d16 = null;

    public SynthesisFilter(int n2, float f2, float[] fArray) {
        if (d == null) {
            d = SynthesisFilter.load_d();
            d16 = SynthesisFilter.splitArray(d, 16);
        }
        this.v1 = new float[512];
        this.v2 = new float[512];
        this.samples = new float[32];
        this.channel = n2;
        this.scalefactor = f2;
        this.setEQ(this.eq);
        this.reset();
    }

    public void setEQ(float[] fArray) {
        this.eq = fArray;
        if (this.eq == null) {
            this.eq = new float[32];
            for (int i2 = 0; i2 < 32; ++i2) {
                this.eq[i2] = 1.0f;
            }
        }
        if (this.eq.length < 32) {
            throw new IllegalArgumentException("eq0");
        }
    }

    public void reset() {
        int n2;
        for (n2 = 0; n2 < 512; ++n2) {
            this.v2[n2] = 0.0f;
            this.v1[n2] = 0.0f;
        }
        for (n2 = 0; n2 < 32; ++n2) {
            this.samples[n2] = 0.0f;
        }
        this.actual_v = this.v1;
        this.actual_write_pos = 15;
    }

    public void input_sample(float f2, int n2) {
        this.samples[n2] = this.eq[n2] * f2;
    }

    public void input_samples(float[] fArray) {
        for (int i2 = 31; i2 >= 0; --i2) {
            this.samples[i2] = fArray[i2] * this.eq[i2];
        }
    }

    private void compute_new_v() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float f17 = 0.0f;
        float f18 = 0.0f;
        float f19 = 0.0f;
        float f20 = 0.0f;
        float f21 = 0.0f;
        float f22 = 0.0f;
        float f23 = 0.0f;
        float f24 = 0.0f;
        float f25 = 0.0f;
        float f26 = 0.0f;
        float f27 = 0.0f;
        float f28 = 0.0f;
        float f29 = 0.0f;
        float f30 = 0.0f;
        float f31 = 0.0f;
        float f32 = 0.0f;
        float f33 = 0.0f;
        float[] fArray = this.samples;
        float f34 = fArray[0];
        float f35 = fArray[1];
        float f36 = fArray[2];
        float f37 = fArray[3];
        float f38 = fArray[4];
        float f39 = fArray[5];
        float f40 = fArray[6];
        float f41 = fArray[7];
        float f42 = fArray[8];
        float f43 = fArray[9];
        float f44 = fArray[10];
        float f45 = fArray[11];
        float f46 = fArray[12];
        float f47 = fArray[13];
        float f48 = fArray[14];
        float f49 = fArray[15];
        float f50 = fArray[16];
        float f51 = fArray[17];
        float f52 = fArray[18];
        float f53 = fArray[19];
        float f54 = fArray[20];
        float f55 = fArray[21];
        float f56 = fArray[22];
        float f57 = fArray[23];
        float f58 = fArray[24];
        float f59 = fArray[25];
        float f60 = fArray[26];
        float f61 = fArray[27];
        float f62 = fArray[28];
        float f63 = fArray[29];
        float f64 = fArray[30];
        float f65 = fArray[31];
        float f66 = f34 + f65;
        float f67 = f35 + f64;
        float f68 = f36 + f63;
        float f69 = f37 + f62;
        float f70 = f38 + f61;
        float f71 = f39 + f60;
        float f72 = f40 + f59;
        float f73 = f41 + f58;
        float f74 = f42 + f57;
        float f75 = f43 + f56;
        float f76 = f44 + f55;
        float f77 = f45 + f54;
        float f78 = f46 + f53;
        float f79 = f47 + f52;
        float f80 = f48 + f51;
        float f81 = f49 + f50;
        float f82 = f66 + f81;
        float f83 = f67 + f80;
        float f84 = f68 + f79;
        float f85 = f69 + f78;
        float f86 = f70 + f77;
        float f87 = f71 + f76;
        float f88 = f72 + f75;
        float f89 = f73 + f74;
        float f90 = (f66 - f81) * cos1_32;
        float f91 = (f67 - f80) * cos3_32;
        float f92 = (f68 - f79) * cos5_32;
        float f93 = (f69 - f78) * cos7_32;
        float f94 = (f70 - f77) * cos9_32;
        float f95 = (f71 - f76) * cos11_32;
        float f96 = (f72 - f75) * cos13_32;
        float f97 = (f73 - f74) * cos15_32;
        f66 = f82 + f89;
        f67 = f83 + f88;
        f68 = f84 + f87;
        f69 = f85 + f86;
        f70 = (f82 - f89) * cos1_16;
        f71 = (f83 - f88) * cos3_16;
        f72 = (f84 - f87) * cos5_16;
        f73 = (f85 - f86) * cos7_16;
        f74 = f90 + f97;
        f75 = f91 + f96;
        f76 = f92 + f95;
        f77 = f93 + f94;
        f78 = (f90 - f97) * cos1_16;
        f79 = (f91 - f96) * cos3_16;
        f80 = (f92 - f95) * cos5_16;
        f81 = (f93 - f94) * cos7_16;
        f82 = f66 + f69;
        f83 = f67 + f68;
        f84 = (f66 - f69) * cos1_8;
        f85 = (f67 - f68) * cos3_8;
        f86 = f70 + f73;
        f87 = f71 + f72;
        f88 = (f70 - f73) * cos1_8;
        f89 = (f71 - f72) * cos3_8;
        f90 = f74 + f77;
        f91 = f75 + f76;
        f92 = (f74 - f77) * cos1_8;
        f93 = (f75 - f76) * cos3_8;
        f94 = f78 + f81;
        f95 = f79 + f80;
        f96 = (f78 - f81) * cos1_8;
        f97 = (f79 - f80) * cos3_8;
        f66 = f82 + f83;
        f67 = (f82 - f83) * cos1_4;
        f68 = f84 + f85;
        f69 = (f84 - f85) * cos1_4;
        f70 = f86 + f87;
        f71 = (f86 - f87) * cos1_4;
        f72 = f88 + f89;
        f73 = (f88 - f89) * cos1_4;
        f74 = f90 + f91;
        f75 = (f90 - f91) * cos1_4;
        f76 = f92 + f93;
        f77 = (f92 - f93) * cos1_4;
        f78 = f94 + f95;
        f79 = (f94 - f95) * cos1_4;
        f80 = f96 + f97;
        f81 = (f96 - f97) * cos1_4;
        f21 = f73;
        f29 = f21 + f71;
        f14 = -f29 - f72;
        f6 = -f72 - f73 - f70;
        f19 = f81;
        f23 = f19 + f77;
        f27 = f23 + f79;
        f31 = f81 + f79 + f75;
        f16 = -f31 - f80;
        float f98 = -f80 - f81 - f76 - f77;
        f12 = f98 - f79;
        f4 = -f80 - f81 - f78 - f74;
        f8 = f98 - f78;
        f2 = -f66;
        f33 = f67;
        f25 = f69;
        f10 = -f25 - f68;
        f66 = (f34 - f65) * cos1_64;
        f67 = (f35 - f64) * cos3_64;
        f68 = (f36 - f63) * cos5_64;
        f69 = (f37 - f62) * cos7_64;
        f70 = (f38 - f61) * cos9_64;
        f71 = (f39 - f60) * cos11_64;
        f72 = (f40 - f59) * cos13_64;
        f73 = (f41 - f58) * cos15_64;
        f74 = (f42 - f57) * cos17_64;
        f75 = (f43 - f56) * cos19_64;
        f76 = (f44 - f55) * cos21_64;
        f77 = (f45 - f54) * cos23_64;
        f78 = (f46 - f53) * cos25_64;
        f79 = (f47 - f52) * cos27_64;
        f80 = (f48 - f51) * cos29_64;
        f81 = (f49 - f50) * cos31_64;
        f82 = f66 + f81;
        f83 = f67 + f80;
        f84 = f68 + f79;
        f85 = f69 + f78;
        f86 = f70 + f77;
        f87 = f71 + f76;
        f88 = f72 + f75;
        f89 = f73 + f74;
        f90 = (f66 - f81) * cos1_32;
        f91 = (f67 - f80) * cos3_32;
        f92 = (f68 - f79) * cos5_32;
        f93 = (f69 - f78) * cos7_32;
        f94 = (f70 - f77) * cos9_32;
        f95 = (f71 - f76) * cos11_32;
        f96 = (f72 - f75) * cos13_32;
        f97 = (f73 - f74) * cos15_32;
        f66 = f82 + f89;
        f67 = f83 + f88;
        f68 = f84 + f87;
        f69 = f85 + f86;
        f70 = (f82 - f89) * cos1_16;
        f71 = (f83 - f88) * cos3_16;
        f72 = (f84 - f87) * cos5_16;
        f73 = (f85 - f86) * cos7_16;
        f74 = f90 + f97;
        f75 = f91 + f96;
        f76 = f92 + f95;
        f77 = f93 + f94;
        f78 = (f90 - f97) * cos1_16;
        f79 = (f91 - f96) * cos3_16;
        f80 = (f92 - f95) * cos5_16;
        f81 = (f93 - f94) * cos7_16;
        f82 = f66 + f69;
        f83 = f67 + f68;
        f84 = (f66 - f69) * cos1_8;
        f85 = (f67 - f68) * cos3_8;
        f86 = f70 + f73;
        f87 = f71 + f72;
        f88 = (f70 - f73) * cos1_8;
        f89 = (f71 - f72) * cos3_8;
        f90 = f74 + f77;
        f91 = f75 + f76;
        f92 = (f74 - f77) * cos1_8;
        f93 = (f75 - f76) * cos3_8;
        f94 = f78 + f81;
        f95 = f79 + f80;
        f96 = (f78 - f81) * cos1_8;
        f97 = (f79 - f80) * cos3_8;
        f66 = f82 + f83;
        f67 = (f82 - f83) * cos1_4;
        f68 = f84 + f85;
        f69 = (f84 - f85) * cos1_4;
        f70 = f86 + f87;
        f71 = (f86 - f87) * cos1_4;
        f72 = f88 + f89;
        f73 = (f88 - f89) * cos1_4;
        f74 = f90 + f91;
        f75 = (f90 - f91) * cos1_4;
        f76 = f92 + f93;
        f77 = (f92 - f93) * cos1_4;
        f78 = f94 + f95;
        f79 = (f94 - f95) * cos1_4;
        f80 = f96 + f97;
        f18 = f81 = (f96 - f97) * cos1_4;
        f20 = f18 + f73;
        f22 = f20 + f77;
        f28 = f22 + f71 + f79;
        f24 = f81 + f77 + f69;
        f26 = f24 + f79;
        f98 = f79 + f81 + f75;
        f32 = f98 + f67;
        f17 = -f32 - f80;
        f30 = f98 + f71 + f73;
        f15 = -f30 - f72 - f80;
        f98 = -f76 - f77 - f80 - f81;
        f11 = f98 - f79 - f68 - f69;
        f13 = f98 - f79 - f71 - f72 - f73;
        f9 = f98 - f78 - f68 - f69;
        float f99 = f70 + f72 + f73;
        f7 = f98 - f78 - f99;
        f98 = -f74 - f78 - f80 - f81;
        f3 = f98 - f66;
        f5 = f98 - f99;
        float[] fArray2 = this.actual_v;
        int n2 = this.actual_write_pos;
        fArray2[0 + n2] = f33;
        fArray2[16 + n2] = f32;
        fArray2[32 + n2] = f31;
        fArray2[48 + n2] = f30;
        fArray2[64 + n2] = f29;
        fArray2[80 + n2] = f28;
        fArray2[96 + n2] = f27;
        fArray2[112 + n2] = f26;
        fArray2[128 + n2] = f25;
        fArray2[144 + n2] = f24;
        fArray2[160 + n2] = f23;
        fArray2[176 + n2] = f22;
        fArray2[192 + n2] = f21;
        fArray2[208 + n2] = f20;
        fArray2[224 + n2] = f19;
        fArray2[240 + n2] = f18;
        fArray2[256 + n2] = 0.0f;
        fArray2[272 + n2] = -f18;
        fArray2[288 + n2] = -f19;
        fArray2[304 + n2] = -f20;
        fArray2[320 + n2] = -f21;
        fArray2[336 + n2] = -f22;
        fArray2[352 + n2] = -f23;
        fArray2[368 + n2] = -f24;
        fArray2[384 + n2] = -f25;
        fArray2[400 + n2] = -f26;
        fArray2[416 + n2] = -f27;
        fArray2[432 + n2] = -f28;
        fArray2[448 + n2] = -f29;
        fArray2[464 + n2] = -f30;
        fArray2[480 + n2] = -f31;
        fArray2[496 + n2] = -f32;
        fArray2 = this.actual_v == this.v1 ? this.v2 : this.v1;
        fArray2[0 + n2] = -f33;
        fArray2[16 + n2] = f17;
        fArray2[32 + n2] = f16;
        fArray2[48 + n2] = f15;
        fArray2[64 + n2] = f14;
        fArray2[80 + n2] = f13;
        fArray2[96 + n2] = f12;
        fArray2[112 + n2] = f11;
        fArray2[128 + n2] = f10;
        fArray2[144 + n2] = f9;
        fArray2[160 + n2] = f8;
        fArray2[176 + n2] = f7;
        fArray2[192 + n2] = f6;
        fArray2[208 + n2] = f5;
        fArray2[224 + n2] = f4;
        fArray2[240 + n2] = f3;
        fArray2[256 + n2] = f2;
        fArray2[272 + n2] = f3;
        fArray2[288 + n2] = f4;
        fArray2[304 + n2] = f5;
        fArray2[320 + n2] = f6;
        fArray2[336 + n2] = f7;
        fArray2[352 + n2] = f8;
        fArray2[368 + n2] = f9;
        fArray2[384 + n2] = f10;
        fArray2[400 + n2] = f11;
        fArray2[416 + n2] = f12;
        fArray2[432 + n2] = f13;
        fArray2[448 + n2] = f14;
        fArray2[464 + n2] = f15;
        fArray2[480 + n2] = f16;
        fArray2[496 + n2] = f17;
    }

    private void compute_new_v_old() {
        float[] fArray = new float[32];
        float[] fArray2 = new float[16];
        float[] fArray3 = new float[16];
        for (int i2 = 31; i2 >= 0; --i2) {
            fArray[i2] = 0.0f;
        }
        float[] fArray4 = this.samples;
        fArray2[0] = fArray4[0] + fArray4[31];
        fArray2[1] = fArray4[1] + fArray4[30];
        fArray2[2] = fArray4[2] + fArray4[29];
        fArray2[3] = fArray4[3] + fArray4[28];
        fArray2[4] = fArray4[4] + fArray4[27];
        fArray2[5] = fArray4[5] + fArray4[26];
        fArray2[6] = fArray4[6] + fArray4[25];
        fArray2[7] = fArray4[7] + fArray4[24];
        fArray2[8] = fArray4[8] + fArray4[23];
        fArray2[9] = fArray4[9] + fArray4[22];
        fArray2[10] = fArray4[10] + fArray4[21];
        fArray2[11] = fArray4[11] + fArray4[20];
        fArray2[12] = fArray4[12] + fArray4[19];
        fArray2[13] = fArray4[13] + fArray4[18];
        fArray2[14] = fArray4[14] + fArray4[17];
        fArray2[15] = fArray4[15] + fArray4[16];
        fArray3[0] = fArray2[0] + fArray2[15];
        fArray3[1] = fArray2[1] + fArray2[14];
        fArray3[2] = fArray2[2] + fArray2[13];
        fArray3[3] = fArray2[3] + fArray2[12];
        fArray3[4] = fArray2[4] + fArray2[11];
        fArray3[5] = fArray2[5] + fArray2[10];
        fArray3[6] = fArray2[6] + fArray2[9];
        fArray3[7] = fArray2[7] + fArray2[8];
        fArray3[8] = (fArray2[0] - fArray2[15]) * cos1_32;
        fArray3[9] = (fArray2[1] - fArray2[14]) * cos3_32;
        fArray3[10] = (fArray2[2] - fArray2[13]) * cos5_32;
        fArray3[11] = (fArray2[3] - fArray2[12]) * cos7_32;
        fArray3[12] = (fArray2[4] - fArray2[11]) * cos9_32;
        fArray3[13] = (fArray2[5] - fArray2[10]) * cos11_32;
        fArray3[14] = (fArray2[6] - fArray2[9]) * cos13_32;
        fArray3[15] = (fArray2[7] - fArray2[8]) * cos15_32;
        fArray2[0] = fArray3[0] + fArray3[7];
        fArray2[1] = fArray3[1] + fArray3[6];
        fArray2[2] = fArray3[2] + fArray3[5];
        fArray2[3] = fArray3[3] + fArray3[4];
        fArray2[4] = (fArray3[0] - fArray3[7]) * cos1_16;
        fArray2[5] = (fArray3[1] - fArray3[6]) * cos3_16;
        fArray2[6] = (fArray3[2] - fArray3[5]) * cos5_16;
        fArray2[7] = (fArray3[3] - fArray3[4]) * cos7_16;
        fArray2[8] = fArray3[8] + fArray3[15];
        fArray2[9] = fArray3[9] + fArray3[14];
        fArray2[10] = fArray3[10] + fArray3[13];
        fArray2[11] = fArray3[11] + fArray3[12];
        fArray2[12] = (fArray3[8] - fArray3[15]) * cos1_16;
        fArray2[13] = (fArray3[9] - fArray3[14]) * cos3_16;
        fArray2[14] = (fArray3[10] - fArray3[13]) * cos5_16;
        fArray2[15] = (fArray3[11] - fArray3[12]) * cos7_16;
        fArray3[0] = fArray2[0] + fArray2[3];
        fArray3[1] = fArray2[1] + fArray2[2];
        fArray3[2] = (fArray2[0] - fArray2[3]) * cos1_8;
        fArray3[3] = (fArray2[1] - fArray2[2]) * cos3_8;
        fArray3[4] = fArray2[4] + fArray2[7];
        fArray3[5] = fArray2[5] + fArray2[6];
        fArray3[6] = (fArray2[4] - fArray2[7]) * cos1_8;
        fArray3[7] = (fArray2[5] - fArray2[6]) * cos3_8;
        fArray3[8] = fArray2[8] + fArray2[11];
        fArray3[9] = fArray2[9] + fArray2[10];
        fArray3[10] = (fArray2[8] - fArray2[11]) * cos1_8;
        fArray3[11] = (fArray2[9] - fArray2[10]) * cos3_8;
        fArray3[12] = fArray2[12] + fArray2[15];
        fArray3[13] = fArray2[13] + fArray2[14];
        fArray3[14] = (fArray2[12] - fArray2[15]) * cos1_8;
        fArray3[15] = (fArray2[13] - fArray2[14]) * cos3_8;
        fArray2[0] = fArray3[0] + fArray3[1];
        fArray2[1] = (fArray3[0] - fArray3[1]) * cos1_4;
        fArray2[2] = fArray3[2] + fArray3[3];
        fArray2[3] = (fArray3[2] - fArray3[3]) * cos1_4;
        fArray2[4] = fArray3[4] + fArray3[5];
        fArray2[5] = (fArray3[4] - fArray3[5]) * cos1_4;
        fArray2[6] = fArray3[6] + fArray3[7];
        fArray2[7] = (fArray3[6] - fArray3[7]) * cos1_4;
        fArray2[8] = fArray3[8] + fArray3[9];
        fArray2[9] = (fArray3[8] - fArray3[9]) * cos1_4;
        fArray2[10] = fArray3[10] + fArray3[11];
        fArray2[11] = (fArray3[10] - fArray3[11]) * cos1_4;
        fArray2[12] = fArray3[12] + fArray3[13];
        fArray2[13] = (fArray3[12] - fArray3[13]) * cos1_4;
        fArray2[14] = fArray3[14] + fArray3[15];
        fArray2[15] = (fArray3[14] - fArray3[15]) * cos1_4;
        fArray[12] = fArray2[7];
        fArray[4] = fArray[12] + fArray2[5];
        fArray[19] = -fArray[4] - fArray2[6];
        fArray[27] = -fArray2[6] - fArray2[7] - fArray2[4];
        fArray[14] = fArray2[15];
        fArray[10] = fArray[14] + fArray2[11];
        fArray[6] = fArray[10] + fArray2[13];
        fArray[2] = fArray2[15] + fArray2[13] + fArray2[9];
        fArray[17] = -fArray[2] - fArray2[14];
        float f2 = -fArray2[14] - fArray2[15] - fArray2[10] - fArray2[11];
        fArray[21] = f2 - fArray2[13];
        fArray[29] = -fArray2[14] - fArray2[15] - fArray2[12] - fArray2[8];
        fArray[25] = f2 - fArray2[12];
        fArray[31] = -fArray2[0];
        fArray[0] = fArray2[1];
        fArray[8] = fArray2[3];
        fArray[23] = -fArray[8] - fArray2[2];
        fArray2[0] = (fArray4[0] - fArray4[31]) * cos1_64;
        fArray2[1] = (fArray4[1] - fArray4[30]) * cos3_64;
        fArray2[2] = (fArray4[2] - fArray4[29]) * cos5_64;
        fArray2[3] = (fArray4[3] - fArray4[28]) * cos7_64;
        fArray2[4] = (fArray4[4] - fArray4[27]) * cos9_64;
        fArray2[5] = (fArray4[5] - fArray4[26]) * cos11_64;
        fArray2[6] = (fArray4[6] - fArray4[25]) * cos13_64;
        fArray2[7] = (fArray4[7] - fArray4[24]) * cos15_64;
        fArray2[8] = (fArray4[8] - fArray4[23]) * cos17_64;
        fArray2[9] = (fArray4[9] - fArray4[22]) * cos19_64;
        fArray2[10] = (fArray4[10] - fArray4[21]) * cos21_64;
        fArray2[11] = (fArray4[11] - fArray4[20]) * cos23_64;
        fArray2[12] = (fArray4[12] - fArray4[19]) * cos25_64;
        fArray2[13] = (fArray4[13] - fArray4[18]) * cos27_64;
        fArray2[14] = (fArray4[14] - fArray4[17]) * cos29_64;
        fArray2[15] = (fArray4[15] - fArray4[16]) * cos31_64;
        fArray3[0] = fArray2[0] + fArray2[15];
        fArray3[1] = fArray2[1] + fArray2[14];
        fArray3[2] = fArray2[2] + fArray2[13];
        fArray3[3] = fArray2[3] + fArray2[12];
        fArray3[4] = fArray2[4] + fArray2[11];
        fArray3[5] = fArray2[5] + fArray2[10];
        fArray3[6] = fArray2[6] + fArray2[9];
        fArray3[7] = fArray2[7] + fArray2[8];
        fArray3[8] = (fArray2[0] - fArray2[15]) * cos1_32;
        fArray3[9] = (fArray2[1] - fArray2[14]) * cos3_32;
        fArray3[10] = (fArray2[2] - fArray2[13]) * cos5_32;
        fArray3[11] = (fArray2[3] - fArray2[12]) * cos7_32;
        fArray3[12] = (fArray2[4] - fArray2[11]) * cos9_32;
        fArray3[13] = (fArray2[5] - fArray2[10]) * cos11_32;
        fArray3[14] = (fArray2[6] - fArray2[9]) * cos13_32;
        fArray3[15] = (fArray2[7] - fArray2[8]) * cos15_32;
        fArray2[0] = fArray3[0] + fArray3[7];
        fArray2[1] = fArray3[1] + fArray3[6];
        fArray2[2] = fArray3[2] + fArray3[5];
        fArray2[3] = fArray3[3] + fArray3[4];
        fArray2[4] = (fArray3[0] - fArray3[7]) * cos1_16;
        fArray2[5] = (fArray3[1] - fArray3[6]) * cos3_16;
        fArray2[6] = (fArray3[2] - fArray3[5]) * cos5_16;
        fArray2[7] = (fArray3[3] - fArray3[4]) * cos7_16;
        fArray2[8] = fArray3[8] + fArray3[15];
        fArray2[9] = fArray3[9] + fArray3[14];
        fArray2[10] = fArray3[10] + fArray3[13];
        fArray2[11] = fArray3[11] + fArray3[12];
        fArray2[12] = (fArray3[8] - fArray3[15]) * cos1_16;
        fArray2[13] = (fArray3[9] - fArray3[14]) * cos3_16;
        fArray2[14] = (fArray3[10] - fArray3[13]) * cos5_16;
        fArray2[15] = (fArray3[11] - fArray3[12]) * cos7_16;
        fArray3[0] = fArray2[0] + fArray2[3];
        fArray3[1] = fArray2[1] + fArray2[2];
        fArray3[2] = (fArray2[0] - fArray2[3]) * cos1_8;
        fArray3[3] = (fArray2[1] - fArray2[2]) * cos3_8;
        fArray3[4] = fArray2[4] + fArray2[7];
        fArray3[5] = fArray2[5] + fArray2[6];
        fArray3[6] = (fArray2[4] - fArray2[7]) * cos1_8;
        fArray3[7] = (fArray2[5] - fArray2[6]) * cos3_8;
        fArray3[8] = fArray2[8] + fArray2[11];
        fArray3[9] = fArray2[9] + fArray2[10];
        fArray3[10] = (fArray2[8] - fArray2[11]) * cos1_8;
        fArray3[11] = (fArray2[9] - fArray2[10]) * cos3_8;
        fArray3[12] = fArray2[12] + fArray2[15];
        fArray3[13] = fArray2[13] + fArray2[14];
        fArray3[14] = (fArray2[12] - fArray2[15]) * cos1_8;
        fArray3[15] = (fArray2[13] - fArray2[14]) * cos3_8;
        fArray2[0] = fArray3[0] + fArray3[1];
        fArray2[1] = (fArray3[0] - fArray3[1]) * cos1_4;
        fArray2[2] = fArray3[2] + fArray3[3];
        fArray2[3] = (fArray3[2] - fArray3[3]) * cos1_4;
        fArray2[4] = fArray3[4] + fArray3[5];
        fArray2[5] = (fArray3[4] - fArray3[5]) * cos1_4;
        fArray2[6] = fArray3[6] + fArray3[7];
        fArray2[7] = (fArray3[6] - fArray3[7]) * cos1_4;
        fArray2[8] = fArray3[8] + fArray3[9];
        fArray2[9] = (fArray3[8] - fArray3[9]) * cos1_4;
        fArray2[10] = fArray3[10] + fArray3[11];
        fArray2[11] = (fArray3[10] - fArray3[11]) * cos1_4;
        fArray2[12] = fArray3[12] + fArray3[13];
        fArray2[13] = (fArray3[12] - fArray3[13]) * cos1_4;
        fArray2[14] = fArray3[14] + fArray3[15];
        fArray2[15] = (fArray3[14] - fArray3[15]) * cos1_4;
        fArray[15] = fArray2[15];
        fArray[13] = fArray[15] + fArray2[7];
        fArray[11] = fArray[13] + fArray2[11];
        fArray[5] = fArray[11] + fArray2[5] + fArray2[13];
        fArray[9] = fArray2[15] + fArray2[11] + fArray2[3];
        fArray[7] = fArray[9] + fArray2[13];
        f2 = fArray2[13] + fArray2[15] + fArray2[9];
        fArray[1] = f2 + fArray2[1];
        fArray[16] = -fArray[1] - fArray2[14];
        fArray[3] = f2 + fArray2[5] + fArray2[7];
        fArray[18] = -fArray[3] - fArray2[6] - fArray2[14];
        f2 = -fArray2[10] - fArray2[11] - fArray2[14] - fArray2[15];
        fArray[22] = f2 - fArray2[13] - fArray2[2] - fArray2[3];
        fArray[20] = f2 - fArray2[13] - fArray2[5] - fArray2[6] - fArray2[7];
        fArray[24] = f2 - fArray2[12] - fArray2[2] - fArray2[3];
        float f3 = fArray2[4] + fArray2[6] + fArray2[7];
        fArray[26] = f2 - fArray2[12] - f3;
        f2 = -fArray2[8] - fArray2[12] - fArray2[14] - fArray2[15];
        fArray[30] = f2 - fArray2[0];
        fArray[28] = f2 - f3;
        fArray4 = fArray;
        float[] fArray5 = this.actual_v;
        fArray5[0 + this.actual_write_pos] = fArray4[0];
        fArray5[16 + this.actual_write_pos] = fArray4[1];
        fArray5[32 + this.actual_write_pos] = fArray4[2];
        fArray5[48 + this.actual_write_pos] = fArray4[3];
        fArray5[64 + this.actual_write_pos] = fArray4[4];
        fArray5[80 + this.actual_write_pos] = fArray4[5];
        fArray5[96 + this.actual_write_pos] = fArray4[6];
        fArray5[112 + this.actual_write_pos] = fArray4[7];
        fArray5[128 + this.actual_write_pos] = fArray4[8];
        fArray5[144 + this.actual_write_pos] = fArray4[9];
        fArray5[160 + this.actual_write_pos] = fArray4[10];
        fArray5[176 + this.actual_write_pos] = fArray4[11];
        fArray5[192 + this.actual_write_pos] = fArray4[12];
        fArray5[208 + this.actual_write_pos] = fArray4[13];
        fArray5[224 + this.actual_write_pos] = fArray4[14];
        fArray5[240 + this.actual_write_pos] = fArray4[15];
        fArray5[256 + this.actual_write_pos] = 0.0f;
        fArray5[272 + this.actual_write_pos] = -fArray4[15];
        fArray5[288 + this.actual_write_pos] = -fArray4[14];
        fArray5[304 + this.actual_write_pos] = -fArray4[13];
        fArray5[320 + this.actual_write_pos] = -fArray4[12];
        fArray5[336 + this.actual_write_pos] = -fArray4[11];
        fArray5[352 + this.actual_write_pos] = -fArray4[10];
        fArray5[368 + this.actual_write_pos] = -fArray4[9];
        fArray5[384 + this.actual_write_pos] = -fArray4[8];
        fArray5[400 + this.actual_write_pos] = -fArray4[7];
        fArray5[416 + this.actual_write_pos] = -fArray4[6];
        fArray5[432 + this.actual_write_pos] = -fArray4[5];
        fArray5[448 + this.actual_write_pos] = -fArray4[4];
        fArray5[464 + this.actual_write_pos] = -fArray4[3];
        fArray5[480 + this.actual_write_pos] = -fArray4[2];
        fArray5[496 + this.actual_write_pos] = -fArray4[1];
    }

    private void compute_pcm_samples0(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[0 + n2] * fArray3[0] + fArray[15 + n2] * fArray3[1] + fArray[14 + n2] * fArray3[2] + fArray[13 + n2] * fArray3[3] + fArray[12 + n2] * fArray3[4] + fArray[11 + n2] * fArray3[5] + fArray[10 + n2] * fArray3[6] + fArray[9 + n2] * fArray3[7] + fArray[8 + n2] * fArray3[8] + fArray[7 + n2] * fArray3[9] + fArray[6 + n2] * fArray3[10] + fArray[5 + n2] * fArray3[11] + fArray[4 + n2] * fArray3[12] + fArray[3 + n2] * fArray3[13] + fArray[2 + n2] * fArray3[14] + fArray[1 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples1(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[1 + n2] * fArray3[0] + fArray[0 + n2] * fArray3[1] + fArray[15 + n2] * fArray3[2] + fArray[14 + n2] * fArray3[3] + fArray[13 + n2] * fArray3[4] + fArray[12 + n2] * fArray3[5] + fArray[11 + n2] * fArray3[6] + fArray[10 + n2] * fArray3[7] + fArray[9 + n2] * fArray3[8] + fArray[8 + n2] * fArray3[9] + fArray[7 + n2] * fArray3[10] + fArray[6 + n2] * fArray3[11] + fArray[5 + n2] * fArray3[12] + fArray[4 + n2] * fArray3[13] + fArray[3 + n2] * fArray3[14] + fArray[2 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples2(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[2 + n2] * fArray3[0] + fArray[1 + n2] * fArray3[1] + fArray[0 + n2] * fArray3[2] + fArray[15 + n2] * fArray3[3] + fArray[14 + n2] * fArray3[4] + fArray[13 + n2] * fArray3[5] + fArray[12 + n2] * fArray3[6] + fArray[11 + n2] * fArray3[7] + fArray[10 + n2] * fArray3[8] + fArray[9 + n2] * fArray3[9] + fArray[8 + n2] * fArray3[10] + fArray[7 + n2] * fArray3[11] + fArray[6 + n2] * fArray3[12] + fArray[5 + n2] * fArray3[13] + fArray[4 + n2] * fArray3[14] + fArray[3 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples3(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        boolean bl2 = false;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[3 + n2] * fArray3[0] + fArray[2 + n2] * fArray3[1] + fArray[1 + n2] * fArray3[2] + fArray[0 + n2] * fArray3[3] + fArray[15 + n2] * fArray3[4] + fArray[14 + n2] * fArray3[5] + fArray[13 + n2] * fArray3[6] + fArray[12 + n2] * fArray3[7] + fArray[11 + n2] * fArray3[8] + fArray[10 + n2] * fArray3[9] + fArray[9 + n2] * fArray3[10] + fArray[8 + n2] * fArray3[11] + fArray[7 + n2] * fArray3[12] + fArray[6 + n2] * fArray3[13] + fArray[5 + n2] * fArray3[14] + fArray[4 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples4(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[4 + n2] * fArray3[0] + fArray[3 + n2] * fArray3[1] + fArray[2 + n2] * fArray3[2] + fArray[1 + n2] * fArray3[3] + fArray[0 + n2] * fArray3[4] + fArray[15 + n2] * fArray3[5] + fArray[14 + n2] * fArray3[6] + fArray[13 + n2] * fArray3[7] + fArray[12 + n2] * fArray3[8] + fArray[11 + n2] * fArray3[9] + fArray[10 + n2] * fArray3[10] + fArray[9 + n2] * fArray3[11] + fArray[8 + n2] * fArray3[12] + fArray[7 + n2] * fArray3[13] + fArray[6 + n2] * fArray3[14] + fArray[5 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples5(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[5 + n2] * fArray3[0] + fArray[4 + n2] * fArray3[1] + fArray[3 + n2] * fArray3[2] + fArray[2 + n2] * fArray3[3] + fArray[1 + n2] * fArray3[4] + fArray[0 + n2] * fArray3[5] + fArray[15 + n2] * fArray3[6] + fArray[14 + n2] * fArray3[7] + fArray[13 + n2] * fArray3[8] + fArray[12 + n2] * fArray3[9] + fArray[11 + n2] * fArray3[10] + fArray[10 + n2] * fArray3[11] + fArray[9 + n2] * fArray3[12] + fArray[8 + n2] * fArray3[13] + fArray[7 + n2] * fArray3[14] + fArray[6 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples6(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[6 + n2] * fArray3[0] + fArray[5 + n2] * fArray3[1] + fArray[4 + n2] * fArray3[2] + fArray[3 + n2] * fArray3[3] + fArray[2 + n2] * fArray3[4] + fArray[1 + n2] * fArray3[5] + fArray[0 + n2] * fArray3[6] + fArray[15 + n2] * fArray3[7] + fArray[14 + n2] * fArray3[8] + fArray[13 + n2] * fArray3[9] + fArray[12 + n2] * fArray3[10] + fArray[11 + n2] * fArray3[11] + fArray[10 + n2] * fArray3[12] + fArray[9 + n2] * fArray3[13] + fArray[8 + n2] * fArray3[14] + fArray[7 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples7(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[7 + n2] * fArray3[0] + fArray[6 + n2] * fArray3[1] + fArray[5 + n2] * fArray3[2] + fArray[4 + n2] * fArray3[3] + fArray[3 + n2] * fArray3[4] + fArray[2 + n2] * fArray3[5] + fArray[1 + n2] * fArray3[6] + fArray[0 + n2] * fArray3[7] + fArray[15 + n2] * fArray3[8] + fArray[14 + n2] * fArray3[9] + fArray[13 + n2] * fArray3[10] + fArray[12 + n2] * fArray3[11] + fArray[11 + n2] * fArray3[12] + fArray[10 + n2] * fArray3[13] + fArray[9 + n2] * fArray3[14] + fArray[8 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples8(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[8 + n2] * fArray3[0] + fArray[7 + n2] * fArray3[1] + fArray[6 + n2] * fArray3[2] + fArray[5 + n2] * fArray3[3] + fArray[4 + n2] * fArray3[4] + fArray[3 + n2] * fArray3[5] + fArray[2 + n2] * fArray3[6] + fArray[1 + n2] * fArray3[7] + fArray[0 + n2] * fArray3[8] + fArray[15 + n2] * fArray3[9] + fArray[14 + n2] * fArray3[10] + fArray[13 + n2] * fArray3[11] + fArray[12 + n2] * fArray3[12] + fArray[11 + n2] * fArray3[13] + fArray[10 + n2] * fArray3[14] + fArray[9 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples9(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[9 + n2] * fArray3[0] + fArray[8 + n2] * fArray3[1] + fArray[7 + n2] * fArray3[2] + fArray[6 + n2] * fArray3[3] + fArray[5 + n2] * fArray3[4] + fArray[4 + n2] * fArray3[5] + fArray[3 + n2] * fArray3[6] + fArray[2 + n2] * fArray3[7] + fArray[1 + n2] * fArray3[8] + fArray[0 + n2] * fArray3[9] + fArray[15 + n2] * fArray3[10] + fArray[14 + n2] * fArray3[11] + fArray[13 + n2] * fArray3[12] + fArray[12 + n2] * fArray3[13] + fArray[11 + n2] * fArray3[14] + fArray[10 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples10(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[10 + n2] * fArray3[0] + fArray[9 + n2] * fArray3[1] + fArray[8 + n2] * fArray3[2] + fArray[7 + n2] * fArray3[3] + fArray[6 + n2] * fArray3[4] + fArray[5 + n2] * fArray3[5] + fArray[4 + n2] * fArray3[6] + fArray[3 + n2] * fArray3[7] + fArray[2 + n2] * fArray3[8] + fArray[1 + n2] * fArray3[9] + fArray[0 + n2] * fArray3[10] + fArray[15 + n2] * fArray3[11] + fArray[14 + n2] * fArray3[12] + fArray[13 + n2] * fArray3[13] + fArray[12 + n2] * fArray3[14] + fArray[11 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples11(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[11 + n2] * fArray3[0] + fArray[10 + n2] * fArray3[1] + fArray[9 + n2] * fArray3[2] + fArray[8 + n2] * fArray3[3] + fArray[7 + n2] * fArray3[4] + fArray[6 + n2] * fArray3[5] + fArray[5 + n2] * fArray3[6] + fArray[4 + n2] * fArray3[7] + fArray[3 + n2] * fArray3[8] + fArray[2 + n2] * fArray3[9] + fArray[1 + n2] * fArray3[10] + fArray[0 + n2] * fArray3[11] + fArray[15 + n2] * fArray3[12] + fArray[14 + n2] * fArray3[13] + fArray[13 + n2] * fArray3[14] + fArray[12 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples12(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[12 + n2] * fArray3[0] + fArray[11 + n2] * fArray3[1] + fArray[10 + n2] * fArray3[2] + fArray[9 + n2] * fArray3[3] + fArray[8 + n2] * fArray3[4] + fArray[7 + n2] * fArray3[5] + fArray[6 + n2] * fArray3[6] + fArray[5 + n2] * fArray3[7] + fArray[4 + n2] * fArray3[8] + fArray[3 + n2] * fArray3[9] + fArray[2 + n2] * fArray3[10] + fArray[1 + n2] * fArray3[11] + fArray[0 + n2] * fArray3[12] + fArray[15 + n2] * fArray3[13] + fArray[14 + n2] * fArray3[14] + fArray[13 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples13(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[13 + n2] * fArray3[0] + fArray[12 + n2] * fArray3[1] + fArray[11 + n2] * fArray3[2] + fArray[10 + n2] * fArray3[3] + fArray[9 + n2] * fArray3[4] + fArray[8 + n2] * fArray3[5] + fArray[7 + n2] * fArray3[6] + fArray[6 + n2] * fArray3[7] + fArray[5 + n2] * fArray3[8] + fArray[4 + n2] * fArray3[9] + fArray[3 + n2] * fArray3[10] + fArray[2 + n2] * fArray3[11] + fArray[1 + n2] * fArray3[12] + fArray[0 + n2] * fArray3[13] + fArray[15 + n2] * fArray3[14] + fArray[14 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples14(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[14 + n2] * fArray3[0] + fArray[13 + n2] * fArray3[1] + fArray[12 + n2] * fArray3[2] + fArray[11 + n2] * fArray3[3] + fArray[10 + n2] * fArray3[4] + fArray[9 + n2] * fArray3[5] + fArray[8 + n2] * fArray3[6] + fArray[7 + n2] * fArray3[7] + fArray[6 + n2] * fArray3[8] + fArray[5 + n2] * fArray3[9] + fArray[4 + n2] * fArray3[10] + fArray[3 + n2] * fArray3[11] + fArray[2 + n2] * fArray3[12] + fArray[1 + n2] * fArray3[13] + fArray[0 + n2] * fArray3[14] + fArray[15 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples15(Obuffer obuffer) {
        float[] fArray = this.actual_v;
        float[] fArray2 = this._tmpOut;
        int n2 = 0;
        for (int i2 = 0; i2 < 32; ++i2) {
            float f2;
            float[] fArray3 = d16[i2];
            fArray2[i2] = f2 = (fArray[15 + n2] * fArray3[0] + fArray[14 + n2] * fArray3[1] + fArray[13 + n2] * fArray3[2] + fArray[12 + n2] * fArray3[3] + fArray[11 + n2] * fArray3[4] + fArray[10 + n2] * fArray3[5] + fArray[9 + n2] * fArray3[6] + fArray[8 + n2] * fArray3[7] + fArray[7 + n2] * fArray3[8] + fArray[6 + n2] * fArray3[9] + fArray[5 + n2] * fArray3[10] + fArray[4 + n2] * fArray3[11] + fArray[3 + n2] * fArray3[12] + fArray[2 + n2] * fArray3[13] + fArray[1 + n2] * fArray3[14] + fArray[0 + n2] * fArray3[15]) * this.scalefactor;
            n2 += 16;
        }
    }

    private void compute_pcm_samples(Obuffer obuffer) {
        switch (this.actual_write_pos) {
            case 0: {
                this.compute_pcm_samples0(obuffer);
                break;
            }
            case 1: {
                this.compute_pcm_samples1(obuffer);
                break;
            }
            case 2: {
                this.compute_pcm_samples2(obuffer);
                break;
            }
            case 3: {
                this.compute_pcm_samples3(obuffer);
                break;
            }
            case 4: {
                this.compute_pcm_samples4(obuffer);
                break;
            }
            case 5: {
                this.compute_pcm_samples5(obuffer);
                break;
            }
            case 6: {
                this.compute_pcm_samples6(obuffer);
                break;
            }
            case 7: {
                this.compute_pcm_samples7(obuffer);
                break;
            }
            case 8: {
                this.compute_pcm_samples8(obuffer);
                break;
            }
            case 9: {
                this.compute_pcm_samples9(obuffer);
                break;
            }
            case 10: {
                this.compute_pcm_samples10(obuffer);
                break;
            }
            case 11: {
                this.compute_pcm_samples11(obuffer);
                break;
            }
            case 12: {
                this.compute_pcm_samples12(obuffer);
                break;
            }
            case 13: {
                this.compute_pcm_samples13(obuffer);
                break;
            }
            case 14: {
                this.compute_pcm_samples14(obuffer);
                break;
            }
            case 15: {
                this.compute_pcm_samples15(obuffer);
            }
        }
        if (obuffer != null) {
            obuffer.appendSamples(this.channel, this._tmpOut);
        }
    }

    public void calculate_pcm_samples(Obuffer obuffer) {
        this.compute_new_v();
        this.compute_pcm_samples(obuffer);
        this.actual_write_pos = this.actual_write_pos + 1 & 0xF;
        this.actual_v = this.actual_v == this.v1 ? this.v2 : this.v1;
        for (int i2 = 0; i2 < 32; ++i2) {
            this.samples[i2] = 0.0f;
        }
    }

    private static float[] load_d() {
        try {
            Class<Float> clazz = Float.TYPE;
            Object object = JavaLayerUtils.deserializeArrayResource("sfd.ser", clazz, 512);
            return (float[])object;
        }
        catch (IOException iOException) {
            throw new ExceptionInInitializerError(iOException);
        }
    }

    private static float[][] splitArray(float[] fArray, int n2) {
        int n3 = fArray.length / n2;
        float[][] fArrayArray = new float[n3][];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArrayArray[i2] = SynthesisFilter.subArray(fArray, i2 * n2, n2);
        }
        return fArrayArray;
    }

    private static float[] subArray(float[] fArray, int n2, int n3) {
        if (n2 + n3 > fArray.length) {
            n3 = fArray.length - n2;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        float[] fArray2 = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray2[i2] = fArray[n2 + i2];
        }
        return fArray2;
    }
}

