/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.render.RenderItem;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityRenderer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.chunk.ChunkCache;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.ICamera;
import com.mojang.minecraft.render.RenderBlocks;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class WorldRenderer {
    public float distance;
    public World worldObj;
    private int field_1744_C = -1;
    private static Tessellator field_1742_D;
    public static int chunksUpdated;
    public int posX;
    public int posY;
    public int posZ;
    public int sizeWidth;
    public int sizeHeight;
    public int sizeDepth;
    public int field_1755_i;
    public int field_1754_j;
    public int field_1753_k;
    public int field_1752_l;
    public int field_1751_m;
    public int field_1750_n;
    public boolean isInFrustrum = false;
    public boolean[] skipRenderPass = new boolean[2];
    public int field_1746_q;
    public int field_1743_r;
    public int field_1741_s;
    public float rendererRadius;
    public boolean needsUpdate;
    public AxisAlignedBB field_1736_v;
    public int chunkIndex;
    public boolean isAnOccludedChunk = true;
    public boolean field_1733_y;
    public int field_1732_z;
    public boolean field_1747_A;
    private boolean isInitialized = false;
    public List<TileEntity> tileEntityRenderers = new ArrayList<TileEntity>();
    private List<TileEntity> tileEntities;
    static boolean traceDone;

    static {
        chunksUpdated = 0;
        traceDone = false;
        field_1742_D = Tessellator.field_1512_a;
    }

    public WorldRenderer(World world, List<TileEntity> list, int i, int j, int k, int l, int i1) {
        this.worldObj = world;
        this.tileEntities = list;
        this.sizeHeight = this.sizeDepth = l;
        this.sizeWidth = this.sizeDepth;
        this.rendererRadius = MathHelper.squareRootFloat(this.sizeWidth * this.sizeWidth + this.sizeHeight * this.sizeHeight + this.sizeDepth * this.sizeDepth) / 2.0f;
        this.field_1744_C = i1;
        this.posX = -999;
        this.setPosition(i, j, k);
        this.needsUpdate = false;
    }

    public void setPosition(int i, int j, int k) {
        if (i == this.posX && j == this.posY && k == this.posZ) {
            return;
        }
        this.func_1195_b();
        this.posX = i;
        this.posY = j;
        this.posZ = k;
        this.field_1746_q = i + this.sizeWidth / 2;
        this.field_1743_r = j + this.sizeHeight / 2;
        this.field_1741_s = k + this.sizeDepth / 2;
        this.field_1752_l = i & 0x3FF;
        this.field_1751_m = j;
        this.field_1750_n = k & 0x3FF;
        this.field_1755_i = i - this.field_1752_l;
        this.field_1754_j = j - this.field_1751_m;
        this.field_1753_k = k - this.field_1750_n;
        float f = 2.0f;
        this.field_1736_v = AxisAlignedBB.func_1168_a((float)i - f, (float)j - f, (float)k - f, (float)(i + this.sizeWidth) + f, (float)(j + this.sizeHeight) + f, (float)(k + this.sizeDepth) + f);
        GL11.glNewList((int)(this.field_1744_C + 2), (int)4864);
        RenderItem.func_142_a(AxisAlignedBB.func_1161_b((float)this.field_1752_l - f, (float)this.field_1751_m - f, (float)this.field_1750_n - f, (float)(this.field_1752_l + this.sizeWidth) + f, (float)(this.field_1751_m + this.sizeHeight) + f, (float)(this.field_1750_n + this.sizeDepth) + f));
        GL11.glEndList();
        this.func_1194_f();
    }

    private void func_1203_g() {
        GL11.glTranslatef((float)this.field_1752_l, (float)this.field_1751_m, (float)this.field_1750_n);
    }

    public void updateRenderer() {
        ++chunksUpdated;
        int minX = this.posX;
        int minY = this.posY;
        int minZ = this.posZ;
        int l = this.posX + this.sizeWidth;
        int i1 = this.posY + this.sizeHeight;
        int j1 = this.posZ + this.sizeDepth;
        int k1 = 0;
        while (k1 < 2) {
            this.skipRenderPass[k1] = true;
            ++k1;
        }
        Chunk.field_1540_a = false;
        HashSet<TileEntity> hashset = new HashSet<TileEntity>();
        hashset.addAll(this.tileEntityRenderers);
        this.tileEntityRenderers.clear();
        int l1 = 1;
        ChunkCache chunkcache = new ChunkCache(this.worldObj, minX - l1, minY - l1, minZ - l1, l + l1, i1 + l1, j1 + l1);
        RenderBlocks renderblocks = new RenderBlocks(chunkcache);
        for (int passNumber = 0; passNumber < 2; ++passNumber) {
            boolean flag = false;
            boolean flag1 = false;
            boolean madeList = false;
            int y = minY;
            while (y < i1) {
                int z = minZ;
                while (z < j1) {
                    int x = minX;
                    while (x < l) {
                        int blockId = chunkcache.getBlock(x, y, z);
                        if (blockId > 0) {
                            Block block;
                            int j3;
                            TileEntity tileentity;
                            if (!madeList) {
                                madeList = true;
                                GL11.glNewList((int)(this.field_1744_C + passNumber), (int)4864);
                                GL11.glPushMatrix();
                                this.func_1203_g();
                                float f = 1.000001f;
                                GL11.glTranslatef((float)((float)(-this.sizeDepth) / 2.0f), (float)((float)(-this.sizeHeight) / 2.0f), (float)((float)(-this.sizeDepth) / 2.0f));
                                GL11.glScalef((float)f, (float)f, (float)f);
                                GL11.glTranslatef((float)((float)this.sizeDepth / 2.0f), (float)((float)this.sizeHeight / 2.0f), (float)((float)this.sizeDepth / 2.0f));
                                field_1742_D.func_977_b();
                                field_1742_D.setTranslation(-this.posX, -this.posY, -this.posZ);
                            }
                            if (passNumber == 0 && Block.isBlockContainer[blockId] && TileEntityRenderer.instance.checkIfTileEntity(tileentity = chunkcache.genTileEntityWorld(x, y, z))) {
                                this.tileEntityRenderers.add(tileentity);
                            }
                            if ((j3 = (block = Block.allBlocks[blockId]).func_234_g()) != passNumber) {
                                flag = true;
                            } else if (j3 == passNumber) {
                                flag1 |= renderblocks.func_1234_a(block, x, y, z);
                            }
                        }
                        ++x;
                    }
                    ++z;
                }
                ++y;
            }
            if (madeList) {
                field_1742_D.func_982_a();
                GL11.glPopMatrix();
                GL11.glEndList();
                field_1742_D.setTranslation(0.0, 0.0, 0.0);
            } else {
                flag1 = false;
            }
            if (flag1) {
                this.skipRenderPass[passNumber] = false;
            }
            if (!flag) break;
        }
        HashSet<TileEntity> hashset1 = new HashSet<TileEntity>();
        hashset1.addAll(this.tileEntityRenderers);
        hashset1.removeAll(hashset);
        this.tileEntities.addAll(hashset1);
        hashset.removeAll(this.tileEntityRenderers);
        this.tileEntities.removeAll(hashset);
        this.field_1747_A = Chunk.field_1540_a;
        this.isInitialized = true;
        traceDone = true;
    }

    public float distanceToEntitySquared(Entity entity) {
        float f = (float)(entity.posX - (double)this.field_1746_q);
        float f1 = (float)(entity.posY - (double)this.field_1743_r);
        float f2 = (float)(entity.posZ - (double)this.field_1741_s);
        return f * f + f1 * f1 + f2 * f2;
    }

    public void func_1195_b() {
        int i = 0;
        while (i < 2) {
            this.skipRenderPass[i] = true;
            ++i;
        }
        this.isInFrustrum = false;
        this.isInitialized = false;
    }

    public void func_1204_c() {
        this.func_1195_b();
        this.worldObj = null;
    }

    public int func_1200_a(int i) {
        if (!this.isInFrustrum) {
            return -1;
        }
        if (!this.skipRenderPass[i]) {
            return this.field_1744_C + i;
        }
        return -1;
    }

    public void func_1199_a(ICamera icamera) {
        this.isInFrustrum = icamera.func_342_a(this.field_1736_v);
    }

    public void func_1201_d() {
        GL11.glCallList((int)(this.field_1744_C + 2));
    }

    public boolean func_1196_e() {
        if (!this.isInitialized) {
            return false;
        }
        return this.skipRenderPass[0] && this.skipRenderPass[1];
    }

    public void func_1194_f() {
        this.needsUpdate = true;
    }
}

