/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockSponge;

class FlowThread
extends Thread {
    World world;
    BlockSponge sponge;
    int x;
    int y;
    int z;
    int sx;
    int sy;
    int sz;

    public FlowThread(World world, BlockSponge sponge, int x, int y, int z, int sx, int sy, int sz) {
        this.world = world;
        this.sponge = sponge;
        this.x = x;
        this.y = y;
        this.z = z;
        this.sx = sx;
        this.sy = sy;
        this.sz = sz;
    }

    @Override
    public void run() {
        this.flowWater(this.world, this.x, this.y, this.z, this.sx, this.sy, this.sz);
    }

    public void dropWater(World world, int x, int y, int z) {
        int i = y;
        while (i > y - 3) {
            if (world.getBlock(x, i, z) != 0 && world.getBlock(x, i, z) != Block.waterStill.blockID) break;
            if (!BlockSponge.getSurroundSponge(world, x, i, z)) {
                world.setBlock(x, i, z, Block.waterMoving.blockID);
            }
            --i;
        }
    }

    public void flowWater(World world, int x, int y, int z, int sx, int sy, int sz) {
        int radius = 3;
        if (!(world.getBlock(x, y, z) != 0 && world.getBlock(x, y, z) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x, y, z))) {
            world.setBlock(x, y, z, Block.waterMoving.blockID);
            this.dropWater(world, x, y, z);
            if (!(x + 1 >= sx + radius || world.getBlock(x + 1, y, z) != 0 && world.getBlock(x + 1, y, z) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x + 1, y, z))) {
                this.flowWater(world, x + 1, y, z, sx, sy, sz);
            }
            if (!(z + 1 >= sz + radius || world.getBlock(x, y, z + 1) != 0 && world.getBlock(x, y, z + 1) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x, y, z + 1))) {
                this.flowWater(world, x, y, z + 1, sx, sy, sz);
            }
            if (!(x - 1 <= sx - radius || world.getBlock(x - 1, y, z) != 0 && world.getBlock(x - 1, y, z) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x - 1, y, z))) {
                this.flowWater(world, x - 1, y, z, sx, sy, sz);
            }
            if (!(z - 1 <= sz - radius || world.getBlock(x, y, z - 1) != 0 && world.getBlock(x, y, z - 1) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x, y, z - 1))) {
                this.flowWater(world, x, y, z - 1, sx, sy, sz);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

