/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockSponge
extends Block {
    static final byte radius = 2;

    protected BlockSponge(int i) {
        super(i, Material.sponge);
        this.textureIndex = 48;
    }

    @Override
    public void onPlace(World world, int a, int b, int c) {
        super.onPlace(world, a, b, c);
        int x = a - 2;
        while (x <= a + 2) {
            int y = b - 2;
            while (y <= b + 2) {
                int z = c - 2;
                while (z <= c + 2) {
                    if (world.getBlock(x, y, z) == Block.waterMoving.blockID || world.getBlock(x, y, z) == Block.waterStill.blockID) {
                        world.setBlock(x, y, z, 0);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (l > 0 && Block.allBlocks[l].func_209_d() && world.func_625_o(i, j, k)) {
            this.onBreak(world, i, j, k, 19);
            world.setBlock(i, j, k, 87);
        }
    }

    public void dropWater(World world, int x, int y, int z) {
        int i = y;
        while (i > y - 3) {
            if (world.getBlock(x, i, z) != 0 && world.getBlock(x, i, z) != Block.waterStill.blockID || !BlockSponge.getSurroundSponge(world, x, i, z)) break;
            --i;
        }
    }

    public void flowWater(World world, int x, int y, int z, int sx, int sy, int sz) {
        int radius = 3;
        if (!(world.getBlock(x, y, z) != 0 && world.getBlock(x, y, z) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x, y, z))) {
            this.dropWater(world, x, y, z);
            if (!(x + 1 >= sx + radius || world.getBlock(x + 1, y, z) != 0 && world.getBlock(x + 1, y, z) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x + 1, y, z))) {
                world.triggerUpdate(x + 1, y, z, 1);
            }
            if (!(z + 1 >= sz + radius || world.getBlock(x, y, z + 1) != 0 && world.getBlock(x, y, z + 1) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x, y, z + 1))) {
                world.triggerUpdate(x, y, z + 1, 1);
            }
            if (!(x - 1 <= sx - radius || world.getBlock(x - 1, y, z) != 0 && world.getBlock(x - 1, y, z) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x - 1, y, z))) {
                world.triggerUpdate(x - 1, y, z, 1);
            }
            if (!(z - 1 <= sz - radius || world.getBlock(x, y, z - 1) != 0 && world.getBlock(x, y, z - 1) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x, y, z - 1))) {
                world.triggerUpdate(x, y, z + 1, 1);
            }
        }
    }

    @Override
    public void update(World world, int a, int b, int c, Random random) {
        super.update(world, a, b, c, random);
        int x = a - 2;
        while (x <= a + 2) {
            int y = b - 2;
            while (y <= b + 2) {
                int z = c - 2;
                while (z <= c + 2) {
                    if (world.getBlock(x, y, z) == Block.waterMoving.blockID || world.getBlock(x, y, z) == Block.waterStill.blockID) {
                        world.setBlock(x, y, z, 0);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void fillWater(World world, int x, int y, int z) {
        int radius = 3;
        int x1 = x - radius;
        while (x1 <= x + radius) {
            int y1 = y;
            while (y1 > y - radius) {
                int z1 = z - radius;
                while (z1 <= z + radius) {
                    if (!(world.getBlock(x1, y1, z1) != 0 && world.getBlock(x1, y1, z1) != Block.waterStill.blockID && world.getBlock(x1, y1, z1) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x, y, z))) {
                        world.setBlock(x1, y1, z1, Block.waterMoving.blockID);
                    }
                    ++z1;
                }
                --y1;
            }
            ++x1;
        }
    }

    public static boolean getSurroundSponge(World world, int x, int y, int z) {
        int x1 = x - 2;
        while (x1 <= x + 2) {
            int y1 = y - 2;
            while (y1 <= y + 2) {
                int z1 = z - 2;
                while (z1 <= z + 2) {
                    if (world.getBlock(x1, y1, z1) == Block.sponge.blockID) {
                        return true;
                    }
                    ++z1;
                }
                ++y1;
            }
            ++x1;
        }
        return false;
    }

    @Override
    public void onBreak(World world, int a, int b, int c, int bid) {
        super.onBreak(world, a, b, c, bid);
        int radius = 3;
        int x = a - radius;
        while (x <= a + radius) {
            int y = b + radius;
            while (y > b - radius) {
                int z = c - radius;
                while (z <= c + radius) {
                    if (world.getBlock(x, y, z) == Block.waterMoving.blockID || world.getBlock(x, y, z) == Block.waterStill.blockID) {
                        this.flowWater(world, x, y, z, a, b, c);
                    }
                    ++z;
                }
                --y;
            }
            ++x;
        }
    }
}

