/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemBlock;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.enums.EnumMobType;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.BlockBookshelf;
import com.mojang.minecraft.level.tile.BlockButton;
import com.mojang.minecraft.level.tile.BlockCactus;
import com.mojang.minecraft.level.tile.BlockChest;
import com.mojang.minecraft.level.tile.BlockClay;
import com.mojang.minecraft.level.tile.BlockCrops;
import com.mojang.minecraft.level.tile.BlockDirt;
import com.mojang.minecraft.level.tile.BlockDoor;
import com.mojang.minecraft.level.tile.BlockFence;
import com.mojang.minecraft.level.tile.BlockFire;
import com.mojang.minecraft.level.tile.BlockFlower;
import com.mojang.minecraft.level.tile.BlockFlowing;
import com.mojang.minecraft.level.tile.BlockFurnace;
import com.mojang.minecraft.level.tile.BlockGear;
import com.mojang.minecraft.level.tile.BlockGlass;
import com.mojang.minecraft.level.tile.BlockGrass;
import com.mojang.minecraft.level.tile.BlockGravel;
import com.mojang.minecraft.level.tile.BlockIce;
import com.mojang.minecraft.level.tile.BlockJukeBox;
import com.mojang.minecraft.level.tile.BlockLadder;
import com.mojang.minecraft.level.tile.BlockLeaves;
import com.mojang.minecraft.level.tile.BlockLever;
import com.mojang.minecraft.level.tile.BlockLog;
import com.mojang.minecraft.level.tile.BlockMinecartTrack;
import com.mojang.minecraft.level.tile.BlockMobSpawner;
import com.mojang.minecraft.level.tile.BlockMushroom;
import com.mojang.minecraft.level.tile.BlockObsidian;
import com.mojang.minecraft.level.tile.BlockOre;
import com.mojang.minecraft.level.tile.BlockOreBlock;
import com.mojang.minecraft.level.tile.BlockPressurePlate;
import com.mojang.minecraft.level.tile.BlockRedstoneOre;
import com.mojang.minecraft.level.tile.BlockRedstoneTorch;
import com.mojang.minecraft.level.tile.BlockRedstoneWire;
import com.mojang.minecraft.level.tile.BlockReed;
import com.mojang.minecraft.level.tile.BlockSand;
import com.mojang.minecraft.level.tile.BlockSapling;
import com.mojang.minecraft.level.tile.BlockSign;
import com.mojang.minecraft.level.tile.BlockSnow;
import com.mojang.minecraft.level.tile.BlockSnowBlock;
import com.mojang.minecraft.level.tile.BlockSoil;
import com.mojang.minecraft.level.tile.BlockSponge;
import com.mojang.minecraft.level.tile.BlockSpongeInactive;
import com.mojang.minecraft.level.tile.BlockStairs;
import com.mojang.minecraft.level.tile.BlockStationary;
import com.mojang.minecraft.level.tile.BlockStep;
import com.mojang.minecraft.level.tile.BlockStone;
import com.mojang.minecraft.level.tile.BlockTNT;
import com.mojang.minecraft.level.tile.BlockTorch;
import com.mojang.minecraft.level.tile.BlockWorkbench;
import com.mojang.minecraft.level.tile.StepSound;
import com.mojang.minecraft.level.tile.StepSoundSand;
import com.mojang.minecraft.level.tile.StepSoundStone;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.ArrayList;
import java.util.Random;

public class Block {
    public static final StepSound soundPowderFootstep;
    public static final StepSound soundWoodFootstep;
    public static final StepSound soundGravelFootstep;
    public static final StepSound soundGrassFootstep;
    public static final StepSound soundStoneFootstep;
    public static final StepSound soundMetalFootstep;
    public static final StepSound soundGlassFootstep;
    public static final StepSound soundClothFootstep;
    public static final StepSound soundSandFootstep;
    public static final Block[] allBlocks;
    public static final boolean[] field_344_o;
    public static final boolean[] opaqueCubeLookup;
    public static final boolean[] isBlockContainer;
    public static final int[] field_341_r;
    public static final boolean[] field_340_s;
    public static final int[] field_339_t;
    public static final Block stone;
    public static final BlockGrass grass;
    public static final Block dirt;
    public static final Block cobblestone;
    public static final Block planks;
    public static final Block sapling;
    public static final Block bedrock;
    public static final Block waterMoving;
    public static final Block waterStill;
    public static final Block lavaMoving;
    public static final Block lavaStill;
    public static final Block sand;
    public static final Block gravel;
    public static final Block oreGold;
    public static final Block oreIron;
    public static final Block oreCoal;
    public static final Block wood;
    public static final BlockLeaves leaves;
    public static final Block sponge;
    public static final Block glass;
    public static final Block cloth_red;
    public static final Block cloth_orange;
    public static final Block cloth_yellow;
    public static final Block cloth_lime;
    public static final Block cloth_green;
    public static final Block cloth_teal;
    public static final Block cloth_cyan;
    public static final Block cloth_blue;
    public static final Block cloth_indigo;
    public static final Block cloth_violet;
    public static final Block cloth_lilac;
    public static final Block cloth_pink;
    public static final Block cloth_magenta;
    public static final Block cloth_darkgray;
    public static final Block cloth;
    public static final Block cloth_lightgray;
    public static final BlockFlower plantYellow;
    public static final BlockFlower plantRed;
    public static final BlockFlower mushroomBrown;
    public static final BlockFlower mushroomRed;
    public static final Block blockGold;
    public static final Block blockSteel;
    public static final Block stairDouble;
    public static final Block stairSingle;
    public static final Block brick;
    public static final Block tnt;
    public static final Block bookShelf;
    public static final Block cobblestoneMossy;
    public static final Block obsidian;
    public static final Block torchWood;
    public static final BlockFire fire;
    public static final Block mobSpawner;
    public static final Block stairCompact_Wood;
    public static final Block crate;
    public static final Block redstoneWire;
    public static final Block oreDiamond;
    public static final Block blockDiamond;
    public static final Block workbench;
    public static final Block crops;
    public static final Block tilledField;
    public static final Block stoneOvenIdle;
    public static final Block stoneOvenActive;
    public static final Block pressurePlateWoodActive;
    public static final Block doorWood;
    public static final Block ladder;
    public static final Block minecartTrack;
    public static final Block stairCompactStone;
    public static final Block pressurePlateWoodIdle;
    public static final Block lever;
    public static final Block pressurePlateStone;
    public static final Block doorSteel;
    public static final Block pressurePlateWood;
    public static final Block oreRedstone;
    public static final Block oreRedstoneGlowing;
    public static final Block torchRedstoneIdle;
    public static final Block torchRedstoneActive;
    public static final Block button;
    public static final Block snow;
    public static final Block ice;
    public static final Block blockSnow;
    public static final Block cactus;
    public static final Block blockClay;
    public static final Block reed;
    public static final Block jukebox;
    public static final Block fence;
    public static final Block gear;
    public static final Block spongeInactive;
    public static final BlockFlower plantBlue;
    public int textureIndex;
    public final int blockID;
    protected float field_374_bd;
    protected float hardness;
    public double blockBound0;
    public double blockBound1;
    public double blockBound2;
    public double blockBound3;
    public double blockBound4;
    public double blockBound5;
    public StepSound stepSound = soundPowderFootstep;
    public float field_357_bm = 1.0f;
    public final Material material;
    public float field_355_bo = 0.6f;

    static {
        field_344_o = new boolean[256];
        opaqueCubeLookup = new boolean[256];
        isBlockContainer = new boolean[256];
        field_341_r = new int[256];
        field_340_s = new boolean[256];
        field_339_t = new int[256];
        soundPowderFootstep = new StepSound("stone", 1.0f, 1.0f);
        soundWoodFootstep = new StepSound("wood", 1.0f, 1.0f);
        soundGravelFootstep = new StepSound("gravel", 1.0f, 1.0f);
        soundGrassFootstep = new StepSound("grass", 1.0f, 1.0f);
        soundStoneFootstep = new StepSound("stone", 1.0f, 1.0f);
        soundMetalFootstep = new StepSound("stone", 1.0f, 1.5f);
        soundGlassFootstep = new StepSoundStone("stone", 1.0f, 1.0f);
        soundClothFootstep = new StepSound("cloth", 1.0f, 1.0f);
        soundSandFootstep = new StepSoundSand("sand", 1.0f, 1.0f);
        allBlocks = new Block[256];
        stone = new BlockStone(1, 1).setBreakability(1.5f).setHardness(10.0f).setSound(soundStoneFootstep);
        grass = (BlockGrass)new BlockGrass(2).setBreakability(0.6f).setSound(soundGrassFootstep);
        dirt = new BlockDirt(3, 2).setBreakability(0.5f).setSound(soundGravelFootstep);
        cobblestone = new Block(4, 16, Material.rock).setBreakability(2.0f).setHardness(10.0f).setSound(soundStoneFootstep);
        planks = new Block(5, 4, Material.wood).setBreakability(2.0f).setHardness(5.0f).setSound(soundWoodFootstep);
        sapling = new BlockSapling(6, 15).setBreakability(0.0f).setSound(soundGrassFootstep);
        bedrock = new Block(7, 17, Material.rock).setBreakability(-1.0f).setHardness(6000000.0f).setSound(soundStoneFootstep);
        waterMoving = new BlockFlowing(8, Material.water).setBreakability(100.0f).func_256_d(3);
        waterStill = new BlockStationary(9, Material.water).setBreakability(100.0f).func_256_d(3);
        lavaMoving = new BlockFlowing(10, Material.lava).setBreakability(0.0f).func_215_a(1.0f).func_256_d(255);
        lavaStill = new BlockStationary(11, Material.lava).setBreakability(100.0f).func_215_a(1.0f).func_256_d(255);
        sand = new BlockSand(12, 18).setBreakability(0.5f).setSound(soundSandFootstep);
        gravel = new BlockGravel(13, 19).setBreakability(0.6f).setSound(soundGravelFootstep);
        oreGold = new BlockOre(14, 32).setBreakability(3.0f).setHardness(5.0f).setSound(soundStoneFootstep);
        oreIron = new BlockOre(15, 33).setBreakability(3.0f).setHardness(5.0f).setSound(soundStoneFootstep);
        oreCoal = new BlockOre(16, 34).setBreakability(3.0f).setHardness(5.0f).setSound(soundStoneFootstep);
        wood = new BlockLog(17).setBreakability(2.0f).setSound(soundWoodFootstep);
        leaves = (BlockLeaves)new BlockLeaves(18, 52).setBreakability(0.2f).func_256_d(1).setSound(soundGrassFootstep);
        sponge = new BlockSponge(19).setBreakability(0.6f).setSound(soundGrassFootstep);
        glass = new BlockGlass(20, 49, Material.glass, false).setBreakability(0.3f).setSound(soundGlassFootstep);
        cloth_red = new Block(21, 144, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_orange = new Block(22, 145, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_yellow = new Block(23, 146, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_lime = new Block(24, 147, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_green = new Block(25, 148, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_teal = new Block(26, 149, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_cyan = new Block(27, 150, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_blue = new Block(28, 151, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_indigo = new Block(29, 152, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_violet = new Block(30, 153, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_lilac = new Block(31, 154, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_pink = new Block(32, 155, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_magenta = new Block(33, 156, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_darkgray = new Block(34, 157, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth = new Block(35, 64, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        cloth_lightgray = new Block(36, 158, Material.cloth).setBreakability(0.8f).setSound(soundClothFootstep);
        plantYellow = (BlockFlower)new BlockFlower(37, 13).setBreakability(0.0f).setSound(soundGrassFootstep);
        plantRed = (BlockFlower)new BlockFlower(38, 12).setBreakability(0.0f).setSound(soundGrassFootstep);
        mushroomBrown = (BlockFlower)new BlockMushroom(39, 29).setBreakability(0.0f).setSound(soundGrassFootstep).func_215_a(0.125f);
        mushroomRed = (BlockFlower)new BlockMushroom(40, 28).setBreakability(0.0f).setSound(soundGrassFootstep);
        blockGold = new BlockOreBlock(41, 39).setBreakability(3.0f).setHardness(10.0f).setSound(soundMetalFootstep);
        blockSteel = new BlockOreBlock(42, 38).setBreakability(5.0f).setHardness(10.0f).setSound(soundMetalFootstep);
        stairDouble = new BlockStep(43, true).setBreakability(2.0f).setHardness(10.0f).setSound(soundStoneFootstep);
        stairSingle = new BlockStep(44, false).setBreakability(2.0f).setHardness(10.0f).setSound(soundStoneFootstep);
        brick = new Block(45, 7, Material.rock).setBreakability(2.0f).setHardness(10.0f).setSound(soundStoneFootstep);
        tnt = new BlockTNT(46, 8).setBreakability(0.0f).setSound(soundGrassFootstep);
        bookShelf = new BlockBookshelf(47, 35).setBreakability(1.5f).setSound(soundWoodFootstep);
        cobblestoneMossy = new Block(48, 36, Material.rock).setBreakability(2.0f).setHardness(10.0f).setSound(soundStoneFootstep);
        obsidian = new BlockObsidian(49, 37).setBreakability(10.0f).setHardness(2000.0f).setSound(soundStoneFootstep);
        torchWood = new BlockTorch(50, 80).setBreakability(0.0f).func_215_a(0.9375f).setSound(soundWoodFootstep);
        fire = (BlockFire)new BlockFire(51, 31).setBreakability(0.0f).func_215_a(1.0f).setSound(soundWoodFootstep);
        mobSpawner = new BlockMobSpawner(52, 65).setBreakability(5.0f).setSound(soundMetalFootstep);
        stairCompact_Wood = new BlockStairs(53, planks);
        crate = new BlockChest(54).setBreakability(2.5f).setSound(soundWoodFootstep);
        redstoneWire = new BlockRedstoneWire(55, 84).setBreakability(0.0f).setSound(soundPowderFootstep);
        oreDiamond = new BlockOre(56, 50).setBreakability(3.0f).setHardness(5.0f).setSound(soundStoneFootstep);
        blockDiamond = new BlockOreBlock(57, 40).setBreakability(5.0f).setHardness(10.0f).setSound(soundMetalFootstep);
        workbench = new BlockWorkbench(58).setBreakability(2.5f).setSound(soundWoodFootstep);
        crops = new BlockCrops(59, 88).setBreakability(0.0f).setSound(soundGrassFootstep);
        tilledField = new BlockSoil(60).setBreakability(0.6f).setSound(soundGravelFootstep);
        stoneOvenIdle = new BlockFurnace(61, false).setBreakability(3.5f).setSound(soundStoneFootstep);
        stoneOvenActive = new BlockFurnace(62, true).setBreakability(3.5f).setSound(soundStoneFootstep).func_215_a(0.875f);
        pressurePlateWoodActive = new BlockSign(63, TileEntitySign.class, true).setBreakability(1.0f).setSound(soundWoodFootstep);
        doorWood = new BlockDoor(64, Material.wood).setBreakability(3.0f).setSound(soundWoodFootstep);
        ladder = new BlockLadder(65, 83).setBreakability(0.4f).setSound(soundWoodFootstep);
        minecartTrack = new BlockMinecartTrack(66, 128).setBreakability(0.7f).setSound(soundMetalFootstep);
        stairCompactStone = new BlockStairs(67, cobblestone);
        pressurePlateWoodIdle = new BlockSign(68, TileEntitySign.class, false).setBreakability(1.0f).setSound(soundWoodFootstep);
        lever = new BlockLever(69, 96).setBreakability(0.5f).setSound(soundWoodFootstep);
        pressurePlateStone = new BlockPressurePlate(70, Block.stone.textureIndex, EnumMobType.mobs).setBreakability(0.5f).setSound(soundStoneFootstep);
        doorSteel = new BlockDoor(71, Material.iron).setBreakability(5.0f).setSound(soundMetalFootstep);
        pressurePlateWood = new BlockPressurePlate(72, Block.planks.textureIndex, EnumMobType.everything).setBreakability(0.5f).setSound(soundWoodFootstep);
        oreRedstone = new BlockRedstoneOre(73, 51, false).setBreakability(3.0f).setHardness(5.0f).setSound(soundStoneFootstep);
        oreRedstoneGlowing = new BlockRedstoneOre(74, 51, true).func_215_a(0.625f).setBreakability(3.0f).setHardness(5.0f).setSound(soundStoneFootstep);
        torchRedstoneIdle = new BlockRedstoneTorch(75, 115, false).setBreakability(0.0f).setSound(soundWoodFootstep);
        torchRedstoneActive = new BlockRedstoneTorch(76, 99, true).setBreakability(0.0f).func_215_a(0.5f).setSound(soundWoodFootstep);
        button = new BlockButton(77, Block.stone.textureIndex).setBreakability(0.5f).setSound(soundStoneFootstep);
        snow = new BlockSnow(78, 66).setBreakability(0.1f).setSound(soundClothFootstep);
        ice = new BlockIce(79, 67).setBreakability(0.5f).func_256_d(3).setSound(soundGlassFootstep);
        blockSnow = new BlockSnowBlock(80, 66).setBreakability(0.2f).setSound(soundClothFootstep);
        cactus = new BlockCactus(81, 70).setBreakability(0.4f).setSound(soundClothFootstep);
        blockClay = new BlockClay(82, 72).setBreakability(0.6f).setSound(soundGravelFootstep);
        reed = new BlockReed(83, 73).setBreakability(0.0f).setSound(soundGrassFootstep);
        jukebox = new BlockJukeBox(84, 74).setBreakability(2.0f).setHardness(10.0f).setSound(soundStoneFootstep);
        fence = new BlockFence(85, 4).setBreakability(2.0f).setHardness(5.0f).setSound(soundWoodFootstep);
        gear = new BlockGear(86, 62).setBreakability(0.5f).setHardness(5.0f).setSound(soundPowderFootstep);
        spongeInactive = new BlockSpongeInactive(87).setBreakability(0.6f).setSound(soundGrassFootstep);
        plantBlue = (BlockFlower)new BlockFlower(88, 14).setBreakability(0.0f).setSound(soundGrassFootstep);
        int i = 0;
        while (i < 256) {
            if (allBlocks[i] != null) {
                Item.itemsList[i] = new ItemBlock(i - 256);
            }
            ++i;
        }
    }

    protected Block(int i, Material material1) {
        if (allBlocks[i] != null) {
            throw new IllegalArgumentException("Slot " + i + " is already occupied by " + allBlocks[i] + " when adding " + this);
        }
        this.material = material1;
        Block.allBlocks[i] = this;
        this.blockID = i;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        Block.opaqueCubeLookup[i] = this.isOpaqueCube();
        Block.field_341_r[i] = this.isOpaqueCube() ? 255 : 0;
        Block.field_340_s[i] = this.func_212_i();
        Block.isBlockContainer[i] = false;
    }

    protected Block(int i, int j, Material material1) {
        this(i, material1);
        this.textureIndex = j;
    }

    protected Block setSound(StepSound stepsound) {
        this.stepSound = stepsound;
        return this;
    }

    protected Block func_256_d(int i) {
        Block.field_341_r[this.blockID] = i;
        return this;
    }

    protected Block func_215_a(float f) {
        Block.field_339_t[this.blockID] = (int)(15.0f * f);
        return this;
    }

    protected Block setHardness(float f) {
        this.hardness = f * 3.0f;
        return this;
    }

    private boolean func_212_i() {
        return false;
    }

    public boolean func_242_c() {
        return true;
    }

    public int getRenderType() {
        return 0;
    }

    protected Block setBreakability(float f) {
        this.field_374_bd = f;
        if (this.hardness < f * 5.0f) {
            this.hardness = f * 5.0f;
        }
        return this;
    }

    protected void setTickRandomly(boolean flag) {
        Block.field_344_o[this.blockID] = flag;
    }

    public void setBlockBounds(float f, float f1, float f2, float f3, float f4, float f5) {
        this.blockBound0 = f;
        this.blockBound1 = f1;
        this.blockBound2 = f2;
        this.blockBound3 = f3;
        this.blockBound4 = f4;
        this.blockBound5 = f5;
    }

    public float func_241_c(IBlockAccess iblockaccess, int i, int j, int k) {
        return iblockaccess.func_598_c(i, j, k);
    }

    public boolean isVertexInBlock(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (l == 0 && this.blockBound1 > 0.0) {
            return true;
        }
        if (l == 1 && this.blockBound4 < 1.0) {
            return true;
        }
        if (l == 2 && this.blockBound2 > 0.0) {
            return true;
        }
        if (l == 3 && this.blockBound5 < 1.0) {
            return true;
        }
        if (l == 4 && this.blockBound0 > 0.0) {
            return true;
        }
        if (l == 5 && this.blockBound3 < 1.0) {
            return true;
        }
        return !iblockaccess.isBlockNormalCube(i, j, k);
    }

    public int getTextureIndex(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return this.getTextureIndex(l, iblockaccess.getBlockDmg(i, j, k));
    }

    public int getTextureIndex(int i, int j) {
        return this.getTextureIndex(i);
    }

    public int getTextureIndex(int i) {
        return this.textureIndex;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.func_1161_b((double)i + this.blockBound0, (double)j + this.blockBound1, (double)k + this.blockBound2, (double)i + this.blockBound3, (double)j + this.blockBound4, (double)k + this.blockBound5);
    }

    public void setCollisionBlock(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, ArrayList<AxisAlignedBB> arraylist) {
        AxisAlignedBB axisalignedbb1 = this.func_221_d(world, i, j, k);
        if (axisalignedbb1 != null && axisalignedbb.func_1178_a(axisalignedbb1)) {
            arraylist.add(axisalignedbb1);
        }
    }

    public AxisAlignedBB func_221_d(World world, int i, int j, int k) {
        return AxisAlignedBB.func_1161_b((double)i + this.blockBound0, (double)j + this.blockBound1, (double)k + this.blockBound2, (double)i + this.blockBound3, (double)j + this.blockBound4, (double)k + this.blockBound5);
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public boolean func_224_a(int i, boolean flag) {
        return this.renderAsNormalBlock();
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public void update(World world, int i, int j, int k, Random random) {
    }

    public void func_247_b(World world, int i, int j, int k, Random random) {
    }

    public void onBreak(World world, int i, int j, int k, int l) {
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
    }

    public int func_206_a() {
        return 10;
    }

    public void onPlace(World world, int i, int j, int k) {
    }

    public void onRemove(World world, int i, int j, int k) {
    }

    public int dropChance(Random random) {
        return 1;
    }

    public int createBlockEntity(int i, Random random) {
        return this.blockID;
    }

    public float func_225_a(EntityPlayer entityplayer) {
        if (this.field_374_bd < 0.0f) {
            return 0.0f;
        }
        if (!entityplayer.func_454_b(this)) {
            return 1.0f / this.field_374_bd / 100.0f;
        }
        return entityplayer.getMiningInhibitors(this) / this.field_374_bd / 30.0f;
    }

    public void func_259_b_(World world, int i, int j, int k, int l) {
        this.dropBlockAsItem(world, i, j, k, l, 1.0f);
    }

    public void dropBlockAsItem(World world, int i, int j, int k, int l, float f) {
        if (world.field_1026_y) {
            return;
        }
        int i1 = this.dropChance(world.field_1037_n);
        int j1 = 0;
        while (j1 < i1) {
            int k1;
            if (!(world.field_1037_n.nextFloat() > f) && (k1 = this.createBlockEntity(l, world.field_1037_n)) > 0) {
                float f1 = 0.7f;
                double d = (double)(world.field_1037_n.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
                double d1 = (double)(world.field_1037_n.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
                double d2 = (double)(world.field_1037_n.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, new ItemStack(k1));
                entityitem.field_805_c = 10;
                world.addNewEntity(entityitem);
            }
            ++j1;
        }
    }

    public float func_227_a(Entity entity) {
        return this.hardness / 5.0f;
    }

    public MovingObjectPosition func_255_a(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        this.func_238_a(world, i, j, k);
        vec3d = vec3d.addToVector(-i, -j, -k);
        vec3d1 = vec3d1.addToVector(-i, -j, -k);
        Vec3D vec3d2 = vec3d.func_1247_a(vec3d1, this.blockBound0);
        Vec3D vec3d3 = vec3d.func_1247_a(vec3d1, this.blockBound3);
        Vec3D vec3d4 = vec3d.func_1250_b(vec3d1, this.blockBound1);
        Vec3D vec3d5 = vec3d.func_1250_b(vec3d1, this.blockBound4);
        Vec3D vec3d6 = vec3d.func_1256_c(vec3d1, this.blockBound2);
        Vec3D vec3d7 = vec3d.func_1256_c(vec3d1, this.blockBound5);
        if (!this.func_244_a(vec3d2)) {
            vec3d2 = null;
        }
        if (!this.func_244_a(vec3d3)) {
            vec3d3 = null;
        }
        if (!this.func_249_b(vec3d4)) {
            vec3d4 = null;
        }
        if (!this.func_249_b(vec3d5)) {
            vec3d5 = null;
        }
        if (!this.func_251_c(vec3d6)) {
            vec3d6 = null;
        }
        if (!this.func_251_c(vec3d7)) {
            vec3d7 = null;
        }
        Vec3D vec3d8 = null;
        if (vec3d2 != null && (vec3d8 == null || vec3d.getMagnitude(vec3d2) < vec3d.getMagnitude(vec3d8))) {
            vec3d8 = vec3d2;
        }
        if (vec3d3 != null && (vec3d8 == null || vec3d.getMagnitude(vec3d3) < vec3d.getMagnitude(vec3d8))) {
            vec3d8 = vec3d3;
        }
        if (vec3d4 != null && (vec3d8 == null || vec3d.getMagnitude(vec3d4) < vec3d.getMagnitude(vec3d8))) {
            vec3d8 = vec3d4;
        }
        if (vec3d5 != null && (vec3d8 == null || vec3d.getMagnitude(vec3d5) < vec3d.getMagnitude(vec3d8))) {
            vec3d8 = vec3d5;
        }
        if (vec3d6 != null && (vec3d8 == null || vec3d.getMagnitude(vec3d6) < vec3d.getMagnitude(vec3d8))) {
            vec3d8 = vec3d6;
        }
        if (vec3d7 != null && (vec3d8 == null || vec3d.getMagnitude(vec3d7) < vec3d.getMagnitude(vec3d8))) {
            vec3d8 = vec3d7;
        }
        if (vec3d8 == null) {
            return null;
        }
        int byte0 = -1;
        if (vec3d8 == vec3d2) {
            byte0 = 4;
        }
        if (vec3d8 == vec3d3) {
            byte0 = 5;
        }
        if (vec3d8 == vec3d4) {
            byte0 = 0;
        }
        if (vec3d8 == vec3d5) {
            byte0 = 1;
        }
        if (vec3d8 == vec3d6) {
            byte0 = 2;
        }
        if (vec3d8 == vec3d7) {
            byte0 = 3;
        }
        return new MovingObjectPosition(i, j, k, byte0, vec3d8.addToVector(i, j, k));
    }

    private boolean func_244_a(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.yCoord >= this.blockBound1 && vec3d.yCoord <= this.blockBound4 && vec3d.zCoord >= this.blockBound2 && vec3d.zCoord <= this.blockBound5;
    }

    private boolean func_249_b(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.blockBound0 && vec3d.xCoord <= this.blockBound3 && vec3d.zCoord >= this.blockBound2 && vec3d.zCoord <= this.blockBound5;
    }

    private boolean func_251_c(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.blockBound0 && vec3d.xCoord <= this.blockBound3 && vec3d.yCoord >= this.blockBound1 && vec3d.yCoord <= this.blockBound4;
    }

    public void func_239_c(World world, int i, int j, int k) {
    }

    public int func_234_g() {
        return 0;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        int l = world.getBlock(i, j, k);
        return l == 0 || Block.allBlocks[l].material.func_879_d();
    }

    public boolean func_250_a(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return false;
    }

    public void func_254_a(World world, int i, int j, int k, Entity entity) {
    }

    public void func_258_d(World world, int i, int j, int k, int l) {
    }

    public void func_233_b(World world, int i, int j, int k, EntityPlayer entityplayer) {
    }

    public void func_257_a(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
    }

    public void func_238_a(IBlockAccess iblockaccess, int i, int j, int k) {
    }

    public int func_207_d(IBlockAccess iblockaccess, int i, int j, int k) {
        return 0xFFFFFF;
    }

    public boolean func_231_b(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public boolean func_209_d() {
        return false;
    }

    public void func_236_b(World world, int i, int j, int k, Entity entity) {
    }

    public boolean func_228_c(World world, int i, int j, int k, int l) {
        return false;
    }

    public void func_237_e() {
    }

    public void func_220_a_(World world, int i, int j, int k, int l) {
        this.func_259_b_(world, i, j, k, l);
    }

    public boolean canBlockStay(World world, int i, int j, int k) {
        return true;
    }

    static Class<?> _mthclass$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }

    public void goldTouch() {
    }

    public void notGoldTouch() {
    }
}

