/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.WorldClient;
import com.mojang.minecraft.level.chunk.ChunkPosition;
import com.mojang.minecraft.level.generate.noise.NibbleArray;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockContainer;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Chunk {
    public static boolean field_1540_a;
    public byte[] blocks;
    public boolean field_1538_c;
    public World field_1537_d;
    public NibbleArray data;
    public NibbleArray skylightMap;
    public NibbleArray blocklightMap;
    public byte[] heightMap;
    public int field_1532_i;
    public final int xPos;
    public final int zPos;
    public Map<ChunkPosition, TileEntity> field_1529_l = new HashMap<ChunkPosition, TileEntity>();
    public List<Entity>[] field_1528_m = new List[8];
    public boolean isTerrainPopulated = false;
    public boolean isModified = false;
    public boolean field_1525_p;
    public boolean field_1524_q = false;
    public boolean field_1523_r = false;
    public long field_1522_s = 0L;

    public Chunk(World world, int i, int j) {
        this.field_1537_d = world;
        this.xPos = i;
        this.zPos = j;
        this.heightMap = new byte[256];
        int k = 0;
        while (k < this.field_1528_m.length) {
            this.field_1528_m[k] = new ArrayList<Entity>();
            ++k;
        }
    }

    public Chunk(World world, byte[] abyte0, int i, int j) {
        this(world, i, j);
        this.blocks = abyte0;
        this.data = new NibbleArray(abyte0.length);
        this.skylightMap = new NibbleArray(abyte0.length);
        this.blocklightMap = new NibbleArray(abyte0.length);
    }

    public boolean func_1017_a(int i, int j) {
        return i == this.xPos && j == this.zPos;
    }

    public int func_999_b(int i, int j) {
        return this.heightMap[j << 4 | i] & 0xFF;
    }

    public void func_1014_a() {
    }

    public void func_1018_b() {
        int i = 127;
        int j = 0;
        while (j < 16) {
            int k = 0;
            while (k < 16) {
                int l = 127;
                int i1 = j << 11 | k << 7;
                while (l > 0 && Block.field_341_r[this.blocks[i1 + l - 1]] == 0) {
                    --l;
                }
                this.heightMap[k << 4 | j] = (byte)l;
                if (l < i) {
                    i = l;
                }
                ++k;
            }
            ++j;
        }
        this.field_1532_i = i;
        this.isModified = true;
    }

    public void func_1024_c() {
        int i = 127;
        int j = 0;
        while (j < 16) {
            int l = 0;
            while (l < 16) {
                this.heightMap[l << 4 | j] = -128;
                this.func_1003_g(j, 127, l);
                if ((this.heightMap[l << 4 | j] & 0xFF) < i) {
                    i = this.heightMap[l << 4 | j] & 0xFF;
                }
                ++l;
            }
            ++j;
        }
        this.field_1532_i = i;
        int k = 0;
        while (k < 16) {
            int i1 = 0;
            while (i1 < 16) {
                this.func_996_c(k, i1);
                ++i1;
            }
            ++k;
        }
        this.isModified = true;
    }

    private void func_996_c(int i, int j) {
        int k = this.func_999_b(i, j);
        int l = this.xPos * 16 + i;
        int i1 = this.zPos * 16 + j;
        this.func_1020_f(l - 1, i1, k);
        this.func_1020_f(l + 1, i1, k);
        this.func_1020_f(l, i1 - 1, k);
        this.func_1020_f(l, i1 + 1, k);
    }

    private void func_1020_f(int i, int j, int k) {
        int l = this.field_1537_d.func_666_c(i, j);
        if (l > k) {
            this.field_1537_d.func_616_a(EnumSkyBlock.Sky, i, k, j, i, l, j);
        } else if (l < k) {
            this.field_1537_d.func_616_a(EnumSkyBlock.Sky, i, l, j, i, k, j);
        }
        this.isModified = true;
    }

    private void func_1003_g(int i, int j, int k) {
        int l;
        int i1 = l = this.heightMap[k << 4 | i] & 0xFF;
        if (j > l) {
            i1 = j;
        }
        int j1 = i << 11 | k << 7;
        while (i1 > 0 && Block.field_341_r[this.blocks[j1 + i1 - 1]] == 0) {
            --i1;
        }
        if (i1 == l) {
            return;
        }
        this.field_1537_d.func_680_f(i, k, i1, l);
        this.heightMap[k << 4 | i] = (byte)i1;
        if (i1 < this.field_1532_i) {
            this.field_1532_i = i1;
        } else {
            int k1 = 127;
            int i2 = 0;
            while (i2 < 16) {
                int k2 = 0;
                while (k2 < 16) {
                    if ((this.heightMap[k2 << 4 | i2] & 0xFF) < k1) {
                        k1 = this.heightMap[k2 << 4 | i2] & 0xFF;
                    }
                    ++k2;
                }
                ++i2;
            }
            this.field_1532_i = k1;
        }
        int l1 = this.xPos * 16 + i;
        int j2 = this.zPos * 16 + k;
        if (i1 < l) {
            int l2 = i1;
            while (l2 < l) {
                this.skylightMap.func_770_a(i, l2, k, 15);
                ++l2;
            }
        } else {
            this.field_1537_d.func_616_a(EnumSkyBlock.Sky, l1, l, j2, l1, i1, j2);
            int i3 = l;
            while (i3 < i1) {
                this.skylightMap.func_770_a(i, i3, k, 0);
                ++i3;
            }
        }
        int j3 = 15;
        int k3 = i1;
        while (i1 > 0 && j3 > 0) {
            int l3;
            if ((l3 = Block.field_341_r[this.func_1008_a(i, --i1, k)]) == 0) {
                l3 = 1;
            }
            if ((j3 -= l3) < 0) {
                j3 = 0;
            }
            this.skylightMap.func_770_a(i, i1, k, j3);
        }
        while (i1 > 0 && Block.field_341_r[this.func_1008_a(i, i1 - 1, k)] == 0) {
            --i1;
        }
        if (i1 != k3) {
            this.field_1537_d.func_616_a(EnumSkyBlock.Sky, l1 - 1, i1, j2 - 1, l1 + 1, k3, j2 + 1);
        }
        this.isModified = true;
    }

    public int func_1008_a(int i, int j, int k) {
        return this.blocks[i << 11 | k << 7 | j];
    }

    public boolean func_1010_a(int i, int j, int k, int l, int i1) {
        byte byte0 = (byte)l;
        int j1 = this.heightMap[k << 4 | i] & 0xFF;
        int k1 = this.blocks[i << 11 | k << 7 | j] & 0xFF;
        if (k1 == l && this.data.func_771_a(i, j, k) == i1) {
            return false;
        }
        int l1 = this.xPos * 16 + i;
        int i2 = this.zPos * 16 + k;
        this.blocks[i << 11 | k << 7 | j] = byte0;
        if (k1 != 0 && !this.field_1537_d.field_1026_y && !(this.field_1537_d instanceof WorldClient)) {
            Block.allBlocks[k1].onRemove(this.field_1537_d, l1, j, i2);
        }
        this.data.func_770_a(i, j, k, i1);
        if (Block.field_341_r[byte0] != 0) {
            if (j >= j1) {
                this.func_1003_g(i, j + 1, k);
            }
        } else if (j == j1 - 1) {
            this.func_1003_g(i, j, k);
        }
        this.field_1537_d.func_616_a(EnumSkyBlock.Sky, l1, j, i2, l1, j, i2);
        this.field_1537_d.func_616_a(EnumSkyBlock.Block, l1, j, i2, l1, j, i2);
        this.func_996_c(i, k);
        if (l != 0) {
            Block.allBlocks[l].onPlace(this.field_1537_d, l1, j, i2);
        }
        this.isModified = true;
        return true;
    }

    public boolean func_1022_a(int i, int j, int k, int l) {
        byte byte0 = (byte)l;
        int i1 = this.heightMap[k << 4 | i] & 0xFF;
        int j1 = this.blocks[i << 11 | k << 7 | j] & 0xFF;
        if (j1 == l) {
            return false;
        }
        int k1 = this.xPos * 16 + i;
        int l1 = this.zPos * 16 + k;
        this.blocks[i << 11 | k << 7 | j] = byte0;
        if (j1 != 0 && !(this.field_1537_d instanceof WorldClient)) {
            Block.allBlocks[j1].onRemove(this.field_1537_d, k1, j, l1);
        }
        this.data.func_770_a(i, j, k, 0);
        if (Block.field_341_r[byte0] != 0) {
            if (j >= i1) {
                this.func_1003_g(i, j + 1, k);
            }
        } else if (j == i1 - 1) {
            this.func_1003_g(i, j, k);
        }
        this.field_1537_d.func_616_a(EnumSkyBlock.Sky, k1, j, l1, k1, j, l1);
        this.field_1537_d.func_616_a(EnumSkyBlock.Block, k1, j, l1, k1, j, l1);
        this.func_996_c(i, k);
        if (l != 0 && !this.field_1537_d.field_1026_y) {
            Block.allBlocks[l].onPlace(this.field_1537_d, k1, j, l1);
        }
        this.isModified = true;
        return true;
    }

    public int func_1021_b(int i, int j, int k) {
        return this.data.func_771_a(i, j, k);
    }

    public void func_1009_b(int i, int j, int k, int l) {
        this.isModified = true;
        this.data.func_770_a(i, j, k, l);
    }

    public int func_1025_a(EnumSkyBlock enumskyblock, int i, int j, int k) {
        if (enumskyblock == EnumSkyBlock.Sky) {
            return this.skylightMap.func_771_a(i, j, k);
        }
        if (enumskyblock == EnumSkyBlock.Block) {
            return this.blocklightMap.func_771_a(i, j, k);
        }
        return 0;
    }

    public void func_1011_a(EnumSkyBlock enumskyblock, int i, int j, int k, int l) {
        this.isModified = true;
        if (enumskyblock == EnumSkyBlock.Sky) {
            this.skylightMap.func_770_a(i, j, k, l);
        } else if (enumskyblock == EnumSkyBlock.Block) {
            this.blocklightMap.func_770_a(i, j, k, l);
        } else {
            return;
        }
    }

    public int func_1019_c(int i, int j, int k, int l) {
        int j1;
        int i1 = this.skylightMap.func_771_a(i, j, k);
        if (i1 > 0) {
            field_1540_a = true;
        }
        if ((j1 = this.blocklightMap.func_771_a(i, j, k)) > (i1 -= l)) {
            i1 = j1;
        }
        return i1;
    }

    public void func_1000_a(Entity entity) {
        int k;
        if (this.field_1524_q) {
            return;
        }
        this.field_1523_r = true;
        int i = MathHelper.floor_double(entity.posX / 16.0);
        int j = MathHelper.floor_double(entity.posZ / 16.0);
        if (i != this.xPos || j != this.zPos) {
            System.out.println("Wrong location! " + entity);
        }
        if ((k = MathHelper.floor_double(entity.posY / 16.0)) < 0) {
            k = 0;
        }
        if (k >= this.field_1528_m.length) {
            k = this.field_1528_m.length - 1;
        }
        entity.field_621_aZ = true;
        entity.field_657_ba = this.xPos;
        entity.field_656_bb = k;
        entity.field_654_bc = this.zPos;
        this.field_1528_m[k].add(entity);
    }

    public void func_1015_b(Entity entity) {
        this.func_1016_a(entity, entity.field_656_bb);
    }

    public void func_1016_a(Entity entity, int i) {
        if (i < 0) {
            i = 0;
        }
        if (i >= this.field_1528_m.length) {
            i = this.field_1528_m.length - 1;
        }
        this.field_1528_m[i].remove(entity);
    }

    public boolean func_1007_c(int i, int j, int k) {
        return j >= (this.heightMap[k << 4 | i] & 0xFF);
    }

    public TileEntity genTileEntity(int i, int j, int k) {
        ChunkPosition chunkposition = new ChunkPosition(i, j, k);
        TileEntity tileentity = this.field_1529_l.get(chunkposition);
        if (tileentity == null) {
            int l = this.func_1008_a(i, j, k);
            if (!Block.isBlockContainer[l]) {
                return null;
            }
            BlockContainer blockcontainer = (BlockContainer)Block.allBlocks[l];
            blockcontainer.onPlace(this.field_1537_d, this.xPos * 16 + i, j, this.zPos * 16 + k);
            tileentity = this.field_1529_l.get(chunkposition);
        }
        return tileentity;
    }

    public void func_1001_a(TileEntity tileentity) {
        int i = tileentity.x - this.xPos * 16;
        int j = tileentity.y;
        int k = tileentity.z - this.zPos * 16;
        this.func_1005_a(i, j, k, tileentity);
    }

    public void func_1005_a(int i, int j, int k, TileEntity tileentity) {
        ChunkPosition chunkposition = new ChunkPosition(i, j, k);
        tileentity.world = this.field_1537_d;
        tileentity.x = this.xPos * 16 + i;
        tileentity.y = j;
        tileentity.z = this.zPos * 16 + k;
        if (this.func_1008_a(i, j, k) == 0 || !(Block.allBlocks[this.func_1008_a(i, j, k)] instanceof BlockContainer)) {
            System.out.println("Attempted to place a tile entity where there was no entity tile!");
            return;
        }
        if (this.field_1538_c) {
            if (this.field_1529_l.get(chunkposition) != null) {
                this.field_1537_d.field_1049_b.remove(this.field_1529_l.get(chunkposition));
            }
            this.field_1537_d.field_1049_b.add(tileentity);
        }
        this.field_1529_l.put(chunkposition, tileentity);
    }

    public void func_1023_e(int i, int j, int k) {
        ChunkPosition chunkposition = new ChunkPosition(i, j, k);
        if (this.field_1538_c) {
            this.field_1537_d.field_1049_b.remove(this.field_1529_l.remove(chunkposition));
        }
    }

    public void func_995_d() {
        this.field_1538_c = true;
        this.field_1537_d.field_1049_b.addAll(this.field_1529_l.values());
        int i = 0;
        while (i < this.field_1528_m.length) {
            this.field_1537_d.func_636_a(this.field_1528_m[i]);
            ++i;
        }
    }

    public void func_998_e() {
        this.field_1538_c = false;
        this.field_1537_d.field_1049_b.removeAll(this.field_1529_l.values());
        int i = 0;
        while (i < this.field_1528_m.length) {
            this.field_1537_d.func_632_b(this.field_1528_m[i]);
            ++i;
        }
    }

    public void func_1006_f() {
        this.isModified = true;
    }

    public void func_994_a(Entity entity, AxisAlignedBB axisalignedbb, List<Entity> list) {
        int i = MathHelper.floor_double((axisalignedbb.minY - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.field_1702_e + 2.0) / 16.0);
        if (i < 0) {
            i = 0;
        }
        if (j >= this.field_1528_m.length) {
            j = this.field_1528_m.length - 1;
        }
        int k = i;
        while (k <= j) {
            List<Entity> list1 = this.field_1528_m[k];
            int l = 0;
            while (l < list1.size()) {
                Entity entity1 = list1.get(l);
                if (entity1 != entity && entity1.boundingBox.func_1178_a(axisalignedbb)) {
                    list.add(entity1);
                }
                ++l;
            }
            ++k;
        }
    }

    public void func_1013_a(Class<?> class1, AxisAlignedBB axisalignedbb, List<Entity> list) {
        int i = MathHelper.floor_double((axisalignedbb.minY - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.field_1702_e + 2.0) / 16.0);
        if (i < 0) {
            i = 0;
        }
        if (j >= this.field_1528_m.length) {
            j = this.field_1528_m.length - 1;
        }
        int k = i;
        while (k <= j) {
            List<Entity> list1 = this.field_1528_m[k];
            int l = 0;
            while (l < list1.size()) {
                Entity entity = list1.get(l);
                if (class1.isAssignableFrom(entity.getClass()) && entity.boundingBox.func_1178_a(axisalignedbb)) {
                    list.add(entity);
                }
                ++l;
            }
            ++k;
        }
    }

    public boolean func_1012_a(boolean flag) {
        if (this.field_1525_p) {
            return false;
        }
        if (this.field_1523_r && this.field_1537_d.worldTime != this.field_1522_s) {
            return true;
        }
        return this.isModified;
    }

    public int func_1004_a(byte[] abyte0, int i, int j, int k, int l, int i1, int j1, int k1) {
        int l1 = i;
        while (l1 < l) {
            int l2 = k;
            while (l2 < j1) {
                int l3 = l1 << 11 | l2 << 7 | j;
                int l4 = i1 - j;
                System.arraycopy(abyte0, k1, this.blocks, l3, l4);
                k1 += l4;
                ++l2;
            }
            ++l1;
        }
        this.func_1018_b();
        int i2 = i;
        while (i2 < l) {
            int i3 = k;
            while (i3 < j1) {
                int i4 = (i2 << 11 | i3 << 7 | j) >> 1;
                int i5 = (i1 - j) / 2;
                System.arraycopy(abyte0, k1, this.data.data, i4, i5);
                k1 += i5;
                ++i3;
            }
            ++i2;
        }
        int j2 = i;
        while (j2 < l) {
            int j3 = k;
            while (j3 < j1) {
                int j4 = (j2 << 11 | j3 << 7 | j) >> 1;
                int j5 = (i1 - j) / 2;
                System.arraycopy(abyte0, k1, this.blocklightMap.data, j4, j5);
                k1 += j5;
                ++j3;
            }
            ++j2;
        }
        int k2 = i;
        while (k2 < l) {
            int k3 = k;
            while (k3 < j1) {
                int k4 = (k2 << 11 | k3 << 7 | j) >> 1;
                int k5 = (i1 - j) / 2;
                System.arraycopy(abyte0, k1, this.skylightMap.data, k4, k5);
                k1 += k5;
                ++k3;
            }
            ++k2;
        }
        return k1;
    }

    public Random func_997_a(long l) {
        return new Random(this.field_1537_d.randomSeed + (long)(this.xPos * this.xPos * 4987142) + (long)(this.xPos * 5947611) + (long)(this.zPos * this.zPos) * 4392871L + (long)(this.zPos * 389711) ^ l);
    }

    public byte[] m() {
        return null;
    }
}

