/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.path;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.path.Path;
import com.mojang.minecraft.entity.path.PathEntity;
import com.mojang.minecraft.entity.path.PathPoint;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.util.MCHashTable;
import com.mojang.minecraft.util.MathHelper;

public class Pathfinder {
    public static boolean oldai = false;
    private IBlockAccess worldMap;
    private Path path = new Path();
    private MCHashTable pointMap = new MCHashTable();
    private PathPoint[] pathOptions = new PathPoint[32];

    public Pathfinder(IBlockAccess iblockaccess) {
        this.worldMap = iblockaccess;
    }

    public PathEntity createEntityPathTo(Entity entity, Entity entity1, float f) {
        return this.createEntityPathTo(entity, entity1.posX, entity1.boundingBox.minY, entity1.posZ, f);
    }

    public PathEntity createEntityPathTo(Entity entity, int i, int j, int k, float f) {
        return this.createEntityPathTo(entity, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, f);
    }

    private PathEntity createEntityPathTo(Entity entity, double d, double d1, double d2, float f) {
        this.path.func_1038_a();
        this.pointMap.func_1058_a();
        PathPoint pathpoint = this.openPoint(MathHelper.floor_double(entity.boundingBox.field_1698_a), MathHelper.floor_double(entity.boundingBox.minY), MathHelper.floor_double(entity.boundingBox.field_1704_c));
        PathPoint pathpoint1 = this.openPoint(MathHelper.floor_double(d - (double)(entity.width / 2.0f)), MathHelper.floor_double(d1), MathHelper.floor_double(d2 - (double)(entity.width / 2.0f)));
        PathPoint pathpoint2 = new PathPoint(MathHelper.func_1110_d(entity.width + 1.0f), MathHelper.func_1110_d(entity.height + 1.0f), MathHelper.func_1110_d(entity.width + 1.0f));
        PathEntity pathentity = this.func_1129_a(entity, pathpoint, pathpoint1, pathpoint2, f);
        return pathentity;
    }

    private PathEntity func_1129_a(Entity entity, PathPoint pathpoint, PathPoint pathpoint1, PathPoint pathpoint2, float f) {
        pathpoint.field_1713_f = 0.0f;
        pathpoint.field_1711_h = pathpoint.field_1712_g = pathpoint.func_1180_a(pathpoint1);
        this.path.func_1038_a();
        this.path.func_1034_a(pathpoint);
        PathPoint pathpoint3 = pathpoint;
        while (!this.path.func_1039_c()) {
            PathPoint pathpoint4 = this.path.func_1036_b();
            if (pathpoint4.field_1715_d == pathpoint1.field_1715_d) {
                return this.createEntityPath(pathpoint, pathpoint1);
            }
            if (pathpoint4.func_1180_a(pathpoint1) < pathpoint3.func_1180_a(pathpoint1)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.field_1709_j = true;
            int i = this.findPathOptions(entity, pathpoint4, pathpoint2, pathpoint1, f);
            int j = 0;
            while (j < i) {
                PathPoint pathpoint5 = this.pathOptions[j];
                float f1 = pathpoint4.field_1713_f + pathpoint4.func_1180_a(pathpoint5);
                if (!pathpoint5.func_1179_a() || f1 < pathpoint5.field_1713_f) {
                    pathpoint5.field_1710_i = pathpoint4;
                    pathpoint5.field_1713_f = f1;
                    pathpoint5.field_1712_g = pathpoint5.func_1180_a(pathpoint1);
                    if (pathpoint5.func_1179_a()) {
                        this.path.func_1035_a(pathpoint5, pathpoint5.field_1713_f + pathpoint5.field_1712_g);
                    } else {
                        pathpoint5.field_1711_h = pathpoint5.field_1713_f + pathpoint5.field_1712_g;
                        this.path.func_1034_a(pathpoint5);
                    }
                }
                ++j;
            }
        }
        if (pathpoint3 == pathpoint) {
            return null;
        }
        return this.createEntityPath(pathpoint, pathpoint3);
    }

    private int findPathOptions(Entity entity, PathPoint pathpoint, PathPoint pathpoint1, PathPoint pathpoint2, float f) {
        int i = 0;
        int j = 0;
        if (this.getVerticalOffset(entity, pathpoint.field_1718_a, pathpoint.field_1717_b + 1, pathpoint.field_1716_c, pathpoint1) > 0) {
            j = 1;
        }
        PathPoint pathpoint3 = this.getSafePoint(entity, pathpoint.field_1718_a, pathpoint.field_1717_b, pathpoint.field_1716_c + 1, pathpoint1, j);
        PathPoint pathpoint4 = this.getSafePoint(entity, pathpoint.field_1718_a - 1, pathpoint.field_1717_b, pathpoint.field_1716_c, pathpoint1, j);
        PathPoint pathpoint5 = this.getSafePoint(entity, pathpoint.field_1718_a + 1, pathpoint.field_1717_b, pathpoint.field_1716_c, pathpoint1, j);
        PathPoint pathpoint6 = this.getSafePoint(entity, pathpoint.field_1718_a, pathpoint.field_1717_b, pathpoint.field_1716_c - 1, pathpoint1, j);
        if (pathpoint3 != null && !pathpoint3.field_1709_j && pathpoint3.func_1180_a(pathpoint2) < f) {
            this.pathOptions[i++] = pathpoint3;
        }
        if (pathpoint4 != null && !pathpoint4.field_1709_j && pathpoint4.func_1180_a(pathpoint2) < f) {
            this.pathOptions[i++] = pathpoint4;
        }
        if (pathpoint5 != null && !pathpoint5.field_1709_j && pathpoint5.func_1180_a(pathpoint2) < f) {
            this.pathOptions[i++] = pathpoint5;
        }
        if (pathpoint6 != null && !pathpoint6.field_1709_j && pathpoint6.func_1180_a(pathpoint2) < f) {
            this.pathOptions[i++] = pathpoint6;
        }
        return i;
    }

    private PathPoint getSafePoint(Entity entity, int i, int j, int k, PathPoint pathpoint, int l) {
        PathPoint pathpoint1 = null;
        if (this.getVerticalOffset(entity, i, j, k, pathpoint) > 0) {
            pathpoint1 = this.openPoint(i, j, k);
        }
        if (pathpoint1 == null && this.getVerticalOffset(entity, i, j + l, k, pathpoint) > 0) {
            pathpoint1 = this.openPoint(i, j + l, k);
            j += l;
        }
        if (pathpoint1 != null) {
            int i1 = 0;
            int j1 = 0;
            while (j > 0 && (j1 = this.getVerticalOffset(entity, i, j - 1, k, pathpoint)) > 0) {
                if (j1 < 0) {
                    return null;
                }
                if (++i1 >= 4) {
                    return null;
                }
                --j;
            }
            if (j > 0) {
                pathpoint1 = this.openPoint(i, j, k);
            }
        }
        return pathpoint1;
    }

    private final PathPoint openPoint(int i, int j, int k) {
        int l = i | j << 10 | k << 20;
        PathPoint pathpoint = (PathPoint)this.pointMap.func_1057_a(l);
        if (pathpoint == null) {
            pathpoint = new PathPoint(i, j, k);
            this.pointMap.func_1061_a(l, pathpoint);
        }
        return pathpoint;
    }

    private int getVerticalOffset(Entity entity, int i, int j, int k, PathPoint pathpoint) {
        int l = i;
        while (l < i + pathpoint.field_1718_a) {
            int i1 = j;
            while (i1 < j + pathpoint.field_1717_b) {
                int j1 = k;
                while (j1 < k + pathpoint.field_1716_c) {
                    Material material = this.worldMap.getMaterialXYZ(i, j, k);
                    if (material.blocksMovement()) {
                        return 0;
                    }
                    if (material == Material.water || material == Material.lava) {
                        return -1;
                    }
                    ++j1;
                }
                ++i1;
            }
            ++l;
        }
        return 1;
    }

    private PathEntity createEntityPath(PathPoint pathpoint, PathPoint pathpoint1) {
        int i = 1;
        PathPoint pathpoint2 = pathpoint1;
        while (pathpoint2.field_1710_i != null) {
            ++i;
            pathpoint2 = pathpoint2.field_1710_i;
        }
        PathPoint[] apathpoint = new PathPoint[i];
        PathPoint pathpoint3 = pathpoint1;
        apathpoint[--i] = pathpoint3;
        while (pathpoint3.field_1710_i != null) {
            pathpoint3 = pathpoint3.field_1710_i;
            apathpoint[--i] = pathpoint3;
        }
        return new PathEntity(apathpoint);
    }
}

