/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.nbt.NBTTagCompound;

public final class ItemStack {
    public int stackSize = 0;
    public int animationsToGo;
    public int itemID;
    public int itemDmg;

    public ItemStack(Block block) {
        this(block, 1);
    }

    public ItemStack(Block block, int i) {
        this(block.blockID, i);
    }

    public ItemStack(Item item) {
        this(item, 1);
    }

    public ItemStack(Item item, int i) {
        this(item.swiftedIndex, i);
    }

    public ItemStack(int i) {
        this(i, 1);
    }

    public ItemStack(int i, int j) {
        this.itemID = i;
        this.stackSize = j;
    }

    public ItemStack(int i, int j, int k) {
        this.itemID = i;
        this.stackSize = j;
        this.itemDmg = k;
    }

    public ItemStack(NBTTagCompound nbttagcompound) {
        this.func_1096_b(nbttagcompound);
    }

    public ItemStack func_1085_a(int i) {
        this.stackSize -= i;
        return new ItemStack(this.itemID, i, this.itemDmg);
    }

    public Item func_1091_a() {
        return Item.itemsList[this.itemID];
    }

    public int func_1088_b() {
        return this.func_1091_a().func_196_a(this);
    }

    public boolean func_1090_a(EntityPlayer entityplayer, World world, int i, int j, int k, int l) {
        return this.func_1091_a().func_192_a(this, entityplayer, world, i, j, k, l);
    }

    public float func_1098_a(Block block) {
        return this.func_1091_a().func_204_a(this, block);
    }

    public ItemStack stackRightClick(World world, EntityPlayer entityplayer) {
        return this.func_1091_a().useItem(this, world, entityplayer);
    }

    public NBTTagCompound func_1086_a(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_749_a("id", (short)this.itemID);
        nbttagcompound.setByte("Count", (byte)this.stackSize);
        nbttagcompound.func_749_a("Damage", (short)this.itemDmg);
        return nbttagcompound;
    }

    public void func_1096_b(NBTTagCompound nbttagcompound) {
        this.itemID = nbttagcompound.func_745_d("id");
        this.stackSize = nbttagcompound.func_746_c("Count");
        this.itemDmg = nbttagcompound.func_745_d("Damage");
    }

    public int func_1089_c() {
        return this.func_1091_a().func_200_b();
    }

    public int getMaxDmg() {
        return Item.itemsList[this.itemID].getMaxDmg();
    }

    public void damageItem(int i) {
        this.itemDmg += i;
        if (this.itemDmg > this.getMaxDmg()) {
            --this.stackSize;
            if (this.stackSize < 0) {
                this.stackSize = 0;
            }
            this.itemDmg = 0;
        }
    }

    public void damageItemHit(EntityLiving entityliving) {
        Item.itemsList[this.itemID].damageItemHit(this, entityliving);
    }

    public void damageItemMine(int i, int j, int k, int l) {
        Item.itemsList[this.itemID].damageItemMine(this, i, j, k, l);
    }

    public int func_1095_a(Entity entity) {
        return Item.itemsList[this.itemID].func_198_a(entity);
    }

    public boolean getItemBlockEffect(Block block) {
        return Item.itemsList[this.itemID].breaking(block);
    }

    public void func_1097_a(EntityPlayer entityplayer) {
    }

    public void func_1100_b(EntityLiving entityliving) {
        Item.itemsList[this.itemID].func_201_b(this, entityliving);
    }

    public ItemStack func_1102_e() {
        return new ItemStack(this.itemID, this.stackSize, this.itemDmg);
    }
}

