/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockSnow
extends Block {
    protected BlockSnow(int i, int j) {
        super(i, j, Material.snow);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setTickRandomly(true);
    }

    @Override
    public AxisAlignedBB func_221_d(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean func_242_c() {
        return false;
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        int l = world.getBlock(i, j - 1, k);
        if (l == 0 || !Block.allBlocks[l].isOpaqueCube()) {
            return false;
        }
        return world.getMaterialXYZ(i, j - 1, k).blocksMovement();
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        this.func_314_h(world, i, j, k);
    }

    private boolean func_314_h(World world, int i, int j, int k) {
        if (!this.canPlace(world, i, j, k)) {
            this.func_259_b_(world, i, j, k, world.getBlockDmg(i, j, k));
            world.setBlock(i, j, k, 0);
            return false;
        }
        return true;
    }

    @Override
    public void func_220_a_(World world, int i, int j, int k, int l) {
        int i1 = Item.snowball.swiftedIndex;
        float f = 0.7f;
        double d = (double)(world.field_1037_n.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(world.field_1037_n.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(world.field_1037_n.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, new ItemStack(i1));
        entityitem.field_805_c = 10;
        world.addNewEntity(entityitem);
        world.setBlock(i, j, k, 0);
    }

    @Override
    public int createBlockEntity(int i, Random random) {
        return Item.snowball.swiftedIndex;
    }

    @Override
    public int dropChance(Random random) {
        return 0;
    }

    @Override
    public void update(World world, int i, int j, int k, Random random) {
        if (world.getBlockLighting(EnumSkyBlock.Block, i, j, k) > 11) {
            this.func_259_b_(world, i, j, k, world.getBlockDmg(i, j, k));
            world.setBlock(i, j, k, 0);
        }
    }

    @Override
    public boolean isVertexInBlock(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        Material material = iblockaccess.getMaterialXYZ(i, j, k);
        if (l == 1) {
            return true;
        }
        if (material == this.material) {
            return false;
        }
        return super.isVertexInBlock(iblockaccess, i, j, k, l);
    }
}

