/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockGrass
extends Block {
    private boolean goldCheck;

    protected BlockGrass(int i) {
        super(i, Material.ground);
        this.textureIndex = 3;
        this.setTickRandomly(true);
    }

    @Override
    public int getTextureIndex(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (l == 1) {
            return 0;
        }
        if (l == 0) {
            return 2;
        }
        Material material = iblockaccess.getMaterialXYZ(i, j + 1, k);
        return material != Material.snow && material != Material.builtSnow ? 3 : 68;
    }

    @Override
    public int getTextureIndex(int i) {
        if (i == 1) {
            return 0;
        }
        if (i == 0) {
            return 2;
        }
        return this.textureIndex;
    }

    @Override
    public void update(World world, int i, int j, int k, Random random) {
        int j1;
        int i1;
        int l;
        if (world.func_618_j(i, j + 1, k) < 4 && world.getMaterialXYZ(i, j + 1, k).func_881_b()) {
            if (random.nextInt(4) != 0) {
                return;
            }
            world.setBlock(i, j, k, Block.dirt.blockID);
        } else if (world.func_618_j(i, j + 1, k) >= 9 && world.getBlock(l = i + random.nextInt(3) - 1, i1 = j + random.nextInt(5) - 3, j1 = k + random.nextInt(3) - 1) == Block.dirt.blockID && world.func_618_j(l, i1 + 1, j1) >= 4 && !world.getMaterialXYZ(l, i1 + 1, j1).func_881_b()) {
            world.setBlock(l, i1, j1, Block.grass.blockID);
        }
    }

    @Override
    public void goldTouch() {
        this.goldCheck = true;
        System.out.println("I AM GOLD");
    }

    @Override
    public void notGoldTouch() {
        this.goldCheck = false;
    }

    @Override
    public int createBlockEntity(int i, Random random) {
        if (this.goldCheck) {
            return Block.grass.blockID;
        }
        return Block.dirt.createBlockEntity(0, random);
    }
}

