/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockContainer;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockFurnace
extends BlockContainer {
    private final boolean field_456_a;

    protected BlockFurnace(int i, boolean flag) {
        super(i, Material.rock);
        this.field_456_a = flag;
        this.textureIndex = 45;
    }

    @Override
    public int createBlockEntity(int i, Random random) {
        return Block.stoneOvenIdle.blockID;
    }

    @Override
    public void onPlace(World world, int i, int j, int k) {
        super.onPlace(world, i, j, k);
        this.func_284_h(world, i, j, k);
    }

    private void func_284_h(World world, int i, int j, int k) {
        int l = world.getBlock(i, j, k - 1);
        int i1 = world.getBlock(i, j, k + 1);
        int j1 = world.getBlock(i - 1, j, k);
        int k1 = world.getBlock(i + 1, j, k);
        int byte0 = 3;
        if (Block.opaqueCubeLookup[l] && !Block.opaqueCubeLookup[i1]) {
            byte0 = 3;
        }
        if (Block.opaqueCubeLookup[i1] && !Block.opaqueCubeLookup[l]) {
            byte0 = 2;
        }
        if (Block.opaqueCubeLookup[j1] && !Block.opaqueCubeLookup[k1]) {
            byte0 = 5;
        }
        if (Block.opaqueCubeLookup[k1] && !Block.opaqueCubeLookup[j1]) {
            byte0 = 4;
        }
        world.func_691_b(i, j, k, byte0);
    }

    @Override
    public int getTextureIndex(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (l == 1) {
            return Block.stone.textureIndex;
        }
        if (l == 0) {
            return Block.stone.textureIndex;
        }
        int i1 = iblockaccess.getBlockDmg(i, j, k);
        if (l != i1) {
            return this.textureIndex;
        }
        if (this.field_456_a) {
            return this.textureIndex + 16;
        }
        return this.textureIndex - 1;
    }

    @Override
    public void func_247_b(World world, int i, int j, int k, Random random) {
        if (!this.field_456_a) {
            return;
        }
        int l = world.getBlockDmg(i, j, k);
        float f = (float)i + 0.5f;
        float f1 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
        float f2 = (float)k + 0.5f;
        float f3 = 0.52f;
        float f4 = random.nextFloat() * 0.6f - 0.3f;
        if (l == 4) {
            world.func_694_a("smoke", f - f3, f1, f2 + f4, 0.0, 0.0, 0.0);
            world.func_694_a("flame", f - f3, f1, f2 + f4, 0.0, 0.0, 0.0);
        } else if (l == 5) {
            world.func_694_a("smoke", f + f3, f1, f2 + f4, 0.0, 0.0, 0.0);
            world.func_694_a("flame", f + f3, f1, f2 + f4, 0.0, 0.0, 0.0);
        } else if (l == 2) {
            world.func_694_a("smoke", f + f4, f1, f2 - f3, 0.0, 0.0, 0.0);
            world.func_694_a("flame", f + f4, f1, f2 - f3, 0.0, 0.0, 0.0);
        } else if (l == 3) {
            world.func_694_a("smoke", f + f4, f1, f2 + f3, 0.0, 0.0, 0.0);
            world.func_694_a("flame", f + f4, f1, f2 + f3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getTextureIndex(int i) {
        if (i == 1) {
            return Block.stone.blockID;
        }
        if (i == 0) {
            return Block.stone.blockID;
        }
        if (i == 3) {
            return this.textureIndex - 1;
        }
        return this.textureIndex;
    }

    @Override
    public boolean func_250_a(World world, int i, int j, int k, EntityPlayer entityplayer) {
        TileEntityFurnace tileentityfurnace = (TileEntityFurnace)world.genTileEntityWorld(i, j, k);
        entityplayer.func_453_a(tileentityfurnace);
        return true;
    }

    public static void func_285_a(boolean flag, World world, int i, int j, int k) {
        int l = world.getBlockDmg(i, j, k);
        TileEntity tileentity = world.genTileEntityWorld(i, j, k);
        if (flag) {
            world.setBlock(i, j, k, Block.stoneOvenActive.blockID);
        } else {
            world.setBlock(i, j, k, Block.stoneOvenIdle.blockID);
        }
        world.func_691_b(i, j, k, l);
        world.func_654_a(i, j, k, tileentity);
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityFurnace();
    }
}

